/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui.views;

import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.core.swtutils.SelectionDragAdapter;
import info.textgrid.lab.search.FullTextEntry;
import info.textgrid.lab.search.ItemEntry;
import info.textgrid.lab.search.LazySearchResultProvider;
import info.textgrid.lab.search.NoMatchEntry;
import info.textgrid.lab.search.ResultViewInitItem;
import info.textgrid.lab.search.ui.Activator;
import info.textgrid.lab.search.ui.views.Messages;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class ResultView
extends ViewPart {
    private TreeViewer viewer;
    private Link statusLabel;
    private Composite bottomBar;
    private TreeViewerColumn column;

    public void createPartControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 4);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        GridData cGD = new GridData();
        cGD.horizontalAlignment = 4;
        cGD.grabExcessVerticalSpace = true;
        cGD.grabExcessHorizontalSpace = true;
        cGD.verticalAlignment = 4;
        mainComposite.setLayoutData((Object)cGD);
        this.viewer = new TreeViewer(mainComposite, 268501762);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new LazySearchResultProvider());
        this.column = new TreeViewerColumn(this.viewer, 0);
        this.column.setLabelProvider((CellLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new SearchResultsLabelProvider(), (ILabelDecorator)new SearchResultsLabelDecorator(), null));
        this.column.getColumn().setResizable(true);
        this.hookDoubleClickAction();
        this.viewer.addDragSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SelectionDragAdapter((StructuredViewer)this.viewer));
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.viewer.getTree().setLinesVisible(true);
        GridData vGD = new GridData();
        vGD.horizontalAlignment = 4;
        vGD.grabExcessVerticalSpace = true;
        vGD.grabExcessHorizontalSpace = true;
        vGD.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)vGD);
        this.bottomBar = new Composite(mainComposite, 4);
        this.bottomBar.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.fillDefaults().applyTo((Control)this.bottomBar);
        this.statusLabel = new Link(this.bottomBar, 16384);
        this.statusLabel.setText(Messages.ResultView_IM_SearchNotStarted);
        this.initResultView();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.search.ui.ResultView");
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    private void makeActions() {
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IHandlerService handlerService = (IHandlerService)ResultView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("info.textgrid.lab.ui.core.commands.Open", null);
                }
                catch (CommandException e) {
                    Status status = new Status(4, "info.textgrid.lab.search.ui", String.valueOf(Messages.ResultView_EM_OpenCommand) + event, (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected void setStatusLabel(String text) {
        this.statusLabel.setText(text);
        this.bottomBar.pack();
    }

    public void fitColumnWidth() {
        int controlWidth = this.viewer.getControl().getSize().x;
        int computeWidth = this.viewer.getControl().computeSize((int)-1, (int)-1, (boolean)true).x;
        this.column.getColumn().setWidth(Math.max(controlWidth, computeWidth) + 30);
    }

    private void initResultView() {
        this.viewer.setInput((Object)new ResultViewInitItem());
    }

    static class SearchResultsLabelDecorator
    implements ILabelDecorator {
        SearchResultsLabelDecorator() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image decorateImage(Image image, Object element) {
            if (!(element instanceof ItemEntry)) {
                return null;
            }
            TGObjectReference tgoRef = ((ItemEntry)element).getTgoRef();
            try {
                if (tgoRef.getTgo().isPublic()) {
                    ImageDescriptor overlay = ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("public"));
                    Image decoratedImage = new DecorationOverlayIcon(image, overlay, 3).createImage();
                    return decoratedImage;
                }
            }
            catch (CoreException coreException) {
                return null;
            }
            return null;
        }

        public String decorateText(String text, Object element) {
            return null;
        }
    }

    static class SearchResultsLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static final StyledString.Styler MATCH_STYLER = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
        };
        private static final StyledString.Styler NOMATCH_STYLER = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
                textStyle.foreground = Display.getDefault().getSystemColor(16);
            }
        };

        SearchResultsLabelProvider() {
        }

        public Image getImage(Object element) {
            TextGridObject textGridObject;
            if (element instanceof ItemEntry && (textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class)) != null) {
                try {
                    return textGridObject.getContentType(false).getImage(true);
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "info.textgrid.lab.search.ui");
                }
            }
            return null;
        }

        public String getText(Object element) {
            return this.getStyledText(element).toString();
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return new StyledString(Messages.ResultView_IM_Searching);
            }
            if (element instanceof ItemEntry) {
                return this.getEntryLabel((ItemEntry)element);
            }
            if (element instanceof FullTextEntry) {
                return this.getFulltextLabel((FullTextEntry)element);
            }
            if (element instanceof NoMatchEntry) {
                return this.getNoMatchLabel((NoMatchEntry)element);
            }
            return new StyledString(element.toString());
        }

        private StyledString getEntryLabel(ItemEntry item) {
            TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter((Object)item, TextGridObject.class);
            StyledString styledString = new StyledString();
            try {
                String path = item.getPath();
                styledString.append(tgo.getTitle(), MATCH_STYLER).append("; ");
                if (!path.equals("")) {
                    styledString.append(item.getPath(), StyledString.DECORATIONS_STYLER).append("; ");
                }
                if (!tgo.getMetadataForReading().getGeneric().getGenerated().getProject().getValue().equals("")) {
                    styledString.append(tgo.getMetadataForReading().getGeneric().getGenerated().getProject().getValue(), StyledString.QUALIFIER_STYLER).append("; ");
                }
                styledString.append(tgo.getMetadataForReading().getGeneric().getGenerated().getDataContributor()).append("; ");
                styledString.append("(Revision " + tgo.getRevisionNumber() + ")", StyledString.DECORATIONS_STYLER);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.search.ui");
            }
            return styledString;
        }

        private StyledString getFulltextLabel(FullTextEntry item) {
            StyledString styledString = new StyledString();
            styledString.append("   ").append(item.getLeft(), StyledString.COUNTER_STYLER).append(" ");
            styledString.append(item.getMatch(), MATCH_STYLER).append(" ");
            styledString.append(item.getRight(), StyledString.COUNTER_STYLER);
            return styledString;
        }

        private StyledString getNoMatchLabel(NoMatchEntry noMatch) {
            StyledString styledString = new StyledString();
            styledString.append(noMatch.toString(), NOMATCH_STYLER);
            return styledString;
        }
    }
}

