/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.ITextGridPermission;
import info.textgrid.lab.core.tgauthclient.TgAuthClientUtilities;
import info.textgrid.lab.log.logsession;
import info.textgrid.namespaces.middleware.tgauth.AuthenticationFault;
import info.textgrid.namespaces.middleware.tgauth.GetRightsRequest;
import info.textgrid.namespaces.middleware.tgauth.OperationsetResponse;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public abstract class AbstractResource
extends PlatformObject
implements ITextGridPermission {
    @Override
    public void assertPermission(int permission, String errorMessage, Object ... arguments) throws CoreException {
        if (!this.hasPermissions(permission)) {
            throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.model", MessageFormat.format(errorMessage, arguments)));
        }
    }

    @Override
    public boolean hasPermissions(int rights) throws CoreException {
        return (this.getPermissions() & rights) == rights;
    }

    public int retrievePermissions(String resourceID) throws CoreException {
        try {
            PortTgextra tgAuth = TgAuthClientUtilities.getTgAuthServiceStub();
            GetRightsRequest request = new GetRightsRequest();
            request.setAuth(RBACSession.getInstance().getSID(false));
            request.setLog(logsession.getInstance().getloginfo());
            request.setResource(resourceID);
            OperationsetResponse response = tgAuth.getRights(request);
            int permissions = 0;
            if (response != null && response.getOperation() != null) {
                for (String permission : response.getOperation()) {
                    permissions |= AbstractResource.getNumericPermission(permission);
                }
            }
            return permissions;
        }
        catch (AuthenticationFault e) {
            throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.model", MessageFormat.format("As it appears, you do not have permissions to retrieve {0}'s permissions: {1}: {2}", this, e.getMessage(), e.getFaultInfo())));
        }
    }

    protected static int getNumericPermission(String symbolicPermission) {
        if ("create".equals(symbolicPermission)) {
            return 2;
        }
        if ("read".equals(symbolicPermission)) {
            return 1;
        }
        if ("update".equals(symbolicPermission)) {
            return 4;
        }
        if ("write".equals(symbolicPermission)) {
            return 4;
        }
        if ("publish".equals(symbolicPermission)) {
            return 16;
        }
        if ("delegate".equals(symbolicPermission)) {
            return 32;
        }
        if ("delete".equals(symbolicPermission)) {
            return 8;
        }
        return 0;
    }
}

