/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import info.textgrid.lab.core.model.TextGridObject;
import java.text.MessageFormat;
import java.util.ConcurrentModificationException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class SchedulingException
extends ConcurrentModificationException {
    private static final long serialVersionUID = -4181948447691679120L;
    private final TextGridObject object;

    public SchedulingException(TextGridObject object, String message, Object ... args) {
        super(MessageFormat.format(message, args));
        this.object = object;
    }

    public TextGridObject getObject() {
        return this.object;
    }

    public static void check(ISchedulingRule rule, TextGridObject object, String message, Object ... args) {
        Job currentJob = Job.getJobManager().currentJob();
        if (currentJob == null) {
            return;
        }
        ISchedulingRule currentRule = currentJob.getRule();
        if (currentRule == null) {
            return;
        }
        if (rule.isConflicting(currentRule)) {
            throw new SchedulingException(object, message, args);
        }
    }
}

