/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.util.DTDBatchNodeDelete;
import org.eclipse.wst.dtd.core.internal.util.DTDVisitor;

public class DTDExternalReferenceRemover
extends DTDVisitor {
    protected DTDBatchNodeDelete batchDelete;
    protected List externalElementsAndParmEntities = new ArrayList();
    protected boolean isParmEntity = false;
    protected boolean isUpdating = false;
    protected DTDNode nodeToDelete;
    protected String oldRefName = "";
    protected Object requestor;

    public synchronized void externalReferenceAboutToChange(Object requestor, Entity entity) {
        if (this.isUpdating) {
            return;
        }
        if (!entity.isParameterEntity() || !entity.isExternalEntity()) {
            return;
        }
        this.isUpdating = true;
        this.requestor = requestor;
        DTDFile dtdFile = entity.getDTDFile();
        if (this.batchDelete == null) {
            this.batchDelete = new DTDBatchNodeDelete(dtdFile);
        }
        this.visit(dtdFile);
        this.batchDelete.deleteNodes(requestor);
        this.isUpdating = false;
    }

    public boolean isMatchingName(String name) {
        return this.externalElementsAndParmEntities.contains(name);
    }

    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        String attrName = attr.getName();
        String attrType = attr.getType();
        if (this.isParameterEntityRef(attrName) && this.isMatchingName(attrName)) {
            attr.setName(this.requestor, "TempName");
        }
        if (this.isParameterEntityRef(attrType) && this.isMatchingName(attrType)) {
            attr.setType(this.requestor, Attribute.CDATA);
        }
    }

    public void visitAttributeList(AttributeList attList) {
        super.visitAttributeList(attList);
        String attListName = attList.getName();
        if (this.isParameterEntityRef(attListName) && this.isMatchingName(attListName)) {
            attList.setName(this.requestor, "TempName");
        }
    }

    public void visitElement(Element element) {
        String elementName = element.getName();
        if (this.isParameterEntityRef(elementName) && this.isMatchingName(elementName)) {
            element.setName(this.requestor, "TempName");
        }
        super.visitElement(element);
    }

    public void visitReference(CMBasicNode node) {
        super.visitReference(node);
        String refName = node.getName();
        if (this.isMatchingName(refName)) {
            this.batchDelete.addNode(node);
        }
    }
}

