/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.dictionarylinkeditor;

import info.textgrid.lab.dictionarylinkeditor.WBLemma;
import info.textgrid.lab.dictionarylinkeditor.WBLinkGroup;
import org.eclipse.core.runtime.PlatformObject;

public class WBLink
extends PlatformObject
implements Comparable<WBLink> {
    public static final String UNSAVED_TIMESTAMP = "9999";
    private WBLemma sourceLemma;
    private WBLemma targetLemma;
    private String editor = null;
    private String timestamp = null;
    private int qualityID;
    private String quality;
    private int etymRelationID;
    private int semanticRelationID;
    private String comment = "";
    private boolean manuallyAdded = false;
    private boolean touched = false;
    private int approved;
    private boolean editable = false;
    private boolean deleted = false;

    public WBLink(WBLemma sourceLemma, WBLemma targetLemma) {
        this.sourceLemma = sourceLemma;
        this.targetLemma = targetLemma;
        this.editor = "";
        this.qualityID = 4;
        this.semanticRelationID = -1;
        this.etymRelationID = -1;
        this.comment = "";
        this.timestamp = UNSAVED_TIMESTAMP;
        this.touched = true;
        this.editable = true;
        this.deleted = false;
        this.approved = 0;
        this.manuallyAdded = true;
    }

    public WBLink(WBLemma sourceLemma, WBLemma targetLemma, String editor, String timestamp, String quality, String semanticRelationID, String etymRelationID, String comment, String approved, String deleted, String editable) {
        this.sourceLemma = sourceLemma;
        this.targetLemma = targetLemma;
        this.editor = editor;
        this.timestamp = timestamp;
        this.comment = comment;
        this.quality = quality;
        if (quality.matches("^\\d+$")) {
            this.qualityID = new Integer(quality);
        }
        if (approved.matches("^\\d+$")) {
            this.approved = new Integer(approved);
        }
        this.editable = "1".equals(editable);
        this.deleted = "1".equals(deleted);
        this.semanticRelationID = semanticRelationID.matches("^\\d+$") ? new Integer(semanticRelationID) : -1;
        this.etymRelationID = etymRelationID.matches("^\\d+$") ? new Integer(etymRelationID) : -1;
    }

    public WBLemma getSourceLemma() {
        return this.sourceLemma;
    }

    public WBLemma getTargetLemma() {
        return this.targetLemma;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public int getQualityID() {
        return this.qualityID;
    }

    public String getQualityStringFromID() {
        String result = "";
        switch (this.qualityID) {
            case -1: {
                result = "noch ungespeichert";
                break;
            }
            case 0: {
                result = "Gel\u00f6scht";
                break;
            }
            case 1: {
                result = "Buch";
                break;
            }
            case 2: {
                result = "Symmetrisch";
                break;
            }
            case 3: {
                result = "Transitiv";
                break;
            }
            case 4: {
                result = "Manuell (eingerichtet)";
                break;
            }
            default: {
                result = "Berechnet (" + (100 - this.qualityID) + ")";
            }
        }
        return result;
    }

    public void setQualityID(int qualityID) {
        this.qualityID = qualityID;
    }

    public void touch(boolean touch) {
        this.touched = touch;
    }

    public boolean isTouched() {
        return this.touched;
    }

    public int getSemanticRelationID() {
        return this.semanticRelationID;
    }

    public int getEtymRelationID() {
        return this.etymRelationID;
    }

    public void setSemanticRelationID(int relationID) {
        this.semanticRelationID = relationID;
        this.touch(true);
    }

    public void setEtymRelationID(int relationID) {
        this.etymRelationID = relationID;
        this.touch(true);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.touch(true);
    }

    public String getQuality() {
        return this.quality;
    }

    public boolean immutable(String forWhom) {
        if (forWhom.equals("")) {
            return true;
        }
        return forWhom.equals("Bearbeiter") && (this.approved == 3 || !this.editable && this.approved != 1);
    }

    public int getApproved() {
        return this.approved;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isManuallyAdded() {
        return this.manuallyAdded;
    }

    public boolean isLastInHistory() {
        return WBLinkGroup.isLastOne(this.sourceLemma.getID(), this.targetLemma.getID(), this.timestamp);
    }

    @Override
    public int compareTo(WBLink o) {
        int level1 = this.targetLemma.getName().compareTo(o.getTargetLemma().getName());
        if (level1 != 0) {
            return level1;
        }
        int level2 = this.targetLemma.getWbShortName().compareTo(o.getTargetLemma().getWbShortName());
        if (level2 != 0) {
            return level2;
        }
        return this.getTimestamp().compareTo(o.getTimestamp());
    }
}

