/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.controller.TeiFactory;

import info.textgrid.lab.linkeditor.controller.TeiFactory.IElement;
import info.textgrid.lab.linkeditor.controller.TeiFactory.ISVGElement;
import info.textgrid.lab.linkeditor.model.graphics.TGShape;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class SVGShape
implements IElement,
ISVGElement {
    private String id;
    private TGShape shape;
    private String transform;
    private int imageWidth;
    private int imageHeight;
    private static String COMMA = ",";
    private static String HASHKEY = "#";

    public SVGShape(String id, TGShape shape, int imageWidth, int imageHeight) {
        this.id = id;
        this.shape = shape;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    public String getTransform() {
        return this.transform;
    }

    public void setTransform(String transform) {
        this.transform = transform;
    }

    public String getId() {
        return this.id;
    }

    public TGShape getShape() {
        return this.shape;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    @Override
    public OMElement createOMElement(OMFactory factory, OMElement parent, OMNamespace ns) {
        OMElement shapeElem = this.shape.createOMElement(factory, parent, ns, this.imageWidth, this.imageHeight);
        shapeElem.addAttribute("id", this.id, null);
        shapeElem.addAttribute("class", this.setTGLayerClassAttributeString(), null);
        return shapeElem;
    }

    private String setTGLayerClassAttributeString() {
        return String.valueOf(this.shape.getLayer()) + COMMA + this.shape.getLayerName() + COMMA + this.shape.getLayerRGB().red + HASHKEY + this.shape.getLayerRGB().green + HASHKEY + this.shape.getLayerRGB().blue;
    }
}

