/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.tools;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.linkeditor.tools.Activator;
import info.textgrid.lab.linkeditor.tools.IProjectBrowserListener;
import info.textgrid.lab.linkeditor.tools.Messages;
import info.textgrid.lab.ui.core.utils.ProjectNavigator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FetchTGObjectsDialog
extends TitleAreaDialog
implements ISelectionChangedListener {
    private IProjectBrowserListener listener = null;
    private ProjectNavigator viewer = null;
    private List<TextGridObject> selectedObjects = new ArrayList<TextGridObject>();

    public FetchTGObjectsDialog(Shell parentShell) {
        super(parentShell);
    }

    public static void openDialog(IProjectBrowserListener section) {
        FetchTGObjectsDialog dialog = new FetchTGObjectsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.listener = section;
        dialog.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        control.setLayout((Layout)new GridLayout(1, false));
        this.setTitle(Messages.FetchTGObjectsDialog_SelectTGObjects);
        Label intro = new Label(control, 64);
        intro.setLayoutData((Object)new GridData(4, 128, true, false));
        intro.setText(Messages.FetchTGObjectsDialog_PleaseSelectXmlAndImageObjects);
        this.createObjectsGroup(control);
        return control;
    }

    private void createObjectsGroup(Composite control) {
        Group objectsGroup = new Group(control, 16);
        objectsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        objectsGroup.setLayout((Layout)new GridLayout(1, true));
        GridData projectTreeData = new GridData(4, 4, true, true);
        projectTreeData.heightHint = 200;
        objectsGroup.setLayoutData((Object)projectTreeData);
        this.viewer = new ProjectNavigator((Composite)objectsGroup, TextGridProjectRoot.LEVELS.EDITOR, 2);
        this.viewer.getControl().setLayoutData((Object)projectTreeData);
        this.viewer.setXmlImageFilter();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.viewer && event.getSelection() instanceof IStructuredSelection) {
            this.selectedObjects.clear();
            for (Object object : (IStructuredSelection)event.getSelection()) {
                if (object == null) continue;
                TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter(object, TextGridObject.class);
                try {
                    if (tgo != null && (tgo.getContentTypeID().equals("text/xml") || tgo.getContentTypeID().contains("image/"))) {
                        this.selectedObjects.add(tgo);
                        this.setErrorMessage(null);
                        String message = "";
                        for (TextGridObject t : this.selectedObjects) {
                            message = String.valueOf(message) + t.getNameCandidate() + (this.selectedObjects.get(this.selectedObjects.size() - 1).equals(t) ? "" : ", ");
                        }
                        this.setMessage(String.valueOf(Messages.FetchTGObjectsDialog_SelectedObjects) + message);
                        continue;
                    }
                    this.selectedObjects.clear();
                    this.setErrorMessage(Messages.FetchTGObjectsDialog_PleaseSelectOnlyXmlAndImageObjects);
                    return;
                }
                catch (CoreException e) {
                    Activator.handleError(e);
                }
            }
        }
    }

    protected void okPressed() {
        if (this.selectedObjects != null) {
            this.listener.setSelectedTGObjectsFromDialog(this.selectedObjects.toArray(new TextGridObject[0]));
            super.okPressed();
        }
    }
}

