/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.tools;

import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.linkeditor.tools.Activator;
import info.textgrid.lab.linkeditor.tools.ImportExportUtils;
import info.textgrid.lab.linkeditor.tools.LinksObjectEditorSection;
import info.textgrid.lab.linkeditor.tools.Messages;
import info.textgrid.lab.ui.core.utils.ProjectCombo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ImportImageLinkEditorFileCombinationDialog
extends TitleAreaDialog {
    private LinksObjectEditorSection linksObjectEditor = null;
    private FileDialog dialog = null;
    private String linkEditorFileToImport;
    private TextGridProject linksObjectTarget;
    private TextGridProject imagesTarget;
    private TextGridProject xmlTarget;
    private boolean firstModifyEnabled = false;
    private boolean importAll = false;
    private boolean modify = false;
    private static final String META_SUFFIX = ".meta";
    private final Map<String, String> pathUriMap = Collections.synchronizedMap(new HashMap());

    public ImportImageLinkEditorFileCombinationDialog(Shell parentShell) {
        super(parentShell);
        this.dialog = new FileDialog(parentShell);
        this.dialog.setText("Import");
        this.dialog.setFilterExtensions(new String[]{"*.tgl", "*.*"});
        this.dialog.setFilterNames(new String[]{"LinkEditor file (*.tgl)", "All types (*.*)"});
    }

    public static void openDialog(ISelection selection) {
        TextGridProject tgProject;
        IStructuredSelection sel;
        Object obj;
        ImportImageLinkEditorFileCombinationDialog dialog = new ImportImageLinkEditorFileCombinationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) != null && obj instanceof TextGridProject && (tgProject = (TextGridProject)obj) != null) {
            dialog.linksObjectTarget = tgProject;
        }
        dialog.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        control.setLayout((Layout)new GridLayout(1, false));
        this.getShell().setText(Messages.ImportImageLinkEditorFileCombinationDialog_ImportILEFCombination);
        this.setTitle(Messages.ImportImageLinkEditorFileCombinationDialog_ImportILEFCombination);
        Group grp0 = new Group(control, 0);
        grp0.setLayoutData((Object)new GridData(4, 4, true, true));
        grp0.setLayout((Layout)new GridLayout(2, false));
        Label lbl0 = new Label((Composite)grp0, 64);
        lbl0.setLayoutData((Object)new GridData(4, 128, true, false));
        lbl0.setText(Messages.ImportImageLinkEditorFileCombinationDialog_SelectLocalImageLinkEditorFileToImport);
        new Label((Composite)grp0, 0);
        final Text txt10 = new Text((Composite)grp0, 2048);
        txt10.setLayoutData((Object)new GridData(4, 4, true, false));
        txt10.setEditable(false);
        txt10.setBackground(txt10.getDisplay().getSystemColor(1));
        Button btn10 = new Button((Composite)grp0, 8);
        btn10.setText(Messages.ImportImageLinkEditorFileCombinationDialog_Browse);
        btn10.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String result = ImportImageLinkEditorFileCombinationDialog.this.dialog.open();
                if (result != null) {
                    ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport = result;
                    txt10.setText(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport);
                    if (ImportImageLinkEditorFileCombinationDialog.this.linksObjectTarget != null) {
                        ImportImageLinkEditorFileCombinationDialog.this.setErrorMessage(null);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label((Composite)grp0, 0).setText(Messages.ImportImageLinkEditorFileCombinationDialog_TargetProject);
        new Label((Composite)grp0, 0);
        ProjectCombo projectViewer0 = new ProjectCombo((Composite)grp0, TextGridProjectRoot.LEVELS.EDITOR);
        projectViewer0.setProject(this.linksObjectTarget);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(projectViewer0.getControl());
        projectViewer0.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportImageLinkEditorFileCombinationDialog.this.linksObjectTarget = (TextGridProject)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport != null && !"".equals(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport)) {
                    ImportImageLinkEditorFileCombinationDialog.this.setErrorMessage(null);
                }
            }
        });
        new Label((Composite)grp0, 0);
        Group grp1 = new Group(control, 0);
        grp1.setLayoutData((Object)new GridData(4, 4, true, true));
        grp1.setLayout((Layout)new GridLayout(1, false));
        final Button yesNoBtn1 = new Button((Composite)grp1, 16);
        yesNoBtn1.setText(Messages.ImportImageLinkEditorFileCombinationDialog_IWantImportTheHholeImage);
        final Group grp11 = new Group((Composite)grp1, 0);
        grp11.setLayoutData((Object)new GridData(4, 4, true, true));
        grp11.setLayout((Layout)new GridLayout(2, false));
        Label lbl11 = new Label((Composite)grp11, 0);
        lbl11.setText(Messages.ImportImageLinkEditorFileCombinationDialog_TargetProjectsForImages);
        new Label((Composite)grp11, 0);
        final ProjectCombo projectViewer1 = new ProjectCombo((Composite)grp11, TextGridProjectRoot.LEVELS.EDITOR);
        projectViewer1.setProject(this.imagesTarget);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(projectViewer1.getControl());
        projectViewer1.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportImageLinkEditorFileCombinationDialog.this.imagesTarget = (TextGridProject)((IStructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        new Label((Composite)grp11, 0);
        final Group grp12 = new Group((Composite)grp1, 0);
        grp12.setLayoutData((Object)new GridData(4, 4, true, true));
        grp12.setLayout((Layout)new GridLayout(2, false));
        Label lbl12 = new Label((Composite)grp12, 0);
        lbl12.setText(Messages.ImportImageLinkEditorFileCombinationDialog_TargetProjectForXmlFiles);
        new Label((Composite)grp12, 0);
        final ProjectCombo projectViewer2 = new ProjectCombo((Composite)grp12, TextGridProjectRoot.LEVELS.EDITOR);
        projectViewer2.setProject(this.xmlTarget);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(projectViewer2.getControl());
        projectViewer2.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportImageLinkEditorFileCombinationDialog.this.xmlTarget = (TextGridProject)((IStructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        new Label((Composite)grp12, 0);
        this.setEnabledForComposite((Composite)grp11, false);
        this.setEnabledForComposite((Composite)grp12, false);
        Group grp2 = new Group(control, 0);
        grp2.setLayoutData((Object)new GridData(4, 4, true, true));
        grp2.setLayout((Layout)new GridLayout(1, false));
        final Button yesNoBtn2 = new Button((Composite)grp2, 16);
        yesNoBtn2.setText(Messages.ImportImageLinkEditorFileCombinationDialog_IWantToModifyTheReferences);
        this.linksObjectEditor = new LinksObjectEditorSection();
        this.linksObjectEditor.create((Composite)grp2);
        final Group secGrp = this.linksObjectEditor.getSectionGroup();
        this.setEnabledForComposite((Composite)secGrp, false);
        yesNoBtn1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportImageLinkEditorFileCombinationDialog.this.linksObjectTarget == null || ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport == null || "".equals(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport)) {
                    ImportImageLinkEditorFileCombinationDialog.this.setErrorMessage(Messages.ImportImageLinkEditorFileCombinationDialog_FirstYouHaveToSelectALocalImage);
                    yesNoBtn1.setSelection(false);
                    return;
                }
                ImportImageLinkEditorFileCombinationDialog.this.importAll = yesNoBtn1.getSelection();
                if (ImportImageLinkEditorFileCombinationDialog.this.importAll) {
                    ImportImageLinkEditorFileCombinationDialog.this.modify = false;
                    yesNoBtn2.setSelection(false);
                    ImportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)secGrp, ImportImageLinkEditorFileCombinationDialog.this.modify);
                }
                ImportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)grp11, ImportImageLinkEditorFileCombinationDialog.this.importAll);
                ImportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)grp12, ImportImageLinkEditorFileCombinationDialog.this.importAll);
                if (ImportImageLinkEditorFileCombinationDialog.this.importAll) {
                    if (ImportImageLinkEditorFileCombinationDialog.this.imagesTarget == null) {
                        ImportImageLinkEditorFileCombinationDialog.this.imagesTarget = ImportImageLinkEditorFileCombinationDialog.this.linksObjectTarget;
                    }
                    if (ImportImageLinkEditorFileCombinationDialog.this.xmlTarget == null) {
                        ImportImageLinkEditorFileCombinationDialog.this.xmlTarget = ImportImageLinkEditorFileCombinationDialog.this.linksObjectTarget;
                    }
                    projectViewer1.setProject(ImportImageLinkEditorFileCombinationDialog.this.imagesTarget);
                    projectViewer2.setProject(ImportImageLinkEditorFileCombinationDialog.this.xmlTarget);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        yesNoBtn2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportImageLinkEditorFileCombinationDialog.this.linksObjectTarget == null || ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport == null || "".equals(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport)) {
                    ImportImageLinkEditorFileCombinationDialog.this.setErrorMessage(Messages.ImportImageLinkEditorFileCombinationDialog_FirstYouHaveToSelectALocalImage);
                    yesNoBtn2.setSelection(false);
                    return;
                }
                ImportImageLinkEditorFileCombinationDialog.this.modify = yesNoBtn2.getSelection();
                if (ImportImageLinkEditorFileCombinationDialog.this.modify) {
                    ImportImageLinkEditorFileCombinationDialog.this.importAll = false;
                    yesNoBtn1.setSelection(false);
                    ImportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)grp11, ImportImageLinkEditorFileCombinationDialog.this.importAll);
                    ImportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)grp12, ImportImageLinkEditorFileCombinationDialog.this.importAll);
                }
                ImportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)secGrp, ImportImageLinkEditorFileCombinationDialog.this.modify);
                if (!ImportImageLinkEditorFileCombinationDialog.this.firstModifyEnabled) {
                    try {
                        ImportImageLinkEditorFileCombinationDialog.this.linksObjectEditor.setSelectedFile(new FileInputStream(new File(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport)));
                        ImportImageLinkEditorFileCombinationDialog.this.firstModifyEnabled = true;
                    }
                    catch (FileNotFoundException e1) {
                        Activator.handleError(e1, "File not found!", new Object[0]);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return control;
    }

    private void setEnabledForComposite(Composite comp, boolean enabled) {
        Control[] controlArray = comp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(enabled);
            if (c instanceof Composite) {
                this.setEnabledForComposite((Composite)c, enabled);
            }
            ++n2;
        }
    }

    protected void okPressed() {
        if (this.linksObjectTarget == null || this.linkEditorFileToImport == null || "".equals(this.linkEditorFileToImport)) {
            this.setErrorMessage(Messages.ImportImageLinkEditorFileCombinationDialog_FirstYouHaveToSelectALocalImage);
            return;
        }
        if (this.importAll && (this.imagesTarget == null || this.xmlTarget == null || "".equals(this.imagesTarget) || "".equals(this.xmlTarget))) {
            this.setErrorMessage(Messages.ImportImageLinkEditorFileCombinationDialog_FirstYouHaveToSelectATargetProject);
            return;
        }
        if (this.importAll) {
            this.pathUriMap.clear();
            Job importJob = new Job(Messages.ImportImageLinkEditorFileCombinationDialog_ImportingTheFiles){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        String[] image_uris;
                        ImportExportUtils.TGObjectAnalyzer analyzer = ImportExportUtils.getObjectAnalyzer(new FileInputStream(new File(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport)));
                        UIJob xml_j = null;
                        UIJob images_j = null;
                        final String[] xml_uris = analyzer.getTextUris();
                        if (xml_uris.length > 0) {
                            xml_j = new UIJob(Messages.ImportImageLinkEditorFileCombinationDialog_ImportingXmlFiles){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    ImportImageLinkEditorFileCombinationDialog.this.importFilesByURI(xml_uris, ImportImageLinkEditorFileCombinationDialog.this.xmlTarget);
                                    return Status.OK_STATUS;
                                }
                            };
                            xml_j.schedule();
                        }
                        if ((image_uris = analyzer.getImageUris()).length > 0) {
                            images_j = new UIJob("Importing images..."){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    ImportImageLinkEditorFileCombinationDialog.this.importFilesByURI(image_uris, ImportImageLinkEditorFileCombinationDialog.this.imagesTarget);
                                    return Status.OK_STATUS;
                                }
                            };
                            images_j.schedule();
                        }
                        try {
                            if (xml_j != null) {
                                xml_j.join();
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                        try {
                            if (images_j != null) {
                                images_j.join();
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                        ImportImageLinkEditorFileCombinationDialog.this.updateSelectedLinksObjectAndImport();
                        return Status.OK_STATUS;
                    }
                    catch (FileNotFoundException e) {
                        Activator.handleError(e);
                        return Status.CANCEL_STATUS;
                    }
                }
            };
            importJob.setUser(true);
            importJob.schedule();
        } else if (this.modify) {
            this.modifySelectedLinksObjectManuallyAndImport();
        } else {
            this.importFile(this.linkEditorFileToImport, this.linksObjectTarget);
        }
        super.okPressed();
    }

    private void updateSelectedLinksObjectAndImport() {
        Job updatingTGOJob = new Job("Updating the importing..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    String[] uris;
                    monitor.beginTask("Updating the file...", 100);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    FileInputStream in = new FileInputStream(new File(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport));
                    OMElement root = new StAXOMBuilder((InputStream)in).getDocumentElement();
                    root.serialize((OutputStream)baos);
                    monitor.worked(20);
                    String tree = baos.toString("UTF-8");
                    String replaceWith = "";
                    String[] stringArray = uris = ImportExportUtils.getObjectAnalyzer(new FileInputStream(new File(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport))).getAllUris();
                    int n = uris.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String uri = stringArray[n2];
                        replaceWith = (String)ImportImageLinkEditorFileCombinationDialog.this.pathUriMap.get(uri);
                        if (replaceWith != null && !"".equals(replaceWith)) {
                            tree = tree.replace(uri, replaceWith);
                        }
                        ++n2;
                    }
                    ImportImageLinkEditorFileCombinationDialog.this.pathUriMap.clear();
                    final String data = tree;
                    monitor.worked(20);
                    new UIJob("Importing the file(s)..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            try {
                                ImportImageLinkEditorFileCombinationDialog.this.importFile(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport, ImportImageLinkEditorFileCombinationDialog.this.linksObjectTarget, data.getBytes("UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                Activator.handleError(e);
                                return Status.CANCEL_STATUS;
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    monitor.worked(40);
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (UnsupportedEncodingException e) {
                    Activator.handleError(e);
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
                return Status.CANCEL_STATUS;
            }
        };
        updatingTGOJob.setUser(true);
        updatingTGOJob.schedule();
    }

    private void modifySelectedLinksObjectManuallyAndImport() {
        TableItem[] selectedObjectItems = this.linksObjectEditor.getFirstTable().getTable().getItems();
        TableItem[] replaceItems = this.linksObjectEditor.getSecondTable().getTable().getItems();
        final int itemsCountFirstTable = selectedObjectItems.length;
        final int itemsCountSecondTable = replaceItems.length;
        final String[] selectedObjectItemsText = new String[itemsCountFirstTable];
        final String[] replaceItemsText = new String[itemsCountSecondTable];
        int i = 0;
        while (i < itemsCountFirstTable) {
            selectedObjectItemsText[i] = selectedObjectItems[i].getText();
            ++i;
        }
        i = 0;
        while (i < itemsCountSecondTable) {
            replaceItemsText[i] = replaceItems[i].getText();
            ++i;
        }
        Job modifyingTGOJob = new Job("Modifying and importing..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask("Modifying the file...", 100);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    FileInputStream in = new FileInputStream(new File(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport));
                    OMElement root = new StAXOMBuilder((InputStream)in).getDocumentElement();
                    root.serialize((OutputStream)baos);
                    monitor.worked(20);
                    String tree = baos.toString("UTF-8");
                    String first = "";
                    String replaceWith = "";
                    int i = 0;
                    while (i < itemsCountFirstTable && i < itemsCountSecondTable) {
                        first = ImportImageLinkEditorFileCombinationDialog.this.linksObjectEditor.getObjectUriFromTable1(selectedObjectItemsText[i]);
                        replaceWith = ImportImageLinkEditorFileCombinationDialog.this.linksObjectEditor.getObjectUriFromTable2(replaceItemsText[i]);
                        tree = tree.replace(first, replaceWith);
                        ++i;
                    }
                    final String data = tree;
                    monitor.worked(20);
                    new UIJob("Importing the file(s)..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            try {
                                ImportImageLinkEditorFileCombinationDialog.this.importFile(ImportImageLinkEditorFileCombinationDialog.this.linkEditorFileToImport, ImportImageLinkEditorFileCombinationDialog.this.linksObjectTarget, data.getBytes("UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                Activator.handleError(e);
                                return Status.CANCEL_STATUS;
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    monitor.worked(40);
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (UnsupportedEncodingException e) {
                    Activator.handleError(e);
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
                return Status.CANCEL_STATUS;
            }
        };
        modifyingTGOJob.setUser(true);
        modifyingTGOJob.schedule();
    }

    private TextGridObject createTGObject(File file, TextGridProject project, boolean useMetaFiles) {
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        TGContentType contentType = null;
        if (i != -1) {
            contentType = TGContentType.findByExtension((String)fileName.substring(i + 1));
        }
        if (contentType == null) {
            contentType = TGContentType.findMatchingContentType((String)fileName.substring(i + 1));
        }
        if (contentType == null) {
            contentType = TGContentType.getContentType((String)"unknown/unknown");
        }
        TextGridObject object = TextGridObject.getNewObjectInstance((TextGridProject)project, (TGContentType)contentType);
        if (useMetaFiles) {
            File metaFile = new File(file.getParent(), String.valueOf(fileName) + META_SUFFIX);
            if (!metaFile.canRead()) {
                metaFile = new File(file.getParent(), "." + fileName + META_SUFFIX);
            }
            if (metaFile.canRead()) {
                try {
                    object.loadMetadata((InputStream)new FileInputStream(metaFile));
                }
                catch (FileNotFoundException e) {
                    Activator.handleError(e);
                }
                catch (CoreException e) {
                    Activator.handleError(e);
                }
            } else {
                TextGridObject.addDefaultMetaDataXML((TextGridObject)object, (String)(i > 0 ? fileName.substring(0, i) : fileName));
            }
        }
        return object;
    }

    private boolean importFilesByURI(final String[] paths, final TextGridProject project) {
        IRunnableWithProgress importRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(paths.length * 100));
                LinkedList<Object> failures = new LinkedList<Object>();
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    if (path.startsWith("file")) {
                        File localFile = null;
                        try {
                            localFile = new File(new URI(path));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            failures.add(new Status(2, "info.textgrid.lab.linkeditor.controller", NLS.bind((String)"Skipped {0} due to uri syntax exception.", (Object)localFile)));
                        }
                        if (progress.isCanceled()) {
                            throw new InterruptedException();
                        }
                        progress.subTask(NLS.bind((String)"Importing {0} ...", (Object)localFile));
                        TextGridObject object = ImportImageLinkEditorFileCombinationDialog.this.createTGObject(localFile, project, true);
                        if (object == null || !object.isSubmittable()) {
                            failures.add(new Status(2, "info.textgrid.lab.linkeditor.controller", NLS.bind((String)"Skipped {0} due to incomplete metadata.", (Object)localFile)));
                        } else {
                            IFile gridFile = (IFile)AdapterUtils.getAdapter((Object)object, IFile.class);
                            try {
                                gridFile.setContents((InputStream)new FileInputStream(localFile), 1, (IProgressMonitor)progress.newChild(100));
                                ImportImageLinkEditorFileCombinationDialog.this.pathUriMap.put(path, object.getURI().toString());
                            }
                            catch (FileNotFoundException e) {
                                failures.add(new Status(4, "info.textgrid.lab.linkeditor.controller", NLS.bind((String)"Local file {0} was not found.", (Object)localFile), (Throwable)e));
                            }
                            catch (CoreException e) {
                                failures.add(new MultiStatus("info.textgrid.lab.linkeditor.controller", 0, new IStatus[]{e.getStatus()}, NLS.bind((String)"Failed to import {0}: {1}", (Object)localFile, (Object)e.getLocalizedMessage()), (Throwable)e));
                            }
                        }
                    }
                    ++n2;
                }
                if (!failures.isEmpty()) {
                    MultiStatus result = new MultiStatus("info.textgrid.lab.linkeditor.controller", 0, failures.toArray(new IStatus[0]), NLS.bind((String)"{0} of {1} files could not be imported. See the details for the individual reasons.", (Object)failures.size(), (Object)paths.length), null);
                    Activator.getDefault().getLog().log((IStatus)result);
                    throw new InvocationTargetException(new CoreException((IStatus)result));
                }
            }
        };
        try {
            importRunnable.run((IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"Some files could not be imported.", null, (IStatus)((CoreException)e.getCause()).getStatus());
                return true;
            }
            Activator.handleError(e.getCause(), "An {0} occurred while importing files to the TextGridRep: {1}.\nThis comes somewhat unexpected, please file a bug report.", e.getCause(), e.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private boolean importFile(final String path, final TextGridProject project) {
        IRunnableWithProgress importRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                LinkedList<Object> failures = new LinkedList<Object>();
                File localFile = new File(path);
                if (progress.isCanceled()) {
                    throw new InterruptedException();
                }
                progress.subTask(NLS.bind((String)"Importing {0} ...", (Object)localFile));
                TextGridObject object = ImportImageLinkEditorFileCombinationDialog.this.createTGObject(localFile, project, true);
                if (object == null || !object.isSubmittable()) {
                    failures.add(new Status(2, "info.textgrid.lab.linkeditor.controller", NLS.bind((String)"Skipped {0} due to incomplete metadata.", (Object)localFile)));
                } else {
                    IFile gridFile = (IFile)AdapterUtils.getAdapter((Object)object, IFile.class);
                    try {
                        gridFile.setContents((InputStream)new FileInputStream(localFile), 1, (IProgressMonitor)progress.newChild(100));
                    }
                    catch (FileNotFoundException e) {
                        failures.add(new Status(4, "info.textgrid.lab.linkeditor.controller", NLS.bind((String)"Local file {0} was not found.", (Object)localFile), (Throwable)e));
                    }
                    catch (CoreException e) {
                        failures.add(new MultiStatus("info.textgrid.lab.linkeditor.controller", 0, new IStatus[]{e.getStatus()}, NLS.bind((String)"Failed to import {0}: {1}", (Object)localFile, (Object)e.getLocalizedMessage()), (Throwable)e));
                    }
                }
                if (!failures.isEmpty()) {
                    MultiStatus result = new MultiStatus("info.textgrid.lab.linkeditor.controller", 0, failures.toArray(new IStatus[0]), "file could not be imported. See the details for the individual reasons.", null);
                    Activator.getDefault().getLog().log((IStatus)result);
                    throw new InvocationTargetException(new CoreException((IStatus)result));
                }
            }
        };
        try {
            importRunnable.run((IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"Some files could not be imported.", null, (IStatus)((CoreException)e.getCause()).getStatus());
                return true;
            }
            Activator.handleError(e.getCause(), "An {0} occurred while importing files to the TextGridRep: {1}.\nThis comes somewhat unexpected, please file a bug report.", e.getCause(), e.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private boolean importFile(final String path, final TextGridProject project, final byte[] data) {
        IRunnableWithProgress importRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                LinkedList<Object> failures = new LinkedList<Object>();
                File localFile = new File(path);
                if (progress.isCanceled()) {
                    throw new InterruptedException();
                }
                progress.subTask(NLS.bind((String)"Importing {0} ...", (Object)localFile));
                TextGridObject object = ImportImageLinkEditorFileCombinationDialog.this.createTGObject(localFile, project, true);
                if (object == null || !object.isSubmittable()) {
                    failures.add(new Status(2, "info.textgrid.lab.linkeditor.controller", NLS.bind((String)"Skipped {0} due to incomplete metadata.", (Object)localFile)));
                } else {
                    IFile gridFile = (IFile)AdapterUtils.getAdapter((Object)object, IFile.class);
                    try {
                        gridFile.setContents((InputStream)new ByteArrayInputStream(data), 1, (IProgressMonitor)progress.newChild(100));
                    }
                    catch (CoreException e) {
                        failures.add(new MultiStatus("info.textgrid.lab.linkeditor.controller", 0, new IStatus[]{e.getStatus()}, NLS.bind((String)"Failed to import {0}: {1}", (Object)localFile, (Object)e.getLocalizedMessage()), (Throwable)e));
                    }
                }
                if (!failures.isEmpty()) {
                    MultiStatus result = new MultiStatus("info.textgrid.lab.linkeditor.controller", 0, failures.toArray(new IStatus[0]), "file could not be imported. See the details for the individual reasons.", null);
                    Activator.getDefault().getLog().log((IStatus)result);
                    throw new InvocationTargetException(new CoreException((IStatus)result));
                }
            }
        };
        try {
            importRunnable.run((IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"Some files could not be imported.", null, (IStatus)((CoreException)e.getCause()).getStatus());
                return true;
            }
            Activator.handleError(e.getCause(), "An {0} occurred while importing files to the TextGridRep: {1}.\nThis comes somewhat unexpected, please file a bug report.", e.getCause(), e.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }
}

