/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.dynamic.DocumentReader;
import org.eclipse.help.internal.dynamic.ExtensionHandler;
import org.eclipse.help.internal.dynamic.IncludeHandler;
import org.eclipse.help.internal.dynamic.ProcessorHandler;
import org.eclipse.help.internal.dynamic.XMLProcessor;
import org.eclipse.help.search.ISearchIndex;
import org.eclipse.help.search.LuceneSearchParticipant;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLSearchParticipant
extends LuceneSearchParticipant {
    private Stack stack = new Stack();
    private SAXParser parser;
    private XMLProcessor processor;
    private boolean hasFilters;

    protected abstract void handleStartElement(String var1, Attributes var2, IParsedXMLContent var3);

    protected abstract void handleEndElement(String var1, IParsedXMLContent var2);

    protected void handleStartDocument(IParsedXMLContent data) {
    }

    protected void handleEndDocument(IParsedXMLContent data) {
    }

    protected void handleProcessingInstruction(String type, IParsedXMLContent data) {
    }

    protected abstract void handleText(String var1, IParsedXMLContent var2);

    /*
     * Loose catch block
     */
    public IStatus addDocument(ISearchIndex index, String pluginId, String name, URL url, String id, Document doc) {
        IStatus iStatus;
        InputStream stream;
        block15: {
            String summary;
            stream = null;
            if (this.parser == null) {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
            }
            this.stack.clear();
            this.hasFilters = false;
            ParsedXMLContent parsed = new ParsedXMLContent(index.getLocale());
            XMLHandler handler = new XMLHandler(parsed);
            stream = url.openStream();
            stream = this.preprocess(stream, name, index.getLocale());
            this.parser.parse(stream, (DefaultHandler)handler);
            doc.add((Fieldable)new Field("contents", parsed.newContentReader()));
            doc.add((Fieldable)new Field("exact_contents", parsed.newContentReader()));
            String title = parsed.getTitle();
            if (title != null) {
                this.addTitle(title, doc);
            }
            if ((summary = parsed.getSummary()) != null) {
                doc.add((Fieldable)new Field("summary", summary, Field.Store.YES, Field.Index.NO));
            }
            if (this.hasFilters) {
                doc.add((Fieldable)new Field("filters", "true", Field.Store.YES, Field.Index.NO));
            }
            iStatus = Status.OK_STATUS;
            if (stream == null) break block15;
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            stream = null;
        }
        return iStatus;
        catch (Exception e) {
            Status status;
            block16: {
                try {
                    status = new Status(4, "org.eclipse.help.base", 4, "Exception occurred while adding document " + name + " to index.", (Throwable)e);
                    if (stream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        stream = null;
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                stream = null;
            }
            return status;
        }
    }

    protected String getTopElement() {
        return (String)this.stack.peek();
    }

    protected String getElementStackPath() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.stack.size()) {
            if (i > 0) {
                buf.append("/");
            }
            buf.append((String)this.stack.get(i));
            ++i;
        }
        return buf.toString();
    }

    protected InputStream preprocess(InputStream in, String name, String locale) {
        if (this.processor == null) {
            DocumentReader reader = new DocumentReader();
            this.processor = new XMLProcessor(new ProcessorHandler[]{new IncludeHandler(reader, locale), new ExtensionHandler(reader, locale)});
        }
        try {
            return this.processor.process(in, name, null);
        }
        catch (Throwable t) {
            String msg = "An error occured while pre-processing user assistance document \"" + name + "\" for search indexing";
            HelpBasePlugin.logError(msg, t);
            return in;
        }
    }

    protected static interface IParsedXMLContent {
        public String getLocale();

        public void setTitle(String var1);

        public void addToSummary(String var1);

        public void addText(String var1);
    }

    private static class ParsedXMLContent
    implements IParsedXMLContent {
        private StringBuffer buffer = new StringBuffer();
        private StringBuffer summary = new StringBuffer();
        private String title;
        private String locale;
        private static int SUMMARY_LENGTH = 200;

        public ParsedXMLContent(String locale) {
            this.locale = locale;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void addToSummary(String text) {
            if (this.summary.length() >= SUMMARY_LENGTH) {
                return;
            }
            if (this.summary.length() > 0) {
                this.summary.append(" ");
            }
            this.summary.append(text);
            if (this.summary.length() > SUMMARY_LENGTH) {
                this.summary.delete(SUMMARY_LENGTH, this.summary.length());
            }
        }

        public void addText(String text) {
            if (this.buffer.length() > 0) {
                this.buffer.append(" ");
            }
            this.buffer.append(text);
        }

        public Reader newContentReader() {
            return new StringReader(this.buffer.toString());
        }

        public String getSummary() {
            String header;
            String summaryStr = this.summary.toString();
            if (this.title != null && summaryStr.length() >= this.title.length() && (header = summaryStr.substring(0, this.title.length())).equalsIgnoreCase(this.title)) {
                return summaryStr.substring(this.title.length()).trim();
            }
            return summaryStr;
        }

        public String getTitle() {
            return this.title;
        }
    }

    private class XMLHandler
    extends DefaultHandler {
        public ParsedXMLContent data;

        public XMLHandler(ParsedXMLContent data) {
            this.data = data;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            XMLSearchParticipant.this.stack.push(qName);
            XMLSearchParticipant.this.handleStartElement(qName, attributes, this.data);
            if (attributes.getValue("filter") != null || qName.equalsIgnoreCase("filter")) {
                XMLSearchParticipant.this.hasFilters = true;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            XMLSearchParticipant.this.handleEndElement(qName, this.data);
            String top = (String)XMLSearchParticipant.this.stack.peek();
            if (top != null && top.equals(qName)) {
                XMLSearchParticipant.this.stack.pop();
            }
        }

        public void startDocument() throws SAXException {
            XMLSearchParticipant.this.handleStartDocument(this.data);
        }

        public void endDocument() throws SAXException {
            XMLSearchParticipant.this.handleEndDocument(this.data);
        }

        public void processingInstruction(String target, String pidata) throws SAXException {
            XMLSearchParticipant.this.handleProcessingInstruction(target, this.data);
        }

        public void characters(char[] characters, int start, int length) throws SAXException {
            if (length == 0) {
                return;
            }
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < length) {
                buff.append(characters[start + i]);
                ++i;
            }
            String text = buff.toString();
            if (text.trim().length() > 0) {
                XMLSearchParticipant.this.handleText(text, this.data);
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }
    }
}

