/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.model.links;

import info.textgrid.lab.linkeditor.model.graphics.TGRectangle;
import info.textgrid.lab.linkeditor.model.links.ILink;
import org.eclipse.jface.text.source.Annotation;

public class RectLink
implements ILink {
    private TGRectangle rect = null;
    private String textUri = null;
    private String startAnchorId;
    private String endAnchorId;
    private boolean visible = true;
    private Annotation selectedAnnotation = null;
    private Annotation unselectedAnnotation = null;

    public RectLink(TGRectangle rect, String startAnchorId, String endAnchorId, String textUri, boolean visible) {
        this.rect = rect;
        this.startAnchorId = startAnchorId;
        this.endAnchorId = endAnchorId;
        this.rect.setLinked(true);
        this.textUri = textUri;
        this.visible = visible;
        rect.setAssocLink(this);
    }

    public boolean equals(Object obj) {
        RectLink other = null;
        if (!(obj instanceof RectLink)) {
            return false;
        }
        other = (RectLink)obj;
        return this.rect.equals(other.rect) && this.startAnchorId.equals(other.startAnchorId) && this.endAnchorId.equals(other.endAnchorId) && this.textUri.equals(other.textUri);
    }

    @Override
    public boolean equalsExceptShape(ILink link) {
        if (!(link instanceof RectLink)) {
            return false;
        }
        RectLink other = (RectLink)link;
        return this.rect.getImageUri().equals(other.rect.getImageUri()) && this.startAnchorId.equals(other.startAnchorId) && this.endAnchorId.equals(other.endAnchorId) && this.textUri.equals(other.textUri);
    }

    @Override
    public String getCoords() {
        return String.valueOf(this.rect.getRectangle().x) + "," + this.rect.getRectangle().y + "," + this.rect.getRectangle().width + "," + this.rect.getRectangle().height;
    }

    @Override
    public String getLink() {
        return String.valueOf(this.getCoords()) + ";" + this.getTextUri() + ";" + this.getImageUri() + ";" + this.getStartAnchorId() + ";" + this.getEndAnchorId();
    }

    @Override
    public TGRectangle getShape() {
        return this.rect;
    }

    @Override
    public String getImageUri() {
        return this.rect.getImageUri();
    }

    @Override
    public String getTextUri() {
        return this.textUri;
    }

    @Override
    public void setImageUri(String uri) {
        this.rect.setImageUri(uri);
    }

    @Override
    public void setTextUri(String uri) {
        this.textUri = uri;
    }

    @Override
    public String getEndAnchorId() {
        return this.endAnchorId;
    }

    @Override
    public String getStartAnchorId() {
        return this.startAnchorId;
    }

    @Override
    public void setEndAnchorId(String endAnchorId) {
        this.endAnchorId = endAnchorId;
    }

    @Override
    public void setStartAnchorId(String startAnchorId) {
        this.startAnchorId = startAnchorId;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setSelectedAnnotation(Annotation anno) {
        this.selectedAnnotation = anno;
    }

    @Override
    public void setUnselectedAnnotation(Annotation anno) {
        this.unselectedAnnotation = anno;
    }

    @Override
    public Annotation getSelectedAnnotation() {
        return this.selectedAnnotation;
    }

    @Override
    public Annotation getUnselectedAnnotation() {
        return this.unselectedAnnotation;
    }
}

