/*
 * Decompiled with CFR 0.152.
 */
package com.logabit.xlayout;

import com.logabit.xlayout.CachedDocumentFactory;
import com.logabit.xlayout.ControlHandlerConfig;
import com.logabit.xlayout.ControlNotFoundException;
import com.logabit.xlayout.Messages;
import com.logabit.xlayout.ParseException;
import com.logabit.xlayout.handlers.ButtonControlHandler;
import com.logabit.xlayout.handlers.ComplexRepeatControlHandler;
import com.logabit.xlayout.handlers.CustomControlHandler;
import com.logabit.xlayout.handlers.HandlerElement;
import com.logabit.xlayout.handlers.IControlHandler;
import com.logabit.xlayout.handlers.MoreControlHandler;
import com.logabit.xlayout.handlers.RepeatControlHandler;
import com.logabit.xlayout.handlers.SourceControlHandler;
import com.logabit.xlayout.handlers.SpecificControlHandler;
import com.logabit.xlayout.handlers.StandaloneGroupControlHandler;
import com.logabit.xlayout.handlers.SwitchControlHandler;
import com.logabit.xlayout.handlers.TextgridDateControlHandler;
import com.logabit.xlayout.source.XLayoutSource;
import com.logabit.xlayout.source.XLayoutSourceResolver;
import com.logabit.xlayout.utils.AttributeHelper;
import com.logabit.xlayout.utils.ConvertHelper;
import com.logabit.xlayout.utils.DurableStack;
import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.IMetadataPart;
import info.textgrid.lab.core.metadataeditor.elements.AdvancedControlElement;
import info.textgrid.lab.core.metadataeditor.elements.ComplexRepeatControlElement;
import info.textgrid.lab.core.metadataeditor.elements.CustomControlElement;
import info.textgrid.lab.core.metadataeditor.elements.ICheckableElement;
import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableComposite;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableControl;
import info.textgrid.lab.core.metadataeditor.elements.MoreControlElement;
import info.textgrid.lab.core.metadataeditor.elements.RepeatControlElement;
import info.textgrid.lab.core.metadataeditor.elements.SourceControlElement;
import info.textgrid.lab.core.metadataeditor.elements.SpecificControlElement;
import info.textgrid.lab.core.metadataeditor.elements.StandaloneGroupControlElement;
import info.textgrid.lab.core.metadataeditor.elements.SwitchControlElement;
import info.textgrid.lab.core.metadataeditor.elements.SwitchGroup;
import info.textgrid.lab.core.metadataeditor.elements.TextgridDateControlElement;
import info.textgrid.lab.core.metadataeditor.utils.AddItems;
import info.textgrid.lab.core.metadataeditor.utils.MetadataPath;
import info.textgrid.lab.core.metadataeditor.utils.OMCreator;
import info.textgrid.lab.core.metadataeditor.utils.OMItem;
import info.textgrid.lab.core.metadataeditor.utils.OMReader;
import info.textgrid.lab.core.metadataeditor.utils.OMUtil;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.namespaces.middleware.tgsearch.EntryType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.jaxen.JaxenException;

public class XLayout {
    private static final String NAMESPACE_URI = "http://logabit.com/xlayout/controls/1.0";
    private static final String NAMESPACE_URI_DEPRECATED = "http://logabit.com/xlayout/1.0";
    private static final String TG_NAMESPACE_URI = "http://textgrid.de/xlayout/controls";
    private static final String ELEMENT_TR = "tr";
    private static final String ELEMENT_TD = "td";
    private static final String ELEMENT_TABLE = "table";
    private static final String ATTR_COLSPAN = "colspan";
    private static final String ATTR_ROWSPAN = "rowspan";
    private static final String ATTR_ALIGN = "align";
    private static final String ATTR_VALIGN = "valign";
    private static final String ATTR_ID = "id";
    private static final String ATTR_HEIGHT = "height";
    private static final String ATTR_WIDTH = "width";
    private static final String ELEMENT_INCLUDE = "include";
    private static final String ELEM_ROOT = "xlayout";
    public static final String ATTR_ELEMENT_NAME = "element_name";
    public static final String ATTR_RELATED_ATTRIBUTE_NAME = "related_to";
    public static final String ATTR_INPUT_TYPE = "input_type";
    public static final String ATTR_REQUIRED = "required";
    public static final String ATTR_MULTI_LINES = "multi_lines";
    public static final String ATTR_CATEGORY = "category";
    public static final String ATTR_OPTIONAL = "optional";
    public static final String ATTR_ITEMS = "items";
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_AUTO_COMPLETION = "auto_completion";
    private Map<String, ControlHandlerConfig> controlHandlerConfigs = new HashMap<String, ControlHandlerConfig>();
    private boolean throwExceptionIfControlNotFound = false;
    private Map<String, Control> controlsMap = new HashMap<String, Control>();
    private DurableStack<Composite> parentsStack = new DurableStack();
    private Stack<XLayoutSource> xLayoutSourceStack = new Stack();
    private XLayoutSourceResolver sourceResolver;
    private ClassLoader resourceClassLoader;
    private FormToolkit toolkit = null;
    private ScrolledForm form = null;
    private RepeatControlElement repElement = null;
    private ComplexRepeatControlElement complexRepElement = null;
    private TextgridDateControlElement tgDateElement = null;
    private SpecificControlElement specificElement = null;
    private CustomControlElement customElement = null;
    private SwitchControlElement switchElement = null;
    private MoreControlElement moreElement = null;
    private StandaloneGroupControlElement standaloneElement = null;
    private SourceControlElement sourceElement = null;
    private StandaloneGroupControlElement editionLinksElement = null;
    private ArrayList<IControl> controlElements = new ArrayList();
    private SwitchGroup switchGrp1;
    private SwitchGroup switchGrp2;
    private SwitchGroup currentSwitchGrp;
    private boolean doRepeat = false;
    private boolean doComplexRepeat = false;
    private boolean doCustom = false;
    private boolean doSpecific = false;
    private boolean doSwitch = false;
    private boolean doMore = false;
    private boolean doStandaloneGroup = false;
    private boolean doSource = false;
    private boolean doCollectSourceElements = false;
    private SourceControlElement collectingSourceElement = null;
    private ArrayList<OMItem> omItems_provided = new ArrayList();
    private ArrayList<OMItem> omItems_specific = new ArrayList();
    private ArrayList<OMItem> omItems_custom = new ArrayList();
    private static OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private OMElement objectOMElem = null;
    private OMElement genericOMElem = null;
    private OMElement providedOMElem = null;
    private OMElement generatedOMElem = null;
    private OMElement specificOMElem = null;
    private OMElement templateEditorOM = null;
    private OMElement customOMElem = null;
    private OMElement relationsOMElem = null;
    private OMCreator omCreator_provided = new OMCreator();
    private OMCreator omCreator_specific = new OMCreator();
    private OMCreator omCreator_custom = new OMCreator();
    private OMReader omReader_provided = new OMReader();
    private OMReader omReader_specific = new OMReader();
    private OMReader omReader_custom = new OMReader();
    private OMNamespace tgNS = omFactory.createOMNamespace("http://textgrid.info/namespaces/metadata/core/2010", "ns3");
    private OMNamespace customNS = omFactory.createOMNamespace(TextGridObject.CUSTOM_NAMESPACE, "cns");
    private static String templateEditorElementName = "templateEditor";
    private boolean modified = false;
    private IMetadataPart metadataPart = null;
    private boolean showButtons = true;
    private Map<String, ICheckableElement> pathControlsMap = new HashMap<String, ICheckableElement>();
    private String currentPath = "/object/generic/provided/";
    private Label infoLabel = null;
    private Label elemLabel = null;
    private String specificElementName = null;
    private boolean isDisposed = false;

    public SourceControlElement getCollectingSourceElement() {
        return this.collectingSourceElement;
    }

    public void setCollectingSourceElement(SourceControlElement collectingSourceElement) {
        this.collectingSourceElement = collectingSourceElement;
    }

    public boolean isDoCollectSourceElements() {
        return this.doCollectSourceElements;
    }

    public void setDoCollectSourceElements(boolean doCollectSourceElements) {
        this.doCollectSourceElements = doCollectSourceElements;
    }

    protected XLayout(Map<String, ControlHandlerConfig> handlerConfigs, ClassLoader resourceClassLoader) {
        this.controlHandlerConfigs = handlerConfigs;
        this.resourceClassLoader = resourceClassLoader;
        this.sourceResolver = new XLayoutSourceResolver(resourceClassLoader);
    }

    public Control getControl(String id) {
        if (this.throwExceptionIfControlNotFound && !this.controlsMap.containsKey(id)) {
            throw new ControlNotFoundException(NLS.bind((String)"No control with id '{0}' found in layout '{1}'!", (Object)id, (Object)this.xLayoutSourceStack.peek().getHint()));
        }
        return this.controlsMap.get(id);
    }

    public void setThrowExceptionIfControlNotFound(boolean throwException) {
        this.throwExceptionIfControlNotFound = throwException;
    }

    public boolean isThrowExceptionIfControlNotFound() {
        return this.throwExceptionIfControlNotFound;
    }

    public void draw(Composite parent, XLayoutSource source, String type, boolean showButtons) {
        this.showButtons = showButtons;
        this.specificElementName = type;
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.form.getBody().setLayoutData((Object)new GridData(4, 2, true, false));
        this.form.setBackground(parent.getBackground());
        this.startParsing(source, this.form.getBody());
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    private void startParsing(XLayoutSource xsource, Composite parent) {
        this.xLayoutSourceStack.push(xsource);
        this.parentsStack.push(parent);
        Document doc = CachedDocumentFactory.getDocument(xsource);
        this.parseDocument(doc);
        this.parentsStack.pop();
        this.xLayoutSourceStack.pop();
    }

    private void parseDocument(Document doc) {
        Element root = doc.getRootElement();
        if (!ELEM_ROOT.equals(root.getName())) {
            throw new ParseException(NLS.bind((String)"The XLayout file '{0}' must contain the root element '{1}'!", (Object)this.xLayoutSourceStack.peek().getHint(), (Object)ELEM_ROOT));
        }
        this.controlsMap.clear();
        List tableElems = root.elements();
        for (Element elem : tableElems) {
            if (ELEMENT_TABLE.equals(elem.getName())) {
                this.parseTable(elem, null);
                continue;
            }
            if (!ELEMENT_INCLUDE.equals(elem.getName())) continue;
            this.parseInclude(elem);
        }
    }

    private void parseInclude(Element includeElement) {
        String uriString = includeElement.attributeValue("uri");
        try {
            XLayoutSource xsource = this.sourceResolver.resolve(uriString);
            this.startParsing(xsource, (Composite)this.parentsStack.peek());
        }
        catch (Exception e) {
            throw new ParseException(NLS.bind((String)"Error including '{0}' into '{1}'!", (Object)uriString, (Object)this.xLayoutSourceStack.peek().getHint()), e);
        }
    }

    public Composite parseTable(Element tableElement, Composite parent) throws ParseException {
        ScrolledComposite sc;
        boolean isSC = false;
        if (parent == null) {
            isSC = true;
            String styleAttr = AttributeHelper.getAsString(tableElement, "style", null);
            int style = ConvertHelper.convertToSWTStyle(styleAttr, 0);
            sc = new ScrolledComposite((Composite)this.parentsStack.peek(), 0x300 | style);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            parent = new Composite((Composite)sc, 0);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            parent.setLayoutData((Object)data);
            sc.setContent((Control)parent);
        }
        this.parentsStack.push(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        List trList = tableElement.selectNodes(ELEMENT_TR);
        for (Element trElement : trList) {
            this.parseRows(trElement);
        }
        if (isSC && parent.getParent() instanceof ScrolledComposite) {
            sc = (ScrolledComposite)parent.getParent();
            sc.setMinSize(parent.computeSize(-1, -1));
            parent.layout();
        }
        return (Composite)this.parentsStack.pop();
    }

    private void parseRows(Element trElement) throws ParseException {
        List tdList = trElement.selectNodes(ELEMENT_TD);
        for (Element tdElement : tdList) {
            this.parseColumn(tdElement);
        }
        this.elemLabel = null;
    }

    private void parseColumn(Element tdElement) throws ParseException {
        Composite composite = new Composite((Composite)this.parentsStack.peek(), 0);
        GridLayout layout = new GridLayout();
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.setGridData((Control)composite, tdElement);
        this.parentsStack.push(composite);
        for (Object ele : tdElement.elements()) {
            if (!(ele instanceof Element)) continue;
            Element element = (Element)ele;
            this.parseTableData(element);
            ++layout.numColumns;
        }
        this.parentsStack.pop();
    }

    private void parseTableData(Element dataElement) throws ParseException {
        String nameSpaceUri = dataElement.getQName().getNamespaceURI();
        if (NAMESPACE_URI.equals(nameSpaceUri) || TG_NAMESPACE_URI.equals(nameSpaceUri)) {
            String type;
            AdvancedControlElement advCon;
            Object t;
            Composite parent = (Composite)this.parentsStack.peek();
            String controlName = dataElement.getQName().getName();
            ControlHandlerConfig handlerConfig = this.controlHandlerConfigs.get(controlName);
            if (handlerConfig == null) {
                throw new ParseException(NLS.bind((String)"No handler for control element with name '{0}' found!", (Object)controlName));
            }
            HandlerElement handlerElement = this.createHandlerElement(dataElement);
            IControlHandler handler = handlerConfig.getControlHandlerInstance(this.resourceClassLoader);
            if (!this.showButtons && handler instanceof ButtonControlHandler && !"true".equals(dataElement.attributeValue("force"))) {
                return;
            }
            Control control = handler.createControl(parent, handlerElement, this, dataElement);
            handler.configureControl(control, handlerElement);
            control.setLayoutData((Object)new GridData(4, 2, true, false));
            String id = dataElement.attributeValue(ATTR_ID);
            if (control instanceof Label) {
                if (id == null) {
                    return;
                }
                if (!"lblInfo".equals(id)) {
                    this.elemLabel = (Label)control;
                } else {
                    this.infoLabel = (Label)control;
                }
            }
            if (control instanceof ProgressBar || control instanceof Sash || control instanceof Scale || control instanceof Table || control instanceof Tree) {
                Activator.handleWarning(new RuntimeException(), NLS.bind((String)Messages.XLayout_notTestedWarning, (Object)dataElement.getName()), new Object[0]);
            } else if (control instanceof Text) {
                t = (Text)control;
                t.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        XLayout.this.modified = true;
                    }
                });
                t.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        XLayout.this.fireFocusEvent();
                    }
                });
            } else if (control instanceof Combo || control instanceof org.eclipse.swt.widgets.List) {
                t = dataElement.attributeValue(ATTR_ITEMS);
                if (t == null) {
                    AddItems.addItemsToControl(control, dataElement);
                }
                if (control instanceof Combo) {
                    Combo c = (Combo)control;
                    if (t != null) {
                        if ("agents".equals(t)) {
                            AddItems.addAgentItems(c);
                        } else if ("scripts".equals(t)) {
                            AddItems.addScriptItems(c);
                        }
                    }
                    c.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            XLayout.this.modified = true;
                        }
                    });
                    c.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            XLayout.this.fireFocusEvent();
                        }
                    });
                } else if (control instanceof org.eclipse.swt.widgets.List) {
                    org.eclipse.swt.widgets.List l = (org.eclipse.swt.widgets.List)control;
                    l.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            XLayout.this.modified = true;
                        }
                    });
                    l.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            XLayout.this.fireFocusEvent();
                        }
                    });
                }
            } else if ("group".equals(dataElement.getName()) && this.doSwitch) {
                this.currentSwitchGrp = new SwitchGroup(id, dataElement);
                control.setParent(this.currentSwitchGrp.getComposite());
                if (this.switchGrp1 == null) {
                    this.switchGrp1 = this.currentSwitchGrp;
                } else {
                    this.switchGrp2 = this.currentSwitchGrp;
                }
            } else {
                if ("group".equals(dataElement.getName()) && this.doSource) {
                    this.sourceElement.addElement(dataElement);
                    control.dispose();
                    return;
                }
                if (control instanceof Section || control instanceof Composite) {
                    if (handler instanceof StandaloneGroupControlHandler) {
                        this.standaloneElement = new StandaloneGroupControlElement(id, control, this.form, this.toolkit, this);
                        if ("grpEditionLinks_show".equals(id)) {
                            this.editionLinksElement = this.standaloneElement;
                        } else if (!(this.doCustom || this.doSpecific || this.doMore || this.doComplexRepeat || this.doSource || this.doCollectSourceElements)) {
                            this.omItems_provided.add(new OMItem(this.standaloneElement));
                        }
                    } else if (handler instanceof RepeatControlHandler) {
                        this.repElement = new RepeatControlElement(id, this.form, control, dataElement, this.toolkit, this);
                        if (!(this.doCustom || this.doSpecific || this.doMore || this.doComplexRepeat || this.doSource || this.doCollectSourceElements)) {
                            this.omItems_provided.add(new OMItem(this.repElement));
                        }
                    } else if (handler instanceof ComplexRepeatControlHandler) {
                        this.complexRepElement = new ComplexRepeatControlElement(id, this.form, control, dataElement, this.toolkit, this);
                        if (!(this.doCustom || this.doSpecific || this.doMore || this.doSource || this.doCollectSourceElements)) {
                            this.omItems_provided.add(new OMItem(this.complexRepElement));
                        }
                    } else if (handler instanceof SwitchControlHandler) {
                        this.switchElement = new SwitchControlElement(id, this.form, control, dataElement, this.toolkit, this);
                        if (!(this.doCustom || this.doSpecific || this.doMore || this.doComplexRepeat || this.doSource || this.doCollectSourceElements)) {
                            this.omItems_provided.add(new OMItem(this.switchElement));
                        }
                    } else if (handler instanceof TextgridDateControlHandler) {
                        this.tgDateElement = new TextgridDateControlElement(id, this.form, control, dataElement, this.toolkit, this);
                        if (!(this.doCustom || this.doSpecific || this.doMore || this.doComplexRepeat || this.doSource || this.doCollectSourceElements)) {
                            this.omItems_provided.add(new OMItem(this.tgDateElement));
                        }
                    } else if (handler instanceof SourceControlHandler) {
                        this.sourceElement = new SourceControlElement(id, this.form, control, dataElement, this.toolkit, this);
                        if (!(this.doCustom || this.doSpecific || this.doMore || this.doCollectSourceElements)) {
                            this.omItems_provided.add(new OMItem(this.sourceElement));
                        }
                    } else if (handler instanceof MoreControlHandler) {
                        this.moreElement = new MoreControlElement(id, this.form, control, dataElement, this.toolkit, this);
                        this.doMore = true;
                        this.parseTable(dataElement.element(ELEMENT_TABLE), this.moreElement.getBody());
                        this.doMore = false;
                        if (this.doCollectSourceElements) {
                            this.collectingSourceElement.addControl(this.moreElement);
                        } else {
                            this.controlElements.add(this.moreElement);
                        }
                        if (!(this.doCustom || this.doSpecific || this.doCollectSourceElements)) {
                            this.omItems_provided.add(new OMItem(this.moreElement));
                        }
                    } else if (handler instanceof SpecificControlHandler) {
                        this.specificElement = new SpecificControlElement(id, this.form, control, dataElement);
                        this.omItems_specific.add(new OMItem(this.specificElement));
                        this.controlElements.add(this.specificElement);
                    } else if (handler instanceof CustomControlHandler) {
                        this.customElement = new CustomControlElement(id, this.form, control, dataElement);
                        this.omItems_custom.add(new OMItem(this.customElement));
                        this.controlElements.add(this.customElement);
                    }
                }
            }
            if (id == null) {
                throw new ParseException(NLS.bind((String)Messages.XLayout_elementMustContainAttribute, (Object)dataElement.getQualifiedName(), (Object)ATTR_ID));
            }
            if (this.doStandaloneGroup) {
                if (this.standaloneElement != null) {
                    String required;
                    advCon = new AdvancedControlElement(control, id, dataElement.attributeValue(ATTR_ELEMENT_NAME), dataElement.attributeValue(ATTR_RELATED_ATTRIBUTE_NAME), handlerElement.getReadOnlyFlag(), null);
                    type = dataElement.attributeValue(ATTR_INPUT_TYPE);
                    if (type != null && !"".equals(type)) {
                        advCon.setInputType(type);
                    }
                    if ((required = dataElement.attributeValue(ATTR_REQUIRED)) != null && "true".equals(required.toLowerCase())) {
                        advCon.setRequired(true);
                    }
                    if (this.elemLabel != null && !(control instanceof Label)) {
                        advCon.setLabel(this.elemLabel);
                    }
                    advCon.setAutoCompletionField(dataElement.attributeValue(ATTR_AUTO_COMPLETION, null));
                    this.standaloneElement.addAdvancedControl(advCon);
                    this.pathControlsMap.put(String.valueOf(this.currentPath) + dataElement.attributeValue(ATTR_ELEMENT_NAME), advCon);
                }
            } else if (this.doRepeat) {
                if (this.repElement != null) {
                    String required;
                    advCon = new AdvancedControlElement(control, id, dataElement.attributeValue(ATTR_ELEMENT_NAME), dataElement.attributeValue(ATTR_RELATED_ATTRIBUTE_NAME), handlerElement.getReadOnlyFlag(), null);
                    type = dataElement.attributeValue(ATTR_INPUT_TYPE);
                    if (type != null && !"".equals(type)) {
                        advCon.setInputType(type);
                    }
                    if ((required = dataElement.attributeValue(ATTR_REQUIRED)) != null && "true".equals(required.toLowerCase())) {
                        advCon.setRequired(true);
                    }
                    if (this.elemLabel != null && !(control instanceof Label)) {
                        advCon.setLabel(this.elemLabel);
                    }
                    advCon.setAutoCompletionField(dataElement.attributeValue(ATTR_AUTO_COMPLETION, null));
                    this.repElement.addAdvancedControl(advCon);
                    this.pathControlsMap.put(String.valueOf(this.currentPath) + dataElement.attributeValue(ATTR_ELEMENT_NAME), advCon);
                }
            } else if (this.doComplexRepeat) {
                if (this.complexRepElement != null && !(control instanceof Section)) {
                    String required;
                    advCon = new AdvancedControlElement(control, id, dataElement.attributeValue(ATTR_ELEMENT_NAME), dataElement.attributeValue(ATTR_RELATED_ATTRIBUTE_NAME), handlerElement.getReadOnlyFlag(), null);
                    type = dataElement.attributeValue(ATTR_INPUT_TYPE);
                    if (type != null && !"".equals(type)) {
                        advCon.setInputType(type);
                    }
                    if ((required = dataElement.attributeValue(ATTR_REQUIRED)) != null && "true".equals(required.toLowerCase())) {
                        advCon.setRequired(true);
                    }
                    if (this.elemLabel != null && !(control instanceof Label)) {
                        advCon.setLabel(this.elemLabel);
                    }
                    advCon.setAutoCompletionField(dataElement.attributeValue(ATTR_AUTO_COMPLETION, null));
                    this.complexRepElement.addAdvancedControl(advCon);
                    this.pathControlsMap.put(String.valueOf(this.currentPath) + dataElement.attributeValue(ATTR_ELEMENT_NAME), advCon);
                }
            } else if (this.doSwitch) {
                if (this.currentSwitchGrp != null && !(control instanceof Section)) {
                    String category = dataElement.attributeValue(ATTR_CATEGORY);
                    if ("switcher".equals(category)) {
                        if (control instanceof Button) {
                            this.currentSwitchGrp.addSwitcher((Button)control);
                        }
                    } else {
                        String required;
                        AdvancedControlElement advCon2 = new AdvancedControlElement(control, id, dataElement.attributeValue(ATTR_ELEMENT_NAME), dataElement.attributeValue(ATTR_RELATED_ATTRIBUTE_NAME), handlerElement.getReadOnlyFlag(), null);
                        String type2 = dataElement.attributeValue(ATTR_INPUT_TYPE);
                        if (type2 != null && !"".equals(type2)) {
                            advCon2.setInputType(type2);
                        }
                        if ((required = dataElement.attributeValue(ATTR_REQUIRED)) != null && "true".equals(required.toLowerCase())) {
                            advCon2.setRequired(true);
                        }
                        if (this.elemLabel != null && !(control instanceof Label)) {
                            advCon2.setLabel(this.elemLabel);
                        }
                        advCon2.setAutoCompletionField(dataElement.attributeValue(ATTR_AUTO_COMPLETION, null));
                        this.currentSwitchGrp.addControl(advCon2);
                        this.pathControlsMap.put(String.valueOf(this.currentPath) + dataElement.attributeValue(ATTR_ELEMENT_NAME), advCon2);
                    }
                }
            } else {
                if (this.doSource) {
                    return;
                }
                if (this.doSpecific) {
                    if (this.specificElement != null) {
                        String required;
                        advCon = new AdvancedControlElement(control, id, dataElement.attributeValue(ATTR_ELEMENT_NAME), dataElement.attributeValue(ATTR_RELATED_ATTRIBUTE_NAME), handlerElement.getReadOnlyFlag(), null);
                        type = dataElement.attributeValue(ATTR_INPUT_TYPE);
                        if (type != null && !"".equals(type)) {
                            advCon.setInputType(type);
                        }
                        if ((required = dataElement.attributeValue(ATTR_REQUIRED)) != null && "true".equals(required.toLowerCase())) {
                            advCon.setRequired(true);
                        }
                        if (this.elemLabel != null && !(control instanceof Label)) {
                            advCon.setLabel(this.elemLabel);
                        }
                        advCon.setAutoCompletionField(dataElement.attributeValue(ATTR_AUTO_COMPLETION, null));
                        this.specificElement.addControlElement(advCon);
                        this.pathControlsMap.put(String.valueOf(this.currentPath) + dataElement.attributeValue(ATTR_ELEMENT_NAME), advCon);
                    }
                } else if (this.doCustom) {
                    if (this.customElement != null) {
                        String required;
                        advCon = new AdvancedControlElement(control, id, dataElement.attributeValue(ATTR_ELEMENT_NAME), dataElement.attributeValue(ATTR_RELATED_ATTRIBUTE_NAME), handlerElement.getReadOnlyFlag(), null);
                        type = dataElement.attributeValue(ATTR_INPUT_TYPE);
                        if (type != null && !"".equals(type)) {
                            advCon.setInputType(type);
                        }
                        if ((required = dataElement.attributeValue(ATTR_REQUIRED)) != null && "true".equals(required.toLowerCase())) {
                            advCon.setRequired(true);
                        }
                        if (this.elemLabel != null && !(control instanceof Label)) {
                            advCon.setLabel(this.elemLabel);
                        }
                        advCon.setAutoCompletionField(dataElement.attributeValue(ATTR_AUTO_COMPLETION, null));
                        this.customElement.addControlElement(advCon);
                        this.pathControlsMap.put(String.valueOf(this.currentPath) + dataElement.attributeValue(ATTR_ELEMENT_NAME), advCon);
                    }
                } else if (this.doCollectSourceElements) {
                    if (control instanceof Text || control instanceof org.eclipse.swt.widgets.List || control instanceof Combo) {
                        String required;
                        advCon = new AdvancedControlElement(control, id, dataElement.attributeValue(ATTR_ELEMENT_NAME), dataElement.attributeValue(ATTR_RELATED_ATTRIBUTE_NAME), 0, this);
                        type = dataElement.attributeValue(ATTR_INPUT_TYPE);
                        if (type != null && !"".equals(type)) {
                            advCon.setInputType(type);
                        }
                        if ((required = dataElement.attributeValue(ATTR_REQUIRED)) != null && "true".equals(required.toLowerCase())) {
                            advCon.setRequired(true);
                        }
                        if (this.elemLabel != null && !(control instanceof Label)) {
                            advCon.setLabel(this.elemLabel);
                        }
                        advCon.setAutoCompletionField(dataElement.attributeValue(ATTR_AUTO_COMPLETION, null));
                        this.collectingSourceElement.addControl(advCon);
                        this.pathControlsMap.put(String.valueOf(this.currentPath) + dataElement.attributeValue(ATTR_ELEMENT_NAME), advCon);
                    }
                } else {
                    this.addControl(id, control);
                    if (control instanceof Text || control instanceof org.eclipse.swt.widgets.List || control instanceof Combo) {
                        String required;
                        advCon = new AdvancedControlElement(control, id, dataElement.attributeValue(ATTR_ELEMENT_NAME), dataElement.attributeValue(ATTR_RELATED_ATTRIBUTE_NAME), 0, this);
                        type = dataElement.attributeValue(ATTR_INPUT_TYPE);
                        if (type != null && !"".equals(type)) {
                            advCon.setInputType(type);
                        }
                        if ((required = dataElement.attributeValue(ATTR_REQUIRED)) != null && "true".equals(required.toLowerCase())) {
                            advCon.setRequired(true);
                        }
                        if (this.elemLabel != null && !(control instanceof Label)) {
                            advCon.setLabel(this.elemLabel);
                        }
                        advCon.setAutoCompletionField(dataElement.attributeValue(ATTR_AUTO_COMPLETION, null));
                        if (this.doMore) {
                            if (this.moreElement != null) {
                                this.moreElement.addControlElement(advCon);
                            }
                        } else {
                            this.omItems_provided.add(new OMItem(advCon));
                            this.controlElements.add(advCon);
                        }
                        this.pathControlsMap.put(String.valueOf(this.currentPath) + dataElement.attributeValue(ATTR_ELEMENT_NAME), advCon);
                    }
                }
            }
            if ((control instanceof Section || control instanceof Composite && (handler instanceof CustomControlHandler || handler instanceof SpecificControlHandler)) && dataElement.element(ELEMENT_TABLE) != null) {
                if (handler instanceof StandaloneGroupControlHandler) {
                    this.doStandaloneGroup = true;
                    this.parseTable(dataElement.element(ELEMENT_TABLE), this.standaloneElement.getBody());
                    this.doStandaloneGroup = false;
                    if (this.doComplexRepeat) {
                        if (this.complexRepElement != null) {
                            this.complexRepElement.addComposite(this.standaloneElement);
                        }
                    } else if (this.doSpecific) {
                        if (this.specificElement != null) {
                            this.specificElement.addControlElement(this.standaloneElement);
                        }
                    } else if (this.doCustom) {
                        if (this.customElement != null) {
                            this.customElement.addControlElement(this.standaloneElement);
                        }
                    } else if (this.doMore) {
                        if (this.moreElement != null) {
                            this.moreElement.addControlElement(this.standaloneElement);
                        }
                    } else if (this.doCollectSourceElements) {
                        this.collectingSourceElement.addControl(this.standaloneElement);
                    } else {
                        this.controlElements.add(this.standaloneElement);
                    }
                } else if (handler instanceof RepeatControlHandler) {
                    this.doRepeat = true;
                    this.parseTable(dataElement.element(ELEMENT_TABLE), this.repElement.getBody());
                    this.doRepeat = false;
                    this.repElement.endCollecting();
                    if (this.doComplexRepeat) {
                        if (this.complexRepElement != null) {
                            this.complexRepElement.addComposite(this.repElement);
                        }
                    } else if (this.doSpecific) {
                        if (this.specificElement != null) {
                            this.specificElement.addControlElement(this.repElement);
                        }
                    } else if (this.doCustom) {
                        if (this.customElement != null) {
                            this.customElement.addControlElement(this.repElement);
                        }
                    } else if (this.doMore) {
                        if (this.moreElement != null) {
                            this.moreElement.addControlElement(this.repElement);
                        }
                    } else if (this.doCollectSourceElements) {
                        this.collectingSourceElement.addControl(this.repElement);
                    } else {
                        this.controlElements.add(this.repElement);
                    }
                } else if (handler instanceof SourceControlHandler) {
                    this.doSource = true;
                    this.parseTable(dataElement.element(ELEMENT_TABLE), this.sourceElement.getBody());
                    this.doSource = false;
                    if (this.doComplexRepeat) {
                        if (this.complexRepElement != null) {
                            this.complexRepElement.addComposite(this.sourceElement);
                            this.complexRepElement.setContainsSourceElement(true);
                        }
                    } else if (this.doSpecific) {
                        if (this.specificElement != null) {
                            this.specificElement.addControlElement(this.sourceElement);
                        }
                    } else if (this.doCustom) {
                        if (this.customElement != null) {
                            this.customElement.addControlElement(this.sourceElement);
                        }
                    } else if (this.doMore) {
                        if (this.moreElement != null) {
                            this.moreElement.addControlElement(this.sourceElement);
                        }
                    } else {
                        this.controlElements.add(this.sourceElement);
                    }
                } else if (handler instanceof ComplexRepeatControlHandler) {
                    this.doComplexRepeat = true;
                    this.parseTable(dataElement.element(ELEMENT_TABLE), this.complexRepElement.getBody());
                    this.doComplexRepeat = false;
                    this.complexRepElement.endCollecting();
                    if (this.doSpecific) {
                        if (this.specificElement != null) {
                            this.specificElement.addControlElement(this.complexRepElement);
                        }
                    } else if (this.doCustom) {
                        if (this.customElement != null) {
                            this.customElement.addControlElement(this.complexRepElement);
                        }
                    } else if (this.doMore) {
                        if (this.moreElement != null) {
                            this.moreElement.addControlElement(this.complexRepElement);
                        }
                    } else if (this.doCollectSourceElements) {
                        this.collectingSourceElement.addControl(this.complexRepElement);
                    } else {
                        this.controlElements.add(this.complexRepElement);
                    }
                } else if (handler instanceof SwitchControlHandler) {
                    this.doSwitch = true;
                    this.parseTable(dataElement.element(ELEMENT_TABLE), this.switchElement.getBody());
                    this.doSwitch = false;
                    this.switchElement.addFirstGroup(this.switchGrp1);
                    this.switchElement.addSecondGroup(this.switchGrp2);
                    this.switchGrp1 = null;
                    this.switchGrp2 = null;
                    if (this.doSpecific) {
                        if (this.specificElement != null) {
                            this.specificElement.addControlElement(this.switchElement);
                        }
                    } else if (this.doCustom) {
                        if (this.customElement != null) {
                            this.customElement.addControlElement(this.switchElement);
                        }
                    } else if (this.doMore) {
                        if (this.moreElement != null) {
                            this.moreElement.addControlElement(this.switchElement);
                        }
                    } else if (this.doCollectSourceElements) {
                        this.collectingSourceElement.addControl(this.switchElement);
                    } else {
                        this.controlElements.add(this.switchElement);
                    }
                } else if (handler instanceof SpecificControlHandler) {
                    this.doSpecific = true;
                    this.currentPath = "/object/" + this.specificElementName + "/";
                    this.parseTable(dataElement.element(ELEMENT_TABLE), this.specificElement.getBody());
                    this.doSpecific = false;
                    this.currentPath = "/object/generic/provided/";
                } else if (handler instanceof CustomControlHandler) {
                    this.doCustom = true;
                    this.currentPath = "/object/custom/templateEditor/";
                    this.parseTable(dataElement.element(ELEMENT_TABLE), this.customElement.getBody());
                    this.doCustom = false;
                    this.currentPath = "/object/generic/provided/";
                }
                return;
            }
            if (handler instanceof TextgridDateControlHandler) {
                if (this.doSpecific) {
                    if (this.specificElement != null) {
                        this.specificElement.addControlElement(this.tgDateElement);
                    }
                } else if (this.doCustom) {
                    if (this.customElement != null) {
                        this.customElement.addControlElement(this.tgDateElement);
                    }
                } else if (this.doMore) {
                    if (this.moreElement != null) {
                        this.moreElement.addControlElement(this.tgDateElement);
                    }
                } else if (this.doCollectSourceElements) {
                    this.collectingSourceElement.addControl(this.tgDateElement);
                } else {
                    this.controlElements.add(this.tgDateElement);
                }
                this.pathControlsMap.put(String.valueOf(this.currentPath) + dataElement.attributeValue(ATTR_ELEMENT_NAME), this.tgDateElement);
            }
            if (control instanceof Composite && dataElement.element(ELEMENT_TABLE) != null) {
                this.parseTable(dataElement.element(ELEMENT_TABLE), (Composite)control);
            }
            this.setGridData(control, dataElement.getParent());
            return;
        }
        if (NAMESPACE_URI_DEPRECATED.equals(dataElement.getQName().getNamespaceURI())) {
            throw new ParseException(NLS.bind((String)Messages.XLayout_namepsaceDeprecated, (Object)NAMESPACE_URI_DEPRECATED, (Object)NAMESPACE_URI));
        }
        if (ELEMENT_TABLE.equals(dataElement.getName())) {
            this.parseTable(dataElement, null);
            this.setGridData((Control)this.parentsStack.peek(), dataElement.getParent());
            return;
        }
        if (ELEMENT_INCLUDE.equals(dataElement.getName())) {
            this.parseInclude(dataElement);
            return;
        }
        throw new ParseException(NLS.bind((String)Messages.XLayout_elementNotAllowed, (Object)dataElement.getNamespaceURI(), (Object)dataElement.getName()));
    }

    public void setOMElement(OMElement root, String specificElementName, String textGridUri) {
        if (root == null) {
            return;
        }
        this.specificElementName = specificElementName;
        this.omReader_provided.add(this.omItems_provided);
        this.omReader_specific.add(this.omItems_specific);
        this.omReader_custom.add(this.omItems_custom);
        try {
            this.relationsOMElem = OMUtil.getElementWithName("relations", root, "http://textgrid.info/namespaces/metadata/core/2010", "ns3");
            this.customOMElem = OMUtil.getElementWithName("custom", root, "http://textgrid.info/namespaces/metadata/core/2010", "ns3");
            this.specificOMElem = OMUtil.getElementWithName(this.specificElementName, root, "http://textgrid.info/namespaces/metadata/core/2010", "ns3");
            this.genericOMElem = OMUtil.getElementWithName("generic", root, "http://textgrid.info/namespaces/metadata/core/2010", "ns3");
            this.providedOMElem = OMUtil.getElementWithName("provided", this.genericOMElem, "http://textgrid.info/namespaces/metadata/core/2010", "ns3");
            this.generatedOMElem = OMUtil.getElementWithName("generated", this.genericOMElem, "http://textgrid.info/namespaces/metadata/core/2010", "ns3");
        }
        catch (JaxenException e) {
            Activator.handleError(e, Messages.XLayout_parseError, new Object[0]);
            return;
        }
        OMElement templateEditorOMElem = null;
        if (this.customOMElem != null) {
            templateEditorOMElem = this.customOMElem.cloneOMElement().getFirstChildWithName(new QName(this.customNS.getNamespaceURI(), templateEditorElementName, this.customNS.getPrefix()));
        }
        this.omReader_provided.setOMElements(this.providedOMElem, true);
        this.omReader_specific.setOMElements(this.specificOMElem, true);
        this.omReader_custom.setOMElements(templateEditorOMElem, false);
        if ("item".equals(specificElementName) && this.editionLinksElement != null && textGridUri != null) {
            for (Control c : this.editionLinksElement.getSWTControls()) {
                c.dispose();
            }
            if (!textGridUri.startsWith("textgrid:")) {
                this.editionLinksElement.setExpanded(false);
                return;
            }
            this.editionLinksElement.setExpanded(true);
            ArrayList<EntryType> entryTypes = MetadataPath.addEditionEntriesToMetadataEditor(textGridUri);
            if (entryTypes == null) {
                Label l = new Label(this.editionLinksElement.getBody(), 0);
                l.setForeground(l.getShell().getDisplay().getSystemColor(9));
                l.setText(String.valueOf(Messages.XLayout_noRelatedEditions_1) + Messages.XLayout_noRelatedEditions_2 + Messages.XLayout_noRelatedEditions_3);
                this.editionLinksElement.addAdvancedControl(new AdvancedControlElement((Control)l, null, null, null, 0, this));
            } else {
                for (EntryType t : entryTypes) {
                    final String uri = t.getTextgridUri();
                    Link l = new Link(this.editionLinksElement.getBody(), 4);
                    l.setText("<a>" + t.getTitle() + " (" + uri + ")" + "</a>");
                    l.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            try {
                                IWorkbench workBench = PlatformUI.getWorkbench();
                                TGObjectReference object = new TGObjectReference(new URI(uri));
                                workBench.showPerspective("info.textgrid.lab.core.aggregations.ui.AggregationCompositionPerspective", workBench.getActiveWorkbenchWindow());
                                IEditorInput input = (IEditorInput)AdapterUtils.getAdapter((Object)object, IEditorInput.class);
                                workBench.getActiveWorkbenchWindow().getActivePage().openEditor(input, "info.textgrid.lab.core.aggregations.ui.editor");
                            }
                            catch (WorkbenchException e1) {
                                Activator.handleError(e1, Messages.XLayout_editionInAggregationViewError, new Object[0]);
                            }
                            catch (URISyntaxException e3) {
                                Activator.handleError(e3, Messages.XLayout_editionInAggregationViewError, new Object[0]);
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    this.editionLinksElement.addAdvancedControl(new AdvancedControlElement((Control)l, null, null, null, 0, this));
                }
            }
        }
        if (this.form != null) {
            this.form.reflow(true);
        }
    }

    public OMElement getOMElement() {
        this.createOMElemens();
        this.omCreator_provided.add(this.omItems_provided);
        this.omCreator_provided.createOMElements(omFactory, this.providedOMElem, this.tgNS);
        this.omCreator_specific.add(this.omItems_specific);
        this.omCreator_specific.createOMElements(omFactory, this.specificOMElem, this.tgNS);
        this.omCreator_custom.add(this.omItems_custom);
        this.omCreator_custom.createOMElements(omFactory, this.templateEditorOM, this.customNS);
        return this.objectOMElem;
    }

    private void createOMElemens() {
        if (this.specificElementName == null || "".equals(this.specificElementName)) {
            return;
        }
        this.objectOMElem = omFactory.createOMElement(TextGridObject.METADATA_ROOT_NAME);
        this.objectOMElem.declareNamespace(this.tgNS);
        this.objectOMElem.declareNamespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ns2");
        this.genericOMElem = omFactory.createOMElement("generic", this.tgNS);
        this.providedOMElem = omFactory.createOMElement("provided", this.tgNS);
        this.genericOMElem.addChild((OMNode)this.providedOMElem);
        if (this.generatedOMElem != null) {
            this.genericOMElem.addChild((OMNode)this.generatedOMElem);
        }
        this.objectOMElem.addChild((OMNode)this.genericOMElem);
        this.specificOMElem = omFactory.createOMElement(this.specificElementName, this.tgNS);
        this.objectOMElem.addChild((OMNode)this.specificOMElem);
        if (this.customOMElem == null) {
            this.customOMElem = omFactory.createOMElement("custom", this.tgNS);
            this.templateEditorOM = null;
        } else {
            this.templateEditorOM = this.customOMElem.getFirstChildWithName(new QName(this.customNS.getNamespaceURI(), templateEditorElementName));
        }
        if (this.templateEditorOM == null) {
            this.templateEditorOM = omFactory.createOMElement(templateEditorElementName, this.customNS);
            this.customOMElem.addChild((OMNode)this.templateEditorOM);
        } else {
            Iterator iter = this.templateEditorOM.getChildElements();
            while (iter.hasNext()) {
                OMElement om = (OMElement)iter.next();
                if (om == null) continue;
                om.detach();
            }
        }
        this.objectOMElem.addChild((OMNode)this.customOMElem);
        if (this.relationsOMElem != null) {
            this.objectOMElem.addChild((OMNode)this.relationsOMElem);
        }
    }

    public CustomControlElement getCustomElement() {
        return this.customElement;
    }

    public SpecificControlElement getSpecificElement() {
        return this.specificElement;
    }

    public List<IControl> getAllControlElements() {
        return this.controlElements;
    }

    public IControl getControlElementById(String id) {
        for (IControl c : this.controlElements) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        if (modified && !this.isEditable()) {
            return;
        }
        this.modified = modified;
        if (this.metadataPart != null) {
            this.metadataPart.validate();
        }
    }

    public void setVisible(boolean visible) {
        if (this.form != null) {
            this.form.setVisible(visible);
        }
    }

    public boolean isVisible() {
        return this.form != null ? this.form.getVisible() : false;
    }

    public boolean isEditable() {
        if (this.metadataPart != null) {
            return this.metadataPart.isEditable();
        }
        return false;
    }

    public List<Control> getAllControls() {
        ArrayList<Control> controls = new ArrayList<Control>();
        controls.addAll(this.controlsMap.values());
        for (IControl c : this.controlElements) {
            if (c instanceof IRepresentableComposite) {
                controls.addAll(((IRepresentableComposite)c).getSWTControls());
                continue;
            }
            if (!(c instanceof IRepresentableControl)) continue;
            controls.add(((IRepresentableControl)c).getSWTControl());
        }
        return controls;
    }

    private void setGridData(Control control, Element tdElement) {
        String align;
        String valign;
        int verticalSpan;
        GridData gridData = new GridData();
        int horizontalSpan = AttributeHelper.getAsInteger(tdElement, ATTR_COLSPAN, 1);
        if (horizontalSpan > 1) {
            gridData.horizontalSpan = horizontalSpan;
        }
        if ((verticalSpan = AttributeHelper.getAsInteger(tdElement, ATTR_ROWSPAN, 1)) > 1) {
            gridData.verticalSpan = verticalSpan;
        }
        if ((valign = AttributeHelper.getAsString(tdElement, ATTR_VALIGN, null)) != null) {
            gridData.verticalAlignment = ConvertHelper.convertToSWTAlignment(valign);
        }
        if ((align = AttributeHelper.getAsString(tdElement, ATTR_ALIGN, null)) != null) {
            gridData.horizontalAlignment = ConvertHelper.convertToSWTAlignment(align);
        }
        String attrHeight = AttributeHelper.getAsString(tdElement, ATTR_HEIGHT, null);
        String attrWidth = AttributeHelper.getAsString(tdElement, ATTR_WIDTH, null);
        if (attrHeight != null) {
            if ("100%".equals(attrHeight)) {
                gridData.verticalAlignment = 4;
                gridData.grabExcessVerticalSpace = true;
                gridData.minimumHeight = control.getParent().getSize().y;
            } else {
                int height;
                gridData.heightHint = height = Integer.valueOf(attrHeight).intValue();
                gridData.minimumHeight = height;
            }
        }
        if (attrWidth != null) {
            if ("100%".equals(attrWidth)) {
                gridData.horizontalAlignment = 4;
                gridData.grabExcessHorizontalSpace = true;
                gridData.minimumWidth = control.getParent().getSize().x;
            } else {
                int width;
                gridData.widthHint = width = Integer.valueOf(attrWidth).intValue();
                gridData.minimumWidth = width;
            }
        }
        control.setLayoutData((Object)gridData);
    }

    private int getNumberOfCols(Element tableElement) {
        List trElements = tableElement.elements(ELEMENT_TR);
        int numberOfCols = 0;
        for (Element trElement : trElements) {
            List tdElements = trElement.elements(ELEMENT_TD);
            int tmpNumberOfCols = 0;
            for (Element tdElement : tdElements) {
                tmpNumberOfCols += AttributeHelper.getAsInteger(tdElement, ATTR_COLSPAN, 1);
            }
            if (tmpNumberOfCols <= numberOfCols) continue;
            numberOfCols = tmpNumberOfCols;
        }
        return numberOfCols;
    }

    private void addControl(String id, Control control) throws ParseException {
        if (this.controlsMap.containsKey(id)) {
            throw new ParseException(NLS.bind((String)"Could not create control with id '{0}'! A control with this id already exists in '{1}'!", (Object)id, (Object)this.xLayoutSourceStack.peek().getHint()));
        }
        this.controlsMap.put(id, control);
    }

    public boolean controlExists(String id) {
        return this.controlsMap.containsKey(id);
    }

    private HandlerElement createHandlerElement(Element xmlElement) {
        String name = xmlElement.getName();
        List attributes = xmlElement.attributes();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        for (Attribute attr : attributes) {
            attrMap.put(attr.getName(), attr.getValue());
        }
        HandlerElement handlerElement = new HandlerElement(this.controlHandlerConfigs.get(name), attrMap);
        return handlerElement;
    }

    public void registerMetadataPart(IMetadataPart part) {
        this.metadataPart = part;
    }

    public void fireFocusEvent() {
        if (this.metadataPart != null) {
            this.metadataPart.update();
        }
    }

    public void updateDecorationForAgents() {
    }

    public Map<String, ICheckableElement> getPathControlsMap() {
        return this.pathControlsMap;
    }

    public Label getInfoLabel() {
        return this.infoLabel;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void dispose() {
        try {
            Collection<Control> controls = this.controlsMap.values();
            for (Control control : controls) {
                control.dispose();
            }
            this.controlsMap.clear();
            List<Composite> parents = this.parentsStack.getAllPushedValues();
            for (Composite comp : parents) {
                comp.dispose();
            }
            this.parentsStack.clear();
            for (IControl c : this.controlElements) {
                c.dispose();
            }
            this.controlElements.clear();
            this.editionLinksElement = null;
        }
        finally {
            this.isDisposed = true;
        }
    }
}

