/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.elements;

import com.logabit.xlayout.XLayout;
import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.autoCompletion.AutoCompletionUtil;
import info.textgrid.lab.core.metadataeditor.autoCompletion.LocalAutoCompletionClient;
import info.textgrid.lab.core.metadataeditor.autoCompletion.PNDAutoCompletionClient;
import info.textgrid.lab.core.metadataeditor.autoCompletion.TGNAutoCompletionClient;
import info.textgrid.lab.core.metadataeditor.elements.IAdvancedControlsContainer;
import info.textgrid.lab.core.metadataeditor.elements.ICheckableElement;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableControl;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableItemsGroup;
import info.textgrid.lab.core.metadataeditor.elements.Messages;
import info.textgrid.lab.core.metadataeditor.utils.OMUtil;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.search.AutocompletionClient;
import info.textgrid.lab.search.ExtendedContentProposalAdapter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.jaxen.JaxenException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AdvancedControlElement
implements IRepresentableControl,
IAdvancedControlsContainer,
ICheckableElement {
    private Control control = null;
    private String id = null;
    private String name = null;
    private String ref = null;
    private String refId = null;
    private int readOnlyFlag = 0;
    private OMElement element = null;
    private XLayout xlayout = null;
    private String inputType = "string";
    private boolean required = false;
    private Label label = null;
    private Color defaultColor;
    private String autoCompletionField = null;
    private IRepresentableItemsGroup itemsGroup = null;
    private FieldDecoration assistFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
    private char[] autoActivationCharacters = null;
    private KeyStroke keyStroke = null;
    private boolean validType = true;
    private AutocompletionClient proposalProvider = null;

    public String getAutoCompletionField() {
        return this.autoCompletionField;
    }

    public void setAutoCompletionField(String autoCompletionField) {
        this.autoCompletionField = autoCompletionField;
        if (this.autoCompletionField != null && !"".equals(this.autoCompletionField)) {
            this.setAutoCompletion(this.control, this.autoCompletionField);
        }
    }

    public void setItemsGroup(IRepresentableItemsGroup group) {
        this.itemsGroup = group;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
        this.defaultColor = this.label.getForeground();
        if (!"string".equals(this.inputType)) {
            if ("TextGrid-Uri".equals(this.inputType) && !this.label.getText().contains(this.inputType)) {
                this.label.setText(String.valueOf(this.label.getText()) + " (" + this.inputType + ")");
            } else if (!this.label.getText().contains("xs:" + this.inputType)) {
                this.label.setText(String.valueOf(this.label.getText()) + " (xs:" + this.inputType + ("date".equals(this.inputType) ? ", YYYY-MM-DD" : ("time".equals(this.inputType) ? ", hh:mm:ss" : "")) + ")");
            }
        }
        if (this.isRequired() && !this.label.getText().contains("*")) {
            this.label.setText(String.valueOf(this.label.getText()) + " *");
        }
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
        if (required && this.itemsGroup != null) {
            this.itemsGroup.setExpanded(true);
        }
    }

    public AdvancedControlElement(Control control, String id, String name, String ref, int readOnlyFlag, XLayout xlayout) {
        this.control = control;
        this.id = this.refId = id;
        this.name = name;
        this.ref = ref;
        this.readOnlyFlag = readOnlyFlag;
        this.xlayout = xlayout;
        this.defaultColor = this.control.getDisplay().getSystemColor(2);
        if (this.name == null) {
            this.name = id;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    void setRefId(String refId) {
        this.refId = refId;
    }

    public String getRefId() {
        return this.refId;
    }

    public String getName() {
        return this.name;
    }

    public String getRef() {
        return this.ref;
    }

    @Override
    public Control getSWTControl() {
        return this.control;
    }

    public OMElement getOMElement() {
        return this.element;
    }

    public int getReadOnlyFlag() {
        return this.readOnlyFlag;
    }

    @Override
    public void createOMElement(OMFactory omFactory, OMElement parent, OMNamespace ns, boolean asAttribute) {
        if (this.control instanceof Label || this.control instanceof Button) {
            return;
        }
        if (!asAttribute) {
            this.createOMElementControl(omFactory, parent, ns);
        } else {
            this.createOMElementControlAsAttribute(omFactory, parent);
        }
    }

    @Override
    public boolean setOMElement(OMElement root, boolean tg) {
        if (this.control instanceof Label || this.control instanceof Button) {
            return false;
        }
        this.clear();
        if (root == null) {
            return false;
        }
        OMElement elem = null;
        try {
            elem = tg ? OMUtil.getElementWithName(this.name, root, "http://textgrid.info/namespaces/metadata/core/2010", "tg") : OMUtil.getElementWithName(this.name, root, TextGridObject.CUSTOM_NAMESPACE, "cns");
        }
        catch (JaxenException e) {
            Activator.handleError(e);
        }
        if (elem != null) {
            this.addContentToControl(elem.getText());
            return true;
        }
        return false;
    }

    public void addContentToControl(String content) {
        if (this.control instanceof Text) {
            Text t = (Text)this.control;
            this.setTextValue(t, content);
        } else if (this.control instanceof Combo) {
            Combo c = (Combo)this.control;
            String t = (String)c.getData(content);
            if (t != null && !"".equals(t)) {
                content = t;
            }
            c.setText(content);
        } else if (this.control instanceof List) {
            List l = (List)this.control;
            l.setSelection(new String[]{content});
        } else if (this.control instanceof Button) {
            Button b = (Button)this.control;
            if ("true".equals(content)) {
                b.setSelection(true);
            } else {
                b.setSelection(false);
            }
        }
    }

    private void createOMElementControl(OMFactory omFactory, OMElement parent, OMNamespace ns) {
        String value = "";
        if (this.control instanceof Text) {
            Text t = (Text)this.control;
            value = this.getTextValue(t);
        } else if (this.control instanceof Combo) {
            Combo c = (Combo)this.control;
            value = c.getText();
            String t = (String)c.getData(value);
            if (t != null && !"".equals(t)) {
                value = t;
            }
        } else if (this.control instanceof List) {
            List l = (List)this.control;
            if (l.getSelectionIndex() > -1) {
                value = l.getItem(l.getSelectionIndex());
            }
        } else if (this.control instanceof Button) {
            Button b = (Button)this.control;
            value = b.getSelection() ? "true" : "false";
        } else {
            return;
        }
        this.element = omFactory.createOMElement(this.name, ns);
        this.element.setText(value);
        parent.addChild((OMNode)this.element);
    }

    private void createOMElementControlAsAttribute(OMFactory omFactory, OMElement parent) {
        String value = "";
        if (this.control instanceof Text) {
            Text t = (Text)this.control;
            value = this.getTextValue(t);
        } else if (this.control instanceof Combo) {
            Combo c = (Combo)this.control;
            value = c.getText();
            String t = (String)c.getData(value);
            if (t != null && !"".equals(t)) {
                value = t;
            }
        } else if (this.control instanceof List) {
            List l = (List)this.control;
            if (l.getSelectionIndex() > -1) {
                value = l.getItem(l.getSelectionIndex());
            }
        } else if (this.control instanceof Button) {
            Button b = (Button)this.control;
            value = b.getSelection() ? "true" : "false";
        }
        if (!"".equals(value)) {
            parent.addAttribute(omFactory.createOMAttribute(this.name, null, value));
        }
    }

    private String getTextValue(Text t) {
        String res;
        String value = t.getText();
        if (this.inputType.toLowerCase().contains("uri")) {
            value = value.replaceAll("\\s", "");
        }
        if (this.autoCompletionField != null && "language".equals(this.autoCompletionField) && (res = AutoCompletionUtil.getInstance().getLanguagesMap().get(value)) != null) {
            value = res;
        }
        return value;
    }

    private void setTextValue(Text t, String content) {
        String res;
        if (this.autoCompletionField != null && "language".equals(this.autoCompletionField) && (res = AutoCompletionUtil.getInstance().getLanguagesMap().get(content)) != null) {
            content = res;
        }
        t.setText(content);
    }

    @Override
    public void clear() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        if (this.control instanceof Text) {
            ((Text)this.control).setText("");
        } else if (this.control instanceof Combo) {
            ((Combo)this.control).select(0);
        } else if (this.control instanceof List) {
            ((List)this.control).select(0);
        } else {
            return;
        }
        if (this.xlayout != null) {
            this.xlayout.setModified(false);
        }
    }

    @Override
    public void dispose() {
        if (this.control != null) {
            this.control.dispose();
        }
    }

    @Override
    public boolean validate() {
        if (this.control == null || this.control.isDisposed()) {
            return true;
        }
        boolean valid = true;
        if (this.control instanceof Text || this.control instanceof Combo) {
            String content = "";
            if (this.control instanceof Text) {
                content = this.getTextValue((Text)this.control);
            } else {
                Combo c = (Combo)this.control;
                content = c.getText();
                String t = (String)c.getData(content);
                if (t != null && !"".equals(t)) {
                    content = t;
                }
            }
            if ("language".equals(this.name) && !"".equals(content)) {
                valid &= AutoCompletionUtil.getInstance().getLanguagesMap().containsKey(content);
            }
            if (this.isRequired()) {
                valid &= !"".equals(content);
            }
            if (!valid) {
                this.colorizeLabel(valid);
                return valid;
            }
            if (!("string".equals(this.inputType) || !this.isRequired() && "".equals(content))) {
                if ("boolean".equals(this.inputType)) {
                    valid = "true".equalsIgnoreCase(content = content.trim()) || "false".equalsIgnoreCase(content) || "0".equals(content) || "1".equalsIgnoreCase(content) ? (valid &= true) : false;
                    this.colorizeLabel(valid);
                    return valid;
                }
                this.colorizeLabel(valid &= this.testInputType(content));
                return valid;
            }
        }
        this.colorizeLabel(valid);
        return valid;
    }

    private void colorizeLabel(boolean valid) {
        if (!valid) {
            if (this.label != null) {
                this.label.setForeground(this.label.getDisplay().getSystemColor(3));
            }
        } else if (this.label != null) {
            this.label.setForeground(this.defaultColor);
        }
    }

    private boolean testInputType(String input) {
        String inputType = this.inputType;
        if ("TextGrid-Uri".equals(inputType)) {
            if (!input.startsWith("textgrid:")) {
                return false;
            }
            inputType = "anyURI";
        }
        this.validType = true;
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Activator.handleWarning(exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                AdvancedControlElement.this.validType = false;
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                AdvancedControlElement.this.validType = false;
            }
        });
        try {
            StreamSource ss = new StreamSource(new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"><xs:element name=\"" + this.name + "\" type=\"xs:" + inputType + "\"></xs:element>" + "</xs:schema>").getBytes("UTF-8")));
            StreamSource ss2 = new StreamSource(new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?><" + this.name + ">" + input + "</" + this.name + ">").getBytes("UTF-8")));
            Schema s = factory.newSchema(ss);
            Validator v = s.newValidator();
            v.validate(ss2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.validType = false;
        }
        catch (SAXException sAXException) {
            this.validType = false;
        }
        catch (IOException iOException) {
            this.validType = false;
        }
        return this.validType;
    }

    @Override
    public LinkedList<AdvancedControlElement> getAdvancedControls() {
        LinkedList<AdvancedControlElement> controls = new LinkedList<AdvancedControlElement>();
        controls.add(this);
        return controls;
    }

    private void setAutoCompletion(Control control, String whichField) {
        ControlDecoration typDec = new ControlDecoration(control, 16512);
        typDec.setDescriptionText(Messages.AdvancedControlElement_autoCompleteDescription);
        typDec.setImage(this.assistFieldIndicator.getImage());
        typDec.setMarginWidth(4);
        typDec.setShowOnlyOnFocus(true);
        if ("language".equals(whichField)) {
            this.proposalProvider = new LocalAutoCompletionClient(whichField);
        } else if ("pnd".equals(whichField)) {
            this.proposalProvider = new PNDAutoCompletionClient(whichField);
        } else if ("tgn".equals(whichField)) {
            this.proposalProvider = new TGNAutoCompletionClient(whichField);
        }
        if (this.proposalProvider != null) {
            ExtendedContentProposalAdapter adapter = new ExtendedContentProposalAdapter(control, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.proposalProvider, this.keyStroke, this.autoActivationCharacters);
            adapter.setAutoActivationDelay(500);
            adapter.setProposalAcceptanceStyle(2);
            this.proposalProvider.setContentProposalAdapter(adapter);
            if ("pnd".equals(whichField)) {
                adapter.setAutoActivationDelay(1300);
                adapter.addContentProposalListener(new IContentProposalListener(){

                    public void proposalAccepted(IContentProposal proposal) {
                        if (AdvancedControlElement.this.itemsGroup != null) {
                            String id;
                            Control idCon;
                            Text t;
                            String name;
                            Control nameCon = AdvancedControlElement.this.getSWTControl();
                            if (nameCon != null && nameCon instanceof Text && (name = (t = (Text)nameCon).getText()) != null && !"".equals(t)) {
                                t.setText(name.replaceFirst("\\s\\[.+\\]", ""));
                            }
                            if ((idCon = AdvancedControlElement.this.itemsGroup.getFirstControlByName("id")) != null && idCon instanceof Text && (id = ((PNDAutoCompletionClient)AdvancedControlElement.this.proposalProvider).getIdByName(proposal.getContent())) != null) {
                                ((Text)idCon).setText(id);
                            }
                        }
                    }
                });
            } else if ("tgn".equals(whichField)) {
                adapter.setAutoActivationDelay(1300);
                adapter.addContentProposalListener(new IContentProposalListener(){

                    public void proposalAccepted(IContentProposal proposal) {
                        Control idCon;
                        if (AdvancedControlElement.this.itemsGroup != null && (idCon = AdvancedControlElement.this.itemsGroup.getFirstControlByName("id")) != null && idCon instanceof Text) {
                            Control typeCon;
                            String id = ((TGNAutoCompletionClient)AdvancedControlElement.this.proposalProvider).getIdByName(proposal.getContent());
                            if (id != null) {
                                ((Text)idCon).setText(id);
                            }
                            if ((typeCon = AdvancedControlElement.this.itemsGroup.getFirstControlByName("type")) != null && typeCon instanceof Text) {
                                ((Text)typeCon).setText("http://textgrid.info/namespaces/vocabularies/tgn");
                            }
                        }
                    }
                });
            }
        }
    }
}

