/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.elements;

import com.logabit.xlayout.XLayout;
import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableComposite;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableControl;
import info.textgrid.lab.core.metadataeditor.elements.Messages;
import info.textgrid.lab.core.metadataeditor.utils.OMUtil;
import info.textgrid.lab.core.model.TextGridObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.dom4j.Element;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.jaxen.JaxenException;

public class SourceControlElement
implements IRepresentableComposite {
    private Section sec = null;
    private ScrolledForm form = null;
    private FormToolkit toolkit = null;
    private String id = null;
    private String title = null;
    private Composite sectionClient = null;
    private Element dataElement = null;
    private XLayout xlayout = null;
    private String element_name = Messages.SourceControlElement_element_title;
    private String element_name_on_label = Messages.SourceControlElement_element_title;
    private String parent_name = null;
    private Element objectCitationElement = null;
    private Element bibliographicCitationElement = null;
    private ArrayList<IControl> controls = new ArrayList();
    private Button toObjectCitation;
    private Button toBibliographicCitation;
    private String selectedCitationType = null;

    public SourceControlElement createNewSourceControlElementForComplexRepeatable(String id, ScrolledForm f, Control section) {
        SourceControlElement src = new SourceControlElement(id, f, section, this.dataElement, this.toolkit, this.xlayout);
        src.objectCitationElement = this.objectCitationElement;
        src.bibliographicCitationElement = this.bibliographicCitationElement;
        return src;
    }

    public SourceControlElement(String id, ScrolledForm f, Control section, Element element, FormToolkit tk, XLayout layout) {
        this.id = id;
        this.sec = (Section)section;
        this.form = f;
        this.toolkit = tk;
        this.dataElement = element;
        this.xlayout = layout;
        this.title = this.dataElement.attributeValue("text");
        if (this.title != null) {
            this.element_name = this.title;
            this.sec.setText(this.element_name);
            this.element_name_on_label = this.element_name.replaceAll("\\(.+\\)", "");
        }
        this.parent_name = this.dataElement.attributeValue("element_name");
        this.sec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                SourceControlElement.this.xlayout.setModified(true);
                SourceControlElement.this.form.reflow(true);
            }
        });
        this.sectionClient = this.toolkit.createComposite((Composite)this.sec, 2052);
        this.sectionClient.setBackground(this.sec.getBackground());
        this.sectionClient.setLayout((Layout)new GridLayout(1, true));
        this.sec.setClient((Control)this.sectionClient);
        this.toObjectCitation = this.toolkit.createButton(this.sectionClient, Messages.SourceControlElement_addObjectCitation, 0x1000008);
        this.toObjectCitation.setLayoutData((Object)new GridData(4, 2, true, true));
        this.toObjectCitation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SourceControlElement.this.createObjectCitation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.toBibliographicCitation = this.toolkit.createButton(this.sectionClient, Messages.SourceControlElement_addBibliographicCitation, 0x1000008);
        this.toBibliographicCitation.setLayoutData((Object)new GridData(4, 2, true, true));
        this.toBibliographicCitation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SourceControlElement.this.createBibliographicCitation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createObjectCitation() {
        if (this.toObjectCitation != null && !this.toObjectCitation.isDisposed()) {
            this.toObjectCitation.dispose();
        }
        if (this.toBibliographicCitation != null && !this.toBibliographicCitation.isDisposed()) {
            this.toBibliographicCitation.dispose();
        }
        this.toBibliographicCitation = null;
        this.toObjectCitation = null;
        this.xlayout.setDoCollectSourceElements(true);
        this.xlayout.setCollectingSourceElement(this);
        this.xlayout.parseTable(this.objectCitationElement.element("table"), this.getBody());
        this.xlayout.setDoCollectSourceElements(false);
        this.selectedCitationType = "objectCitation";
        this.form.reflow(true);
        this.xlayout.fireFocusEvent();
    }

    private void createBibliographicCitation() {
        if (this.toObjectCitation != null && !this.toObjectCitation.isDisposed()) {
            this.toObjectCitation.dispose();
        }
        if (this.toBibliographicCitation != null && !this.toBibliographicCitation.isDisposed()) {
            this.toBibliographicCitation.dispose();
        }
        this.toBibliographicCitation = null;
        this.toObjectCitation = null;
        this.xlayout.setDoCollectSourceElements(true);
        this.xlayout.setCollectingSourceElement(this);
        this.xlayout.parseTable(this.bibliographicCitationElement.element("table"), this.getBody());
        this.xlayout.setDoCollectSourceElements(false);
        this.selectedCitationType = "bibliographicCitation";
        this.form.reflow(true);
        this.xlayout.fireFocusEvent();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Composite getBody() {
        return this.sectionClient;
    }

    public void addElement(Element elem) {
        if ("objectCitation".equals(elem.attributeValue("element_name"))) {
            this.objectCitationElement = elem;
        } else {
            this.bibliographicCitationElement = elem;
        }
    }

    public void addControl(IControl control) {
        this.controls.add(control);
    }

    @Override
    public boolean validate() {
        if (!this.sec.isExpanded()) {
            return true;
        }
        boolean valid = true;
        for (IControl c : this.controls) {
            valid &= c.validate();
        }
        return valid;
    }

    private void clearCurrentSourceElement() {
        if (this.controls.isEmpty()) {
            return;
        }
        for (IControl c : this.controls) {
            c.dispose();
        }
        this.controls.clear();
        if (this.sectionClient != null && !this.sectionClient.isDisposed()) {
            this.sectionClient.dispose();
            this.sectionClient = this.toolkit.createComposite((Composite)this.sec, 2052);
            this.sectionClient.setBackground(this.sec.getBackground());
            this.sectionClient.setLayout((Layout)new GridLayout(1, true));
            this.sec.setClient((Control)this.sectionClient);
        }
    }

    @Override
    public void dispose() {
        if (this.toObjectCitation != null && !this.toObjectCitation.isDisposed()) {
            this.toObjectCitation.dispose();
        }
        if (this.toBibliographicCitation != null && !this.toBibliographicCitation.isDisposed()) {
            this.toBibliographicCitation.dispose();
        }
        for (IControl c : this.controls) {
            c.dispose();
        }
        this.controls.clear();
        if (this.sec != null && !this.sec.isDisposed()) {
            this.sec.dispose();
        }
    }

    @Override
    public void createOMElement(OMFactory omFactory, OMElement parent, OMNamespace ns, boolean asAttribute) {
        if (this.sec.isExpanded() && this.parent_name != null && !"".equals(this.parent_name) && this.selectedCitationType != null && !"".equals(this.selectedCitationType)) {
            OMElement source = omFactory.createOMElement(this.parent_name, ns, (OMContainer)parent);
            OMElement citation = omFactory.createOMElement(this.selectedCitationType, ns, (OMContainer)source);
            for (IControl c : this.controls) {
                c.createOMElement(omFactory, citation, ns, asAttribute);
            }
        }
    }

    @Override
    public boolean setOMElement(OMElement root, boolean tg) {
        boolean found = false;
        if (this.parent_name != null && !"".equals(this.parent_name)) {
            OMElement citation;
            OMElement elem = null;
            try {
                elem = tg ? OMUtil.getElementWithName(this.parent_name, root, "http://textgrid.info/namespaces/metadata/core/2010", "tg") : OMUtil.getElementWithName(this.parent_name, root, TextGridObject.CUSTOM_NAMESPACE, "cns");
            }
            catch (JaxenException e) {
                Activator.handleError(e);
                return false;
            }
            if (elem != null && (citation = elem.getFirstElement()) != null) {
                this.clearCurrentSourceElement();
                if (citation.getLocalName().contains("object")) {
                    this.createObjectCitation();
                } else {
                    this.createBibliographicCitation();
                }
                for (IControl c : this.controls) {
                    found |= c.setOMElement(citation, tg);
                }
            }
        }
        if ((this.sec.getExpansionStyle() & 2) != 0) {
            if (found) {
                this.sec.setExpanded(true);
            } else {
                this.sec.setExpanded(false);
            }
        }
        return found;
    }

    @Override
    public void clear() {
        if (this.controls.isEmpty()) {
            return;
        }
        for (IControl c : this.controls) {
            c.dispose();
        }
        this.controls.clear();
        if (this.sectionClient != null && !this.sectionClient.isDisposed()) {
            this.sectionClient.dispose();
            this.sectionClient = this.toolkit.createComposite((Composite)this.sec, 2052);
            this.sectionClient.setBackground(this.sec.getBackground());
            this.sectionClient.setLayout((Layout)new GridLayout(1, true));
            this.sec.setClient((Control)this.sectionClient);
        }
        this.toObjectCitation = this.toolkit.createButton(this.sectionClient, Messages.SourceControlElement_addObjectCitation, 0x1000008);
        this.toObjectCitation.setLayoutData((Object)new GridData(4, 2, true, true));
        this.toObjectCitation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SourceControlElement.this.createObjectCitation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.toBibliographicCitation = this.toolkit.createButton(this.sectionClient, Messages.SourceControlElement_addBibliographicCitation, 0x1000008);
        this.toBibliographicCitation.setLayoutData((Object)new GridData(4, 2, true, true));
        this.toBibliographicCitation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SourceControlElement.this.createBibliographicCitation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    public List<Control> getSWTControls() {
        ArrayList<Control> cons = new ArrayList<Control>();
        if (this.toObjectCitation != null) {
            cons.add((Control)this.toObjectCitation);
        }
        if (this.toBibliographicCitation != null) {
            cons.add((Control)this.toBibliographicCitation);
        }
        for (IControl c : this.controls) {
            if (c instanceof IRepresentableComposite) {
                cons.addAll(((IRepresentableComposite)c).getSWTControls());
                continue;
            }
            if (!(c instanceof IRepresentableControl)) continue;
            cons.add(((IRepresentableControl)c).getSWTControl());
        }
        return cons;
    }

    @Override
    public List<IControl> getControls() {
        return this.controls;
    }

    @Override
    public IRepresentableComposite getUnit() {
        return this;
    }

    @Override
    public void setExpanded(boolean expand) {
        if (this.sec != null) {
            this.sec.setExpanded(expand);
        }
    }

    @Override
    public boolean isExpanded() {
        if (this.sec != null) {
            return this.sec.isExpanded();
        }
        return false;
    }
}

