/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.elements;

import com.logabit.xlayout.XLayout;
import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.MetaDataDialog;
import info.textgrid.lab.core.metadataeditor.elements.AdvancedControlElement;
import info.textgrid.lab.core.metadataeditor.elements.IAdvancedControlsContainer;
import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableComposite;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableItemsGroup;
import info.textgrid.lab.core.metadataeditor.elements.Messages;
import info.textgrid.lab.core.metadataeditor.utils.FetchTGObjectsDialog;
import info.textgrid.lab.core.metadataeditor.utils.OMUtil;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.UIJob;
import org.jaxen.JaxenException;

public class StandaloneGroupControlElement
implements IRepresentableItemsGroup,
IAdvancedControlsContainer {
    private String id;
    private Section sec = null;
    private ScrolledForm form = null;
    private Composite sectionClient = null;
    private XLayout xlayout = null;
    private LinkedList<AdvancedControlElement> controls = new LinkedList();
    private boolean isEditionOf = false;

    public StandaloneGroupControlElement(String id, Control s, ScrolledForm f, FormToolkit toolkit, XLayout layout) {
        this.id = id;
        this.sec = (Section)s;
        this.form = f;
        this.xlayout = layout;
        if (!id.endsWith("_show")) {
            this.sec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    StandaloneGroupControlElement.this.xlayout.setModified(true);
                    StandaloneGroupControlElement.this.form.reflow(true);
                }
            });
        }
        this.sectionClient = toolkit.createComposite((Composite)this.sec, 2052);
        this.sectionClient.setBackground(this.sec.getBackground());
        this.sectionClient.setLayout((Layout)new GridLayout(1, true));
        this.sec.setClient((Control)this.sectionClient);
        if (id.contains("EditionOf")) {
            this.isEditionOf = true;
        }
    }

    public void addAdvancedControl(AdvancedControlElement adv) {
        this.controls.add(adv);
        adv.setItemsGroup(this);
        if (this.isEditionOf) {
            Link l;
            if (adv.getSWTControl() instanceof Button) {
                Button browse = (Button)adv.getSWTControl();
                if (browse != null) {
                    browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Text t = (Text)StandaloneGroupControlElement.this.getFirstControlByName("isEditionOf");
                            if (t != null) {
                                FetchTGObjectsDialog.openDialog(t);
                            }
                        }
                    });
                }
            } else if (adv.getSWTControl() instanceof Link && (l = (Link)adv.getSWTControl()) != null) {
                l.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Text t = (Text)StandaloneGroupControlElement.this.getFirstControlByName("isEditionOf");
                        if (t != null) {
                            final String uri = t.getText();
                            if (!"".equals(uri) && uri.startsWith("textgrid:")) {
                                new Job(""){

                                    protected IStatus run(IProgressMonitor arg0) {
                                        try {
                                            final TextGridObject obj = TextGridObject.getInstance((URI)new URI(uri), (boolean)true);
                                            if (obj != null && obj.isAccessible()) {
                                                new UIJob(""){

                                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                                        MetaDataDialog.openMetaDataDialog(obj);
                                                        return Status.OK_STATUS;
                                                    }
                                                }.schedule();
                                            }
                                            return Status.OK_STATUS;
                                        }
                                        catch (CrudServiceException e1) {
                                            Activator.handleError(e1);
                                        }
                                        catch (URISyntaxException e1) {
                                            Activator.handleError(e1);
                                        }
                                        return Status.CANCEL_STATUS;
                                    }
                                }.schedule();
                            } else {
                                MessageDialog.openError((Shell)l.getShell(), (String)Messages.StandaloneGroupControlElement_invalidTGUri_title, (String)Messages.StandaloneGroupControlElement_invalidTGUri_description);
                            }
                        }
                    }
                });
            }
        }
    }

    public Composite getBody() {
        return this.sectionClient;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean validate() {
        if (!this.sec.isExpanded()) {
            return true;
        }
        boolean valid = true;
        for (IControl c : this.getControls()) {
            valid &= c.validate();
        }
        return valid;
    }

    @Override
    public void dispose() {
        for (AdvancedControlElement adv : this.controls) {
            adv.dispose();
        }
        if (this.sec != null && !this.sec.isDisposed()) {
            this.sec.dispose();
        }
    }

    @Override
    public void createOMElement(OMFactory omFactory, OMElement parent, OMNamespace ns, boolean asAttribute) {
        if (this.sec.isExpanded()) {
            for (AdvancedControlElement e : this.controls) {
                if (e.getRef() == null) {
                    e.createOMElement(omFactory, parent, ns, false);
                    continue;
                }
                AdvancedControlElement ac = this.getAdvancedControlElementById(e.getRef());
                if (ac == null) continue;
                e.createOMElement(omFactory, ac.getOMElement(), ns, true);
            }
        }
    }

    private AdvancedControlElement getAdvancedControlElementById(String id) {
        for (AdvancedControlElement e : this.controls) {
            if (!e.getId().equals(id) && !e.getRefId().equals(id)) continue;
            return e;
        }
        return null;
    }

    @Override
    public Control getFirstControlByName(String name) {
        for (AdvancedControlElement e : this.controls) {
            if (!e.getName().equals(name)) continue;
            return e.getSWTControl();
        }
        return null;
    }

    @Override
    public boolean setOMElement(OMElement root, boolean tg) {
        boolean found = false;
        block2: for (AdvancedControlElement e : this.controls) {
            if (e.getRef() == null) {
                found |= e.setOMElement(root, tg);
                continue;
            }
            AdvancedControlElement ac = this.getAdvancedControlElementById(e.getRef());
            if (ac == null) continue;
            OMElement elem = null;
            try {
                elem = tg ? OMUtil.getElementWithName(ac.getName(), root, "http://textgrid.info/namespaces/metadata/core/2010", "tg") : OMUtil.getElementWithName(ac.getName(), root, TextGridObject.CUSTOM_NAMESPACE, "cns");
            }
            catch (JaxenException e1) {
                Activator.handleError(e1);
            }
            if (elem == null) continue;
            e.clear();
            Iterator attrs = elem.getAllAttributes();
            while (attrs.hasNext()) {
                OMAttribute attr = (OMAttribute)attrs.next();
                if (!e.getName().equals(attr.getLocalName())) continue;
                e.addContentToControl(attr.getAttributeValue());
                found = true;
                continue block2;
            }
        }
        if ((this.sec.getExpansionStyle() & 2) != 0) {
            if (found) {
                this.sec.setExpanded(true);
            } else {
                this.sec.setExpanded(false);
            }
        }
        return found;
    }

    @Override
    public void clear() {
        for (AdvancedControlElement adv : this.controls) {
            adv.clear();
        }
    }

    @Override
    public LinkedList<AdvancedControlElement> getAdvancedControls() {
        return this.controls;
    }

    @Override
    public List<Control> getSWTControls() {
        ArrayList<Control> con = new ArrayList<Control>();
        for (AdvancedControlElement adv : this.controls) {
            con.add(adv.getSWTControl());
        }
        return con;
    }

    @Override
    public List<IControl> getControls() {
        ArrayList<IControl> con = new ArrayList<IControl>();
        con.addAll(this.controls);
        return con;
    }

    @Override
    public IRepresentableComposite getUnit() {
        return this;
    }

    @Override
    public void setExpanded(boolean expand) {
        if (this.sec != null) {
            this.sec.setExpanded(expand);
        }
    }

    @Override
    public boolean isExpanded() {
        if (this.sec != null) {
            return this.sec.isExpanded();
        }
        return false;
    }
}

