/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.elements;

import com.logabit.xlayout.XLayout;
import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableComposite;
import info.textgrid.lab.core.metadataeditor.elements.NotImplementedException;
import info.textgrid.lab.core.metadataeditor.elements.SwitchGroup;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.dom4j.Element;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class SwitchControlElement
implements IRepresentableComposite {
    private Section sec = null;
    private ScrolledForm form = null;
    private FormToolkit toolkit = null;
    private String id = null;
    private Composite sectionClient = null;
    private Element dataElement = null;
    private XLayout xlayout = null;
    private SwitchGroup switchGrp1;
    private SwitchGroup switchGrp2;

    public SwitchControlElement(String id, ScrolledForm f, Control section, Element element, FormToolkit tk, XLayout layout) {
        this.id = id;
        this.sec = (Section)section;
        this.form = f;
        this.toolkit = tk;
        this.dataElement = element;
        this.xlayout = layout;
        this.sec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                SwitchControlElement.this.xlayout.setModified(true);
                SwitchControlElement.this.form.reflow(true);
            }
        });
        this.sectionClient = this.toolkit.createComposite((Composite)this.sec, 2052);
        this.sectionClient.setBackground(this.sec.getBackground());
        this.sectionClient.setLayout((Layout)new GridLayout(1, true));
        this.sec.setClient((Control)this.sectionClient);
    }

    public Composite getBody() {
        return this.sectionClient;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void addFirstGroup(SwitchGroup group) {
        this.switchGrp1 = group;
        this.switchGrp1.update(this, this.form, this.sectionClient, this.xlayout);
    }

    public void addSecondGroup(SwitchGroup group) {
        this.switchGrp2 = group;
        this.switchGrp2.update(this, this.form, this.sectionClient, this.xlayout);
        this.switchGrp1.create();
        this.form.reflow(true);
    }

    public void switchToOtherGroup(SwitchGroup activeGrp) {
        if (activeGrp == this.switchGrp1) {
            this.switchGrp1.destroy();
            this.form.reflow(true);
            this.switchGrp2.create();
        } else {
            this.switchGrp2.destroy();
            this.form.reflow(true);
            this.switchGrp1.create();
        }
        this.sec.setExpanded(false);
        this.sec.setExpanded(true);
    }

    @Override
    public void createOMElement(OMFactory omFactory, OMElement parent, OMNamespace ns, boolean asAttribute) {
        this.switchGrp1.createOMElement(omFactory, parent, ns, asAttribute);
        this.switchGrp2.createOMElement(omFactory, parent, ns, asAttribute);
    }

    @Override
    public void dispose() {
        this.switchGrp1.dispose();
        this.switchGrp2.dispose();
        if (this.sec != null && !this.sec.isDisposed()) {
            this.sec.dispose();
        }
    }

    @Override
    public boolean validate() {
        boolean valid = true;
        valid &= this.switchGrp1.validate();
        return valid &= this.switchGrp2.validate();
    }

    @Override
    public boolean setOMElement(OMElement root, boolean tg) {
        boolean found = false;
        boolean switchToGrp2 = false;
        found |= this.switchGrp1.setOMElement(root, tg);
        switchToGrp2 = this.switchGrp2.setOMElement(root, tg);
        found |= switchToGrp2;
        if (switchToGrp2) {
            this.switchToOtherGroup(this.switchGrp1);
        }
        return found;
    }

    @Override
    public List<Control> getSWTControls() {
        ArrayList<Control> l = new ArrayList<Control>();
        l.addAll(this.switchGrp1.getControls());
        l.addAll(this.switchGrp2.getControls());
        return l;
    }

    @Override
    public IRepresentableComposite getUnit() {
        return this;
    }

    @Override
    public List<IControl> getControls() {
        throw new NotImplementedException();
    }

    @Override
    public void clear() {
        this.switchGrp1.clear();
        this.switchGrp2.clear();
    }

    @Override
    public void setExpanded(boolean expand) {
        if (this.sec != null) {
            this.sec.setExpanded(expand);
        }
    }

    @Override
    public boolean isExpanded() {
        if (this.sec != null) {
            return this.sec.isExpanded();
        }
        return false;
    }
}

