/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.rcp_linkeditor.newObject;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.linkeditor.rcp_linkeditor.Activator;
import info.textgrid.lab.linkeditor.rcp_linkeditor.newObject.LinkeditorNewObjectPreparator;
import info.textgrid.lab.linkeditor.rcp_linkeditor.newObject.Messages;
import info.textgrid.lab.linkeditor.tools.FetchTGObjectsDialog;
import info.textgrid.lab.linkeditor.tools.IProjectBrowserListener;
import info.textgrid.lab.ui.core.dialogs.INewObjectPreparator;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizard;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizardPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class AddObjectsToLinkeditorPage
extends WizardPage
implements ITextGridWizardPage,
IProjectBrowserListener {
    private LinkeditorNewObjectPreparator preparator = null;
    private TableViewer objectsTable = null;
    private Group buttonsGrp = null;
    private Group tableGroup = null;
    private Map<String, TextGridObject> nameUriMap = new HashMap<String, TextGridObject>();

    private AddObjectsToLinkeditorPage getInstance() {
        return this;
    }

    public AddObjectsToLinkeditorPage() {
        super(Messages.AddObjectsToLinkeditorPage_AddXmlOrImageObjects, Messages.AddObjectsToLinkeditorPage_AddXmlOrImageObjectsToNewTILO, null);
        this.setMessage(Messages.AddObjectsToLinkeditorPage_ToCreateANewTILO);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridDataFactory fillGrabData = GridDataFactory.fillDefaults();
        fillGrabData.grab(true, true);
        GridLayoutFactory.fillDefaults().applyTo(control);
        fillGrabData.applyTo((Control)control);
        this.setControl((Control)control);
        this.create(control);
        this.validatePageComplete();
    }

    private void validatePageComplete() {
        int count = this.objectsTable.getTable().getItemCount();
        if (count < 2) {
            this.setPageComplete(false);
            return;
        }
        TableItem[] items = this.objectsTable.getTable().getItems();
        boolean imageFound = false;
        boolean xmlFound = false;
        int i = 0;
        while (!(i >= count || imageFound && xmlFound)) {
            if (items[i].getText().endsWith(".")) {
                imageFound = true;
            } else {
                xmlFound = true;
            }
            ++i;
        }
        this.setPageComplete(imageFound && xmlFound);
    }

    public Composite create(Composite parent) {
        this.tableGroup = new Group(parent, 530);
        this.tableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableGroup.setLayout((Layout)new GridLayout(1, true));
        this.tableGroup.setText("");
        GridData urisTreeData2 = new GridData(4, 4, true, false);
        urisTreeData2.heightHint = 300;
        urisTreeData2.widthHint = 100;
        this.objectsTable = new TableViewer((Composite)this.tableGroup, 268438276);
        this.objectsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        Table table = this.objectsTable.getTable();
        table.setLayoutData((Object)urisTreeData2);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn tblclmnFirst = new TableColumn(table, 0);
        tblclmnFirst.setWidth(100);
        tblclmnFirst.setText(Messages.AddObjectsToLinkeditorPage_SelectedXmlORImageObjects);
        this.buttonsGrp = new Group((Composite)this.tableGroup, 4);
        this.buttonsGrp.setLayout((Layout)new GridLayout(2, true));
        this.buttonsGrp.setLayoutData((Object)new GridData(4, 0, true, false));
        Button getTGUriButton = new Button((Composite)this.buttonsGrp, 8);
        getTGUriButton.setText(Messages.AddObjectsToLinkeditorPage_AddTGObjects);
        getTGUriButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FetchTGObjectsDialog.openDialog((IProjectBrowserListener)AddObjectsToLinkeditorPage.this.getInstance());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = new Button((Composite)this.buttonsGrp, 8);
        removeButton.setText(Messages.AddObjectsToLinkeditorPage_RemoveSelectedObject);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddObjectsToLinkeditorPage.this.removeSelectedObject();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return this.tableGroup;
    }

    private void removeSelectedObject() {
        int index = this.objectsTable.getTable().getSelectionIndex();
        if (index >= 0) {
            this.objectsTable.getTable().remove(index);
            this.objectsTable.getTable().select(0);
        }
        this.validatePageComplete();
    }

    public void init(ITextGridWizard wizard, INewObjectPreparator preparator) {
        if (preparator instanceof LinkeditorNewObjectPreparator) {
            this.preparator = (LinkeditorNewObjectPreparator)preparator;
        }
    }

    public void loadObject(TextGridObject textGridObject) {
    }

    public void finishPage() {
        TableItem[] items = this.objectsTable.getTable().getItems();
        int itemsCount = items.length;
        if (itemsCount < 1) {
            return;
        }
        ArrayList<TextGridObject> tgObjects = new ArrayList<TextGridObject>();
        String s = "";
        int i = 0;
        while (i < itemsCount) {
            TextGridObject obj;
            s = items[i].getText();
            if (s != null && !"".equals(s) && (obj = this.nameUriMap.get(s)) != null) {
                tgObjects.add(obj);
            }
            ++i;
        }
        this.preparator.setSelectedObjectsList(tgObjects);
    }

    public void setSelectedTGObjectsFromDialog(TextGridObject[] tgObjs) {
        try {
            TextGridObject[] textGridObjectArray = tgObjs;
            int n = tgObjs.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    String suffix;
                    TextGridObject tgObj;
                    block7: {
                        String contentType;
                        block6: {
                            tgObj = textGridObjectArray[n2];
                            contentType = tgObj.getContentTypeID();
                            suffix = "";
                            if (contentType == null || "".equals(contentType)) break block5;
                            if (!contentType.contains("image")) break block6;
                            suffix = ".";
                            break block7;
                        }
                        if (!"text/xml".equals(contentType)) break block5;
                        suffix = "";
                    }
                    String name = this.getInfoFromObject(tgObj, suffix);
                    this.nameUriMap.put(name, tgObj);
                    this.setSelectedTextInInput(name);
                    this.validatePageComplete();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.handleError(e);
        }
    }

    private String getInfoFromObject(TextGridObject obj, String suffix) {
        try {
            obj.reloadMetadata(false);
            return String.valueOf(obj.getNameCandidate()) + " (" + obj.getURI() + ")" + suffix;
        }
        catch (CrudServiceException e) {
            Activator.handleError(e);
        }
        catch (CoreException e) {
            Activator.handleError(e);
        }
        return null;
    }

    private void setSelectedTextInInput(String entry) {
        TableItem item = new TableItem(this.objectsTable.getTable(), 0);
        item.setText(entry);
        if (entry.endsWith(".")) {
            this.setImageIconToItem(item);
        } else {
            this.setXMLIconToItem(item);
        }
    }

    private void setXMLIconToItem(TableItem item) {
        item.setImage(new Image((Device)PlatformUI.getWorkbench().getDisplay(), ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/xmldoc.gif").getImageData()));
    }

    private void setImageIconToItem(TableItem item) {
        item.setImage(new Image((Device)PlatformUI.getWorkbench().getDisplay(), ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/image_obj.gif").getImageData()));
    }
}

