/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui.adapter;

import info.textgrid.lab.core.model.RestrictedTextGridObject;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.core.swtutils.ChunkingElementCollector;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.search.ui.adapter.Messages;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.middleware.tgsearch.Response;
import info.textgrid.namespaces.middleware.tgsearch.ResultType;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class AggregationAdapter
extends PlatformObject
implements IDeferredWorkbenchAdapter {
    private TextGridObject object;

    public AggregationAdapter(TextGridObject textGridObject) {
        this.object = textGridObject;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        ChunkingElementCollector groupingCollector = new ChunkingElementCollector(collector, 16);
        SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.AggregationAdapter_IM_FetchingAggregation, (Object)object), (int)100);
        TextGridObject tgoAggregation = (TextGridObject)AdapterUtils.getAdapter((Object)object, TextGridObject.class);
        SearchRequest searchRequest = null;
        try {
            searchRequest = tgoAggregation.isPublic() ? new SearchRequest(SearchRequest.EndPoint.PUBLIC) : new SearchRequest();
        }
        catch (CoreException e1) {
            Activator.handleError((Throwable)e1, (String)e1.getMessage(), (Object[])new Object[]{tgoAggregation});
        }
        Response response = searchRequest.listAggregation(tgoAggregation.getURI().toString());
        for (Object obj : response.getResult()) {
            Status status;
            if (!(obj instanceof ResultType)) continue;
            ObjectType oType = ((ResultType)obj).getObject();
            try {
                if (oType.getGeneric().getProvided() != null) {
                    TextGridObject tgo = TextGridObject.getInstance((ObjectType)oType, (boolean)true, (boolean)true);
                    TGObjectReference tgoRef = new TGObjectReference(((ResultType)obj).getTextgridUri(), tgo);
                    tgoRef.setAggregation((TGObjectReference)object);
                    if (tgoRef.isLatestRef()) {
                        TextGridObject.addLatestRegistryItem((URI)new URI(tgo.getLatestURI()), (URI)tgo.getURI());
                    }
                    TGObjectReference.notifyListeners((TGObjectReference.ITGObjectReferenceListener.Event)TGObjectReference.ITGObjectReferenceListener.Event.NAVIGATOR_OBJECT_CREATED, (TGObjectReference)tgoRef);
                    groupingCollector.add((Object)tgoRef, monitor);
                    continue;
                }
                RestrictedTextGridObject rtgo = new RestrictedTextGridObject(oType.getGeneric().getGenerated().getTextgridUri().getValue());
                groupingCollector.add((Object)rtgo, monitor);
            }
            catch (CoreException e) {
                status = new Status(4, "info.textgrid.lab.ui.core", NLS.bind((String)Messages.AggregationAdapter_EM_RetrieveAggragation, (Object)object.toString()), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            catch (URISyntaxException e) {
                status = new Status(4, "info.textgrid.lab.ui.core", NLS.bind((String)Messages.AggregationAdapter_EM_URISyntaxException, (Object)oType), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        groupingCollector.done();
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }
}

