/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui.newsearch;

import info.textgrid.lab.search.ui.newsearch.FulltextMainAreaLine;
import java.util.ArrayList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;

public class FulltextMainArea {
    private Composite comMainArea;
    private ScrolledComposite scrolledComposite;
    private ArrayList<FulltextMainAreaLine> fulltextMainAreaLines = new ArrayList();

    public FulltextMainArea(Composite comMainAra, ScrolledComposite scrolledComposite) {
        this.comMainArea = comMainAra;
        this.scrolledComposite = scrolledComposite;
        this.fulltextMainAreaLines.add(this.addControlLine(true));
        this.fulltextMainAreaLines.add(this.addControlLine(false));
        this.setRemoveIconsVisible(false);
    }

    private FulltextMainAreaLine addControlLine(Boolean firstLine) {
        Composite composite = new Composite(this.comMainArea, 0);
        return new FulltextMainAreaLine(this, composite, this.scrolledComposite, firstLine);
    }

    public FulltextMainAreaLine addLine() {
        if (this.fulltextMainAreaLines.size() == 2) {
            this.setRemoveIconsVisible(true);
        }
        FulltextMainAreaLine newLine = this.addControlLine(false);
        this.fulltextMainAreaLines.add(newLine);
        return newLine;
    }

    public void removeLine(FulltextMainAreaLine line) {
        if (this.fulltextMainAreaLines.size() <= 2) {
            return;
        }
        this.fulltextMainAreaLines.remove(line);
        line.getMainComposite().dispose();
        this.comMainArea.layout();
        this.scrolledComposite.setMinSize(this.scrolledComposite.getContent().computeSize(-1, -1));
        if (this.fulltextMainAreaLines.size() == 2) {
            this.setRemoveIconsVisible(false);
        }
    }

    public FulltextMainAreaLine getNextLine(FulltextMainAreaLine line) {
        int index = this.fulltextMainAreaLines.indexOf(line);
        if (index != -1) {
            try {
                return this.fulltextMainAreaLines.get(index + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    private void setRemoveIconsVisible(Boolean state) {
        for (FulltextMainAreaLine line : this.fulltextMainAreaLines) {
            line.getDeleteImage().setVisible(state.booleanValue());
        }
    }
}

