/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.swtutils;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;

public class IntervalMultimap<T> {
    private final Multimap<Interval, T> intervalMap = HashMultimap.create();

    public void add(Interval interval, T object) {
        this.intervalMap.put((Object)interval, object);
    }

    public Iterable<Interval> findIntervals(final Interval query) {
        return Iterables.filter((Iterable)this.intervalMap.keys(), (Predicate)new Predicate<Interval>(){

            public boolean apply(Interval input) {
                return query.overlaps(input);
            }
        });
    }

    public Set<T> getOverlappingValues(Interval query) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (Interval interval : this.intervalMap.keySet()) {
            if (!query.overlaps(interval)) continue;
            builder.addAll((Iterable)this.intervalMap.get((Object)interval));
        }
        return builder.build();
    }

    public String toString() {
        return Joiner.on((String)", ").withKeyValueSeparator(": ").join(this.intervalMap.asMap());
    }

    public void remove(T value) {
        this.intervalMap.values().remove(value);
    }

    public static class Interval
    implements Comparable<Interval>,
    IRegion {
        private int start;
        private int end;

        public Interval(int start, int end) throws IllegalArgumentException {
            if (start > end) {
                throw new IllegalArgumentException("An interval's start cannot be after its end.");
            }
            this.start = start;
            this.end = end;
        }

        public Interval(int point) {
            this(point, point);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.end;
            result = 31 * result + this.start;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Interval)) {
                return false;
            }
            Interval other = (Interval)obj;
            if (this.end != other.end) {
                return false;
            }
            return this.start == other.start;
        }

        public String toString() {
            return MessageFormat.format("[{0},{1})", this.start, this.end);
        }

        @Override
        public int compareTo(Interval o) {
            int result = this.start - o.start;
            if (result == 0) {
                result = this.end - o.end;
            }
            return result;
        }

        Interval successor() {
            return new Interval(this.start, this.end + 1);
        }

        public boolean overlaps(Interval other) {
            return this.startsInside(other) || other.startsInside(this);
        }

        private boolean startsInside(Interval other) {
            return other.start <= this.start && this.start < other.end;
        }

        public Interval succInterval() {
            return new Interval(this.end + 1, this.end + 1);
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getLength() {
            return this.end - this.start;
        }

        public int getOffset() {
            return this.start;
        }

        public static Interval of(IRegion region) {
            return new Interval(region.getOffset(), region.getOffset() + region.getLength());
        }

        public static Interval of(Position position) {
            return new Interval(position.offset, position.offset + position.length);
        }

        public static Interval of(int position) {
            return new Interval(position);
        }

        public static Interval of(int startOffset, int endOffset) {
            return new Interval(startOffset, endOffset);
        }
    }

    static class OverlapsComparator
    implements Comparator<Interval> {
        OverlapsComparator() {
        }

        @Override
        public int compare(Interval o1, Interval o2) {
            if (o1.overlaps(o2)) {
                return 0;
            }
            return o1.compareTo(o2);
        }
    }
}

