/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.efs.tgcrud;

import info.textgrid.lab.core.efs.tgcrud.ExceptionPassingPipedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.MessageFormat;

public class ExceptionPassingPipedInputStream
extends PipedInputStream {
    private ExceptionPassingPipedOutputStream src;

    @Override
    public void connect(PipedOutputStream source) throws IOException, IllegalArgumentException {
        if (!(source instanceof ExceptionPassingPipedOutputStream)) {
            throw new IllegalArgumentException(MessageFormat.format("Must be connected with a ExceptionPassingPipedInputStream, not with a plain {0} like {1}", this.src.getClass().getSimpleName(), this.src));
        }
        this.src = (ExceptionPassingPipedOutputStream)source;
        this.src.setSink(this);
        super.connect(source);
    }

    public ExceptionPassingPipedInputStream() {
    }

    public ExceptionPassingPipedInputStream(ExceptionPassingPipedOutputStream src) throws IOException {
        super(src);
    }

    public synchronized void passOnException(Throwable e) {
        if (this.src != null) {
            this.src.setException(e);
            try {
                this.close();
            }
            catch (IOException exceptionThatShouldNeverOccur) {
                throw new RuntimeException("Received an IOException from PipedInputStream.close(), but this method's implementation is known not to throw any exceptions. Strange.", exceptionThatShouldNeverOccur);
            }
            this.notifyAll();
        }
    }

    public synchronized void done() {
        this.src.done();
    }

    synchronized void setSource(ExceptionPassingPipedOutputStream src) {
        this.src = src;
    }
}

