/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow;

import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.ChainTGWF;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.MetadataTransformer;
import info.textgrid.lab.workflow.servicedescription.Input;
import info.textgrid.lab.workflow.servicedescription.Output;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Chain {
    private ArrayList<ChainEntry> chain;
    private HashSet<EntryLink> possibleLinks = new HashSet();
    private ChainTGWF tgwf;
    private ArrayList<MetadataTransformer> transformers = new ArrayList();
    private String description = "";

    public Chain() {
        this.setChain(new ArrayList<ChainEntry>());
    }

    public Chain(ArrayList<ChainEntry> chain) {
        this.setChain(chain);
    }

    public void addEntry(ChainEntry ce) {
        this.chain.add(ce);
        this.assignIDs();
        this.connectEntriesMonotone();
        ce.setDefaultParams();
    }

    public ArrayList<ChainEntry> getChain() {
        return this.chain;
    }

    public void resetLinks() {
        this.possibleLinks.clear();
        this.transformers.clear();
    }

    public void clearLinks() {
        for (EntryLink link : this.possibleLinks) {
            link.resetState();
        }
        int i = 0;
        while (i < this.getChain().size()) {
            this.getChain().get(i).clearLinks();
            ++i;
        }
        this.transformers.clear();
    }

    public void connectEntriesMonotone() {
        int num = 0;
        while (num < this.getChain().size()) {
            ChainEntry entry = this.getChain().get(num);
            for (Input i : entry.getInputs()) {
                this.addPossibleLink(null, null, entry, i);
            }
            for (Output o : entry.getOutputs()) {
                this.addPossibleLink(entry, o, null, null);
            }
            int prev = 0;
            while (prev < num) {
                ChainEntry previousEntry = this.getChain().get(prev);
                for (Output o : previousEntry.getOutputs()) {
                    for (Input i : entry.getInputs()) {
                        this.addPossibleLink(previousEntry, o, entry, i);
                    }
                }
                ++prev;
            }
            ++num;
        }
    }

    public void addPossibleLink(ChainEntry from, Output fromPort, ChainEntry to, Input toPort) {
        this.possibleLinks.add(new EntryLink(from, fromPort, to, toPort));
    }

    public boolean addLink(EntryLink oneLink) {
        HashSet<EntryLink> incompatibleLinks = new HashSet<EntryLink>();
        EntryLink needle = null;
        for (EntryLink l : this.possibleLinks) {
            if (l.getFrom() != null && l.getFrom().equals(oneLink.getFrom()) && l.getFromPort() != null && l.getFromPort().equals(oneLink.getFromPort())) {
                if (l.equals(oneLink)) {
                    if (l.isUndecided()) {
                        needle = l;
                        continue;
                    }
                    if (!l.isDeleted().booleanValue()) continue;
                    return false;
                }
                if (l.isAdded().booleanValue()) {
                    return false;
                }
                incompatibleLinks.add(l);
                continue;
            }
            if (l.getTo() == null || !l.getTo().equals(oneLink.getTo()) || l.getToPort() == null || !l.getToPort().equals(oneLink.getToPort())) continue;
            if (l.equals(oneLink)) {
                if (l.isUndecided()) {
                    needle = l;
                    continue;
                }
                if (!l.isDeleted().booleanValue()) continue;
                return false;
            }
            if (l.isAdded().booleanValue()) {
                return false;
            }
            incompatibleLinks.add(l);
        }
        if (needle == null) {
            return false;
        }
        needle.markLinkAdded();
        for (EntryLink out : incompatibleLinks) {
            out.markLinkDeleted();
        }
        return true;
    }

    public List<EntryLink> findLinksToHere(ChainEntry to, Input toPort) {
        ArrayList<EntryLink> result = new ArrayList<EntryLink>();
        for (EntryLink l : this.possibleLinks) {
            if (l.getTo() == null || l.getToPort() == null || !l.getTo().equals(to) || !l.getToPort().equals(toPort) || l.isDeleted().booleanValue()) continue;
            result.add(l);
        }
        return result;
    }

    public List<EntryLink> findLinksFromHere(ChainEntry from, Output fromPort) {
        ArrayList<EntryLink> result = new ArrayList<EntryLink>();
        for (EntryLink l : this.possibleLinks) {
            if (l.getFrom() == null || l.getFromPort() == null || !l.getFrom().equals(from) || !l.getFromPort().equals(fromPort) || l.isDeleted().booleanValue()) continue;
            result.add(l);
        }
        return result;
    }

    public boolean connectOutputs() {
        for (EntryLink l : this.possibleLinks) {
            if (!l.isUndecided() || l.getTo() != null || l.getToPort() != null) continue;
            this.addLink(l);
        }
        return true;
    }

    public boolean validateLinks() {
        int linkID = 0;
        for (EntryLink l : this.possibleLinks) {
            if (!l.isAdded().booleanValue()) continue;
            if (l.getFrom() != null && l.getFromPort() != null && !l.getFrom().addOutgoingLink(l, String.valueOf(++linkID))) {
                return false;
            }
            if (l.getTo() == null || l.getToPort() == null || l.getTo().addIncomingLink(l, String.valueOf(linkID))) continue;
            return false;
        }
        for (ChainEntry c : this.getChain()) {
            for (Input i : c.getInputs()) {
                if (i.isOptional() == null || i.isOptional().booleanValue() || c.existsIncomingLink(i)) continue;
                return false;
            }
            for (Output o : c.getOutputs()) {
                if (o.isOptional() == null || o.isOptional().booleanValue() || c.existsOutgoingLink(o)) continue;
                return false;
            }
        }
        return true;
    }

    public void dumpLinks() {
        for (EntryLink l : this.possibleLinks) {
            l.dump();
        }
    }

    public void assignIDs() {
        int i = 0;
        while (i < this.getChain().size()) {
            this.getChain().get(i).setID(i);
            ++i;
        }
    }

    public HashSet<EntryLink> getLinks() {
        return this.possibleLinks;
    }

    public ChainTGWF toTGWF() {
        this.tgwf = new ChainTGWF(this);
        if (this.description.length() > 0) {
            this.tgwf.setDescription(this.description);
        }
        for (MetadataTransformer m : this.transformers) {
            this.tgwf.insertMetadataTransformer(m.getOutput(), m.getFromInput(), m.getStylesheet().getURI(), m.getParams());
        }
        return this.tgwf;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.toTGWF().marshal();
    }

    public void setChain(ArrayList<ChainEntry> chain) {
        this.chain = chain;
    }

    public ArrayList<MetadataTransformer> getTransformers() {
        return this.transformers;
    }

    public ArrayList<EntryLink> getInputLinks() {
        ArrayList<EntryLink> result = new ArrayList<EntryLink>();
        for (EntryLink l : this.possibleLinks) {
            if (l.isUndecided() || l.isDeleted().booleanValue() || l.getFrom() != null || l.getFromPort() != null) continue;
            result.add(l);
        }
        return result;
    }
}

