/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.PendingLabelProvider;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.menus.TGOpenWithMenu;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import info.textgrid.lab.ui.core.utils.UpdatingDeferredListContentProvider;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainGWDL;
import info.textgrid.lab.workflow.ChainTGWF;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.WorkflowJob;
import info.textgrid.lab.workflow.tgwf.Tgwf;
import info.textgrid.lab.workflow.views.ChainView;
import info.textgrid.lab.workflow.views.JobManagement;
import info.textgrid.lab.workflow.views.Messages;
import info.textgrid.lab.workflow.views.WorkflowInputs;
import info.textgrid.lab.workflow.wizard.WorkflowWizard;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.xml.bind.JAXB;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.ViewPart;

public class ListOfWorkflows
extends ViewPart {
    private TextGridObjectTableViewer viewer;
    private ComboViewer selectedProjectViewer;
    AuthBrowser.ISIDChangedListener sidChangedListener;
    private Chain chain;
    private ArrayList<EntryLink> inputLinks;
    private final ISelectionListener selectedWorkflowListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
            Object firstelem;
            IStructuredSelection iss;
            if (sourcepart == ListOfWorkflows.this && selection instanceof IStructuredSelection && !(iss = (IStructuredSelection)selection).isEmpty() && (firstelem = iss.toArray()[0]) instanceof TextGridObject) {
                TextGridObject tgo = (TextGridObject)firstelem;
                String format = null;
                try {
                    format = ((TextGridObject)firstelem).getContentTypeID();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (format.equals("text/tg.workflow+xml") && (ListOfWorkflows.this.lastSelectedWorkflow == null || !ListOfWorkflows.this.lastSelectedWorkflow.equals(tgo))) {
                    ListOfWorkflows.this.showInputs(tgo);
                    ListOfWorkflows.this.lastSelectedWorkflow = tgo;
                }
            }
        }
    };
    private Job currentJob = null;
    private TextGridObject lastSelectedWorkflow = null;

    public void createPartControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridData gdc = new GridData(4, 4, true, true);
        c.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(1, false);
        c.setLayout((Layout)glp);
        this.viewer = new TextGridObjectTableViewer(c, 66308);
        this.viewer.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE));
        this.viewer.getTable().setHeaderVisible(false);
        GridData gd1 = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gd1);
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.refreshViewer();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu((TableViewer)this.viewer);
        Composite aboveBottomBar = new Composite(c, 4);
        aboveBottomBar.setLayout((Layout)new GridLayout(2, false));
        GridData gd2 = new GridData(4, 2, true, false);
        aboveBottomBar.setLayoutData((Object)gd2);
        GridData gd3a = new GridData(16384, 0x1000000, false, false);
        Label targetProjectlabel = new Label(aboveBottomBar, 4);
        targetProjectlabel.setLayoutData((Object)gd3a);
        targetProjectlabel.setText(Messages.ListOfWorkflows_TargetProjectLabel);
        this.getSite().getPage().addSelectionListener(this.selectedWorkflowListener);
        this.selectedProjectViewer = new ComboViewer(aboveBottomBar, 4);
        GridData gd3b = new GridData(16384, 0x1000000, true, false);
        gd3b.widthHint = 2000;
        this.selectedProjectViewer.getControl().setLayoutData((Object)gd3b);
        UpdatingDeferredListContentProvider sPcontentProvider = new UpdatingDeferredListContentProvider();
        this.selectedProjectViewer.setContentProvider((IContentProvider)sPcontentProvider);
        this.selectedProjectViewer.setLabelProvider((IBaseLabelProvider)new PendingLabelProvider());
        this.selectedProjectViewer.setInput((Object)TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)TextGridProjectRoot.LEVELS.EDITOR));
        Composite bottomBar = new Composite(c, 4);
        bottomBar.setLayout((Layout)new GridLayout(2, false));
        GridData gd4 = new GridData(4, 2, true, false);
        bottomBar.setLayoutData((Object)gd4);
        Button refreshButton = new Button(bottomBar, 8);
        refreshButton.setText(Messages.ListOfWorkflows_RefreshButtonText);
        refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListOfWorkflows.this.refreshViewer();
                ListOfWorkflows.this.selectedProjectViewer.setInput((Object)TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)TextGridProjectRoot.LEVELS.EDITOR));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button editB = new Button(bottomBar, 8);
        editB.setText(Messages.ListOfWorkflows_EditButtonText);
        editB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListOfWorkflows.this.startEditWFWizard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button newB = new Button(bottomBar, 8);
        newB.setText(Messages.ListOfWorkflows_NewButtonText);
        newB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WorkflowWizard wizard = new WorkflowWizard();
                wizard.init(ListOfWorkflows.this.getSite().getWorkbenchWindow().getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(ListOfWorkflows.this.getSite().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button applyURIsButton = new Button(bottomBar, 8);
        applyURIsButton.setText(Messages.ListOfWorkflows_RunButtonText);
        applyURIsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListOfWorkflows.this.startJob();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.sidChangedListener = new AuthBrowser.ISIDChangedListener(){

            public void sidChanged(String newSID, String newEPPN) {
                ListOfWorkflows.this.refreshViewer();
            }
        };
        AuthBrowser.addSIDChangedListener((AuthBrowser.ISIDChangedListener)this.sidChangedListener);
    }

    private void openInputs(TextGridObject wfTGO) {
    }

    private void openWFcreationPerspective() {
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchPage wbPage = wb.getActiveWorkbenchWindow().getActivePage();
            if (wbPage == null) {
                wb.getActiveWorkbenchWindow().openPage("info.textgrid.lab.workflow.WorkflowCreationPerspective", null);
            }
            wbPage.setPerspective(wb.getPerspectiveRegistry().findPerspectiveWithId("info.textgrid.lab.workflow.WorkflowCreationPerspective"));
            PlatformUI.getWorkbench().showPerspective("info.textgrid.lab.workflow.WorkflowCreationPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            Status status = new Status(4, "info.textgrid.lab.workflow", "Could not open Workflow Creation Perspective!", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void startEditWFWizard() {
        IStructuredSelection wfss = (IStructuredSelection)this.viewer.getSelection();
        WorkflowWizard wizard = new WorkflowWizard();
        if (wfss instanceof IStructuredSelection || wfss == null) {
            wizard.init(this.getSite().getWorkbenchWindow().getWorkbench(), wfss);
        }
        WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private void startEditWF() {
        this.openWFcreationPerspective();
        IStructuredSelection wfss = (IStructuredSelection)this.viewer.getSelection();
        TextGridObject wfTGO = (TextGridObject)wfss.getFirstElement();
        if (wfTGO == null) {
            return;
        }
        IViewPart chainView = null;
        try {
            chainView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.workflow.views.ChainView");
        }
        catch (PartInitException e) {
            Status status = new Status(4, "info.textgrid.lab.workflow", "View with workflow is not existent", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        if (chainView != null && chainView instanceof ChainView) {
            ChainView cvInstance = (ChainView)chainView;
            cvInstance.setChainFromTGWF(wfTGO);
        }
    }

    public void refreshViewer() {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setQueryMetadata("format:\"text/tg.workflow+xml\"");
        this.viewer.setInput((Object)searchRequest);
    }

    private void startJob() {
        IStructuredSelection wfss = (IStructuredSelection)this.viewer.getSelection();
        TextGridObject wfTGO = (TextGridObject)wfss.getFirstElement();
        if (wfTGO == null) {
            return;
        }
        IViewPart inputView = null;
        try {
            inputView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.workflow.views.WorkflowInputs");
        }
        catch (PartInitException e) {
            Status status = new Status(4, "info.textgrid.lab.workflow", "View with input documents for this workflow is not existent, will be empty workflow batch", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        ArrayList<ArrayList<TextGridObject>> inputTGOs = new ArrayList();
        if (inputView != null && inputView instanceof WorkflowInputs) {
            WorkflowInputs wfiInstance = (WorkflowInputs)inputView;
            inputTGOs = wfiInstance.getInputs();
        }
        IStructuredSelection spss = (IStructuredSelection)this.selectedProjectViewer.getSelection();
        String targetProject = null;
        if (spss.getFirstElement() instanceof TextGridProject) {
            TextGridProject targetProjectObject = (TextGridProject)spss.getFirstElement();
            targetProject = targetProjectObject.getId();
            if (targetProject == null) {
                this.showMessage(Messages.ListOfWorkflows_NoTargetProjectSelectedMessage);
                return;
            }
        } else {
            this.showMessage(Messages.ListOfWorkflows_NoTargetProjectSelectedMessage);
            return;
        }
        if (!ChainGWDL.checkForEqualNumbers(inputTGOs, this.inputLinks)) {
            this.showMessage(Messages.ListOfWorkflows_DifferentNumberOfInputsMesssage);
            return;
        }
        WorkflowJob aJob = new WorkflowJob(wfTGO, targetProject, inputTGOs, this.inputLinks);
        aJob.start();
        IViewPart jmView = null;
        try {
            jmView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.workflow.views.JobManagement");
        }
        catch (PartInitException e) {
            Status status = new Status(4, "info.textgrid.lab.workflow", "Could not open workflow job management view", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        if (jmView != null && jmView instanceof JobManagement) {
            JobManagement jmInstance = (JobManagement)jmView;
            jmInstance.refreshJobList();
        }
    }

    private void hookContextMenu(final TableViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ListOfWorkflows.this.fillContextMenu(manager, viewer);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(IMenuManager manager, TableViewer viewer) {
        MenuManager openWithSubMenu = new MenuManager(Messages.ListOfWorkflows_openwithmenu);
        Object firstElement = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
        if (firstElement == null) {
            return;
        }
        IFile iFile = (IFile)((IAdaptable)firstElement).getAdapter(IFile.class);
        openWithSubMenu.add((IContributionItem)new TGOpenWithMenu(this.getSite().getPage(), (IAdaptable)iFile));
        manager.add((IContributionItem)openWithSubMenu);
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.ListOfWorkflows_CommonViewMessageTiitle, (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        AuthBrowser.removeSIDChangedListener((AuthBrowser.ISIDChangedListener)this.sidChangedListener);
        if (this.selectedWorkflowListener != null) {
            this.getSite().getPage().removeSelectionListener(this.selectedWorkflowListener);
        }
    }

    private void showInputs(final TextGridObject wf) {
        if (this.currentJob != null) {
            this.currentJob.cancel();
        }
        this.currentJob = new Job(Messages.ListOfWorkflows_25){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.ListOfWorkflows_26, -1);
                IFile sf = (IFile)wf.getAdapter(IFile.class);
                try {
                    Tgwf tgwf = (Tgwf)JAXB.unmarshal((InputStream)sf.getContents(true), Tgwf.class);
                    monitor.worked(1);
                    if (tgwf.getActivities() == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ChainTGWF chainTgwf = new ChainTGWF(tgwf);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ListOfWorkflows.this.chain = chainTgwf.getChain();
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                ListOfWorkflows.this.inputLinks = ListOfWorkflows.this.chain.getInputLinks();
                monitor.worked(1);
                if (monitor.isCanceled() || ListOfWorkflows.this.viewer.getTable().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                ListOfWorkflows.this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IViewPart inputView = null;
                        try {
                            inputView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(Messages.ListOfWorkflows_27);
                        }
                        catch (PartInitException e) {
                            Status status = new Status(4, "info.textgrid.lab.workflow", Messages.ListOfWorkflows_28, (Throwable)e);
                            Activator.getDefault().getLog().log((IStatus)status);
                        }
                        if (inputView != null && inputView instanceof WorkflowInputs) {
                            WorkflowInputs wfiInstance = (WorkflowInputs)inputView;
                            wfiInstance.drawInputBoxes(ListOfWorkflows.this.inputLinks);
                        }
                    }
                });
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.currentJob.setPriority(20);
        this.currentJob.schedule();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

