/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.dialogs.INewObjectPreparator;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizard;
import info.textgrid.lab.ui.core.dialogs.NewObjectWizard;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.namespaces.metadata.agent._2010.PersonType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class NewServiceDescriptionPreparator
implements INewObjectPreparator {
    private ITextGridWizard wizard;
    public static final String TEMPLATE_PATH = "resources/EmptyService.service";
    private static final String LINESEPARATOR = System.getProperty("line.separator");

    public void initializeObject(TextGridObject textGridObject) {
        PersonType rightsHolder = RBACSession.getInstance().getPerson();
        textGridObject.setItemMetadata(rightsHolder);
    }

    public boolean performFinish(TextGridObject textGridObject) {
        try {
            IFile file = (IFile)AdapterUtils.getAdapter((Object)textGridObject, IFile.class);
            file.setCharset("UTF-8", null);
            StringBuffer templateBuffer = new StringBuffer();
            try {
                String s;
                URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(TEMPLATE_PATH), null);
                url = FileLocator.resolve((URL)url);
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((s = in.readLine()) != null) {
                    templateBuffer.append(String.valueOf(s) + LINESEPARATOR);
                }
                in.close();
            }
            catch (IOException e1) {
                Status status = new Status(4, "info.textgrid.lab.workflow", "Could not open template file!", (Throwable)e1);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            textGridObject.setInitialContent(templateBuffer.toString().getBytes("UTF-8"));
        }
        catch (IllegalStateException e) {
            Activator.handleProblem(2, e, "The TextGrid Service Description object {0} has already been made persistent in this new wizard. Cannot initialize its contents properly.", textGridObject);
        }
        catch (UnsupportedEncodingException e) {
            Activator.handleProblem(4, e, "UTF-8 is unsupported!? What a strange setup is this? It will be hard to run the lab here ...", new Object[0]);
        }
        catch (CoreException e) {
            Activator.handleProblem(4, e, "Core Exception during PerformFinish()", new Object[0]);
        }
        if (this.wizard instanceof NewObjectWizard) {
            return ((NewObjectWizard)this.wizard).defaultPerformFinish("info.textgrid.lab.welcome.XMLEditorPerspective");
        }
        return false;
    }

    public void setWizard(ITextGridWizard wizard) {
        this.wizard = wizard;
    }
}

