/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.wizard;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.ProjectDoesNotExistException;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.core.swtutils.PendingLabelProvider;
import info.textgrid.lab.ui.core.utils.UpdatingDeferredListContentProvider;
import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.wizard.Messages;
import info.textgrid.lab.workflow.wizard.WorkflowWizard;
import java.rmi.RemoteException;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FinalPage
extends WizardPage
implements Listener {
    WorkflowWizard wizard;
    private Boolean updateOriginalTGO = null;
    private Text nameText;
    private ComboViewer saveProjectViewer;
    private final UpdatingDeferredListContentProvider sPcontentProvider = new UpdatingDeferredListContentProvider();
    Composite composite;
    private Text descriptionText;
    private String descriptionTextString;
    private TextGridProject selectedProject;
    private String nameTextString;

    public FinalPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.FinalPage_pageTitle);
        this.setDescription(Messages.FinalPage_PageDescription);
    }

    public void createControl(Composite parent) {
        int ncol;
        this.composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = ncol = 1;
        this.composite.setLayout((Layout)gl);
        this.setControl((Control)this.composite);
        this.wizard = (WorkflowWizard)this.getWizard();
    }

    public void drawQuestions() {
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        Composite descriptionComposite = new Composite(this.composite, 0);
        GridLayout gld = new GridLayout();
        gld.numColumns = 1;
        descriptionComposite.setLayout((Layout)gld);
        Label textualDescriptionLabel = new Label(descriptionComposite, 0);
        textualDescriptionLabel.setText(Messages.FinalPage_WFDescriptionLabel);
        Composite descriptionComposite2 = new Composite(this.composite, 0);
        GridLayout gld2 = new GridLayout();
        gld2.numColumns = 2;
        descriptionComposite2.setLayout((Layout)gld2);
        Label dummy3 = new Label(descriptionComposite2, 12);
        dummy3.setText("       ");
        this.descriptionText = new Text(descriptionComposite2, 2050);
        GridData dtgd = new GridData(4, 0x1000000, true, true);
        dtgd.widthHint = 2000;
        dtgd.heightHint = 75;
        this.descriptionText.setLayoutData((Object)dtgd);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FinalPage.this.descriptionTextString = FinalPage.this.descriptionText.getText();
            }
        });
        if (this.descriptionTextString != null) {
            this.descriptionText.setText(this.descriptionTextString);
        } else if (this.wizard.getChain().getDescription().length() > 0) {
            this.descriptionText.setText(this.wizard.getChain().getDescription());
        } else {
            StringBuffer automaticDescription = new StringBuffer();
            for (ChainEntry ce : this.wizard.getChain().getChain()) {
                automaticDescription.append(ce.getName()).append(Messages.FinalPage_andForL10WFDescription);
            }
            this.descriptionText.setText(automaticDescription.substring(0, automaticDescription.length() - 5));
        }
        if (this.wizard.getOriginalTGO() == null) {
            Label l = new Label(this.composite, 4);
            l.setText(Messages.FinalPage_SaveLabel);
            Composite dummyComposite3 = new Composite(this.composite, 0);
            GridLayout gldu3 = new GridLayout();
            gldu3.numColumns = 2;
            dummyComposite3.setLayout((Layout)gldu3);
            Label dummy4 = new Label(dummyComposite3, 12);
            dummy4.setText("       ");
            Composite newMetadataComposite4 = new Composite(dummyComposite3, 0);
            GridLayout gl4 = new GridLayout();
            gl4.numColumns = 1;
            newMetadataComposite4.setLayout((Layout)gl4);
            this.drawNameProject(newMetadataComposite4, "", "");
            this.updateOriginalTGO = false;
        } else {
            Button keepOriginalMetadata = new Button(this.composite, 16);
            keepOriginalMetadata.setText(Messages.FinalPage_UpdateRadioBUtton);
            keepOriginalMetadata.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FinalPage.this.enableNewMetadata(false);
                    FinalPage.this.wizard.getContainer().updateButtons();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            Composite dummyComposite2 = new Composite(this.composite, 0);
            GridLayout gldu2 = new GridLayout();
            gldu2.numColumns = 2;
            dummyComposite2.setLayout((Layout)gldu2);
            Label dummy2 = new Label(dummyComposite2, 12);
            dummy2.setText("       ");
            Composite newMetadataComposite2 = new Composite(dummyComposite2, 0);
            GridLayout gl2 = new GridLayout();
            gl2.numColumns = 1;
            newMetadataComposite2.setLayout((Layout)gl2);
            Text readOnlyNameText = new Text(newMetadataComposite2, 12);
            readOnlyNameText.setText(this.wizard.getOriginalTitle());
            Text readOnlyProjectText = new Text(newMetadataComposite2, 12);
            try {
                readOnlyProjectText.setText(TextGridProject.getProjectInstance((String)this.wizard.getOriginalProjectId()).getName());
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
            catch (CrudServiceException e1) {
                e1.printStackTrace();
            }
            catch (ProjectDoesNotExistException e1) {
                e1.printStackTrace();
            }
            Button saveWithNewMetadata = new Button(this.composite, 16);
            saveWithNewMetadata.setText(Messages.FinalPage_CreateRadioButton);
            saveWithNewMetadata.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FinalPage.this.enableNewMetadata(true);
                    FinalPage.this.wizard.getContainer().updateButtons();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            Composite dummyComposite = new Composite(this.composite, 0);
            GridLayout gldu = new GridLayout();
            gldu.numColumns = 2;
            dummyComposite.setLayout((Layout)gldu);
            Label dummy = new Label(dummyComposite, 12);
            dummy.setText("       ");
            Composite newMetadataComposite = new Composite(dummyComposite, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 1;
            newMetadataComposite.setLayout((Layout)gl);
            this.drawNameProject(newMetadataComposite, this.wizard.getOriginalTitle(), this.wizard.getOriginalProjectId());
            this.enableNewMetadata(this.updateOriginalTGO == null ? false : this.updateOriginalTGO == false);
            if (this.updateOriginalTGO.booleanValue()) {
                keepOriginalMetadata.setSelection(true);
            } else {
                saveWithNewMetadata.setSelection(true);
            }
        }
        this.composite.layout(true, true);
    }

    public Text getDescriptionText() {
        return this.descriptionText;
    }

    public void enableNewMetadata(boolean enabled) {
        this.nameText.setEnabled(enabled);
        this.saveProjectViewer.getControl().setEnabled(enabled);
        this.composite.layout();
        this.updateOriginalTGO = !enabled;
    }

    public void drawNameProject(Composite comp, String name, final String project) {
        this.nameText = new Text(comp, 2052);
        if (this.nameTextString != null) {
            this.nameText.setText(this.nameTextString);
        } else {
            this.nameText.setText(name == null ? "" : name);
        }
        GridData gd6t = new GridData(4, 0x1000000, true, false);
        gd6t.widthHint = 2000;
        this.nameText.setLayoutData((Object)gd6t);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FinalPage.this.nameTextString = FinalPage.this.nameText.getText();
                FinalPage.this.wizard.getContainer().updateButtons();
            }
        });
        this.saveProjectViewer = new ComboViewer(comp, 4);
        GridData gd6b = new GridData(16384, 0x1000000, true, false);
        gd6b.widthHint = 250;
        this.saveProjectViewer.getControl().setLayoutData((Object)gd6b);
        this.saveProjectViewer.setContentProvider((IContentProvider)this.sPcontentProvider);
        this.saveProjectViewer.setLabelProvider((IBaseLabelProvider)new PendingLabelProvider());
        this.saveProjectViewer.setInput((Object)TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)TextGridProjectRoot.LEVELS.EDITOR));
        this.saveProjectViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FinalPage.this.selectedProject = (TextGridProject)((IStructuredSelection)FinalPage.this.saveProjectViewer.getSelection()).getFirstElement();
                FinalPage.this.wizard.getContainer().updateButtons();
            }
        });
        DeferredListContentProvider.IDoneListener doneListener = new DeferredListContentProvider.IDoneListener(){

            public void loadDone(Viewer viewer) {
                try {
                    if (FinalPage.this.selectedProject != null) {
                        FinalPage.this.saveProjectViewer.setSelection((ISelection)new StructuredSelection((Object)FinalPage.this.selectedProject));
                    } else if (project != "") {
                        FinalPage.this.saveProjectViewer.setSelection((ISelection)new StructuredSelection((Object)TextGridProject.getProjectInstance((String)project)), true);
                    }
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (CrudServiceException e) {
                    e.printStackTrace();
                }
                catch (ProjectDoesNotExistException e) {
                    e.printStackTrace();
                }
            }
        };
        this.sPcontentProvider.addDoneListener(doneListener);
    }

    public String getDescriptionTextString() {
        return this.descriptionTextString;
    }

    public TextGridProject getSelectedProject() {
        return this.selectedProject;
    }

    public String getNameTextString() {
        return this.nameTextString;
    }

    public void setDescriptionTextString(String descriptionTextString) {
        this.descriptionTextString = descriptionTextString;
    }

    public void setSelectedProject(TextGridProject selectedProject) {
        this.selectedProject = selectedProject;
    }

    public void setNameTextString(String nameTextString) {
        this.nameTextString = nameTextString;
    }

    public Boolean getUpdateOriginalTGO() {
        return this.updateOriginalTGO;
    }

    public void handleEvent(Event event) {
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        return true;
    }
}

