/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.wizard;

import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.MetadataTransformer;
import info.textgrid.lab.workflow.views.MetadataTransformerDialogue;
import info.textgrid.lab.workflow.wizard.FinalPage;
import info.textgrid.lab.workflow.wizard.Messages;
import info.textgrid.lab.workflow.wizard.WorkflowWizard;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class MetadataTransformationPage
extends WizardPage
implements Listener {
    Chain chain;
    private ArrayList<EntryLink> outputs;
    private ArrayList<EntryLink> inputs;
    private Composite composite;
    private int numberOfOutputs = 0;

    public MetadataTransformationPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.MetadataTransformationPage_pageTitle);
        this.setDescription(Messages.MetadataTransformationPage_pageDescription);
    }

    public void createControl(Composite parent) {
        int ncol;
        this.composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = ncol = 4;
        this.composite.setLayout((Layout)gl);
        this.setControl((Control)this.composite);
        this.chain = ((WorkflowWizard)this.getWizard()).getChain();
        this.refreshTransformerArea();
    }

    private void readLinks() {
        this.outputs = new ArrayList();
        this.inputs = new ArrayList();
        for (EntryLink l : this.chain.getLinks()) {
            if (l.isUndecided() || l.isDeleted().booleanValue()) continue;
            if (l.getFrom() == null && l.getFromPort() == null) {
                this.inputs.add(l);
            }
            if (l.getTo() != null || l.getToPort() != null) continue;
            this.outputs.add(l);
        }
        this.numberOfOutputs = this.outputs.size();
    }

    public void refreshTransformerArea() {
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.readLinks();
        Iterator<EntryLink> iterator = this.outputs.iterator();
        while (iterator.hasNext()) {
            EntryLink l;
            final EntryLink outputLink = l = iterator.next();
            Label outputName = new Label(this.composite, 4);
            outputName.setText(String.valueOf(l.getFrom().getName()) + " / " + l.getFromPort().getName());
            Label fromLabel = new Label(this.composite, 4);
            fromLabel.setText(Messages.MetadataTransformationPage_GenerateFromLabel);
            MetadataTransformer myMDT = null;
            for (MetadataTransformer mdt : this.chain.getTransformers()) {
                if (!mdt.getOutput().equals(l) || !this.inputs.contains(mdt.getFromInput())) continue;
                myMDT = mdt;
            }
            if (myMDT == null) {
                myMDT = new MetadataTransformer();
                myMDT.setOutput(l);
                myMDT.setDefaultParams();
                this.chain.getTransformers().add(myMDT);
            }
            final int myMDTindex = this.chain.getTransformers().indexOf(myMDT);
            final ComboViewer cv = new ComboViewer(this.composite, 4);
            cv.setLabelProvider((IBaseLabelProvider)new mdtLabelProvider());
            cv.setContentProvider((IContentProvider)new ArrayContentProvider());
            cv.setInput(this.inputs);
            cv.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection spss = (IStructuredSelection)cv.getSelection();
                    EntryLink inputLink = null;
                    if (spss.getFirstElement() instanceof EntryLink && (inputLink = (EntryLink)spss.getFirstElement()) != null) {
                        for (MetadataTransformer mdt : MetadataTransformationPage.this.chain.getTransformers()) {
                            if (!mdt.getOutput().equals(outputLink)) continue;
                            mdt.setFromInput(inputLink);
                            MetadataTransformationPage.this.setPageComplete(MetadataTransformationPage.this.checkPageComplete());
                        }
                    }
                }
            });
            if (this.inputs.contains(myMDT.getFromInput())) {
                cv.setSelection((ISelection)new StructuredSelection((Object)myMDT.getFromInput()), true);
            } else if (this.inputs.size() == 1) {
                cv.setSelection((ISelection)new StructuredSelection((Object)this.inputs.get(0)), true);
                myMDT.setFromInput(this.inputs.get(0));
                this.setPageComplete(this.checkPageComplete());
            }
            Button configureButton = new Button(this.composite, 8);
            configureButton.setText(Messages.MetadataTransformationPage_ConfigureButton);
            configureButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    MetadataTransformerDialogue mdtd = new MetadataTransformerDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    mdtd.setContents(MetadataTransformationPage.this.chain.getTransformers().get(myMDTindex));
                    mdtd.setBlockOnOpen(true);
                    mdtd.open();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        this.composite.layout(true, true);
    }

    public void handleEvent(Event event) {
    }

    public boolean checkPageComplete() {
        int outputsLeft = this.numberOfOutputs;
        for (MetadataTransformer mdt : this.chain.getTransformers()) {
            if (mdt.getFromInput() == null) continue;
            --outputsLeft;
        }
        boolean complete = outputsLeft == 0;
        return complete;
    }

    public boolean canFlipToNextPage() {
        return this.checkPageComplete();
    }

    public boolean isPageComplete() {
        return true;
    }

    public IWizardPage getNextPage() {
        FinalPage fp = ((WorkflowWizard)this.getWizard()).finalPage;
        fp.drawQuestions();
        return fp;
    }

    class mdtLabelProvider
    extends LabelProvider {
        mdtLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof EntryLink) {
                EntryLink l = (EntryLink)obj;
                return String.valueOf(l.getTo().getName()) + "/" + l.getToPort().getName();
            }
            return "unknown class: " + obj.getClass();
        }
    }
}

