/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.controller;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.linkeditor.controller.Activator;
import info.textgrid.lab.linkeditor.controller.LinkEditorController;
import info.textgrid.lab.linkeditor.controller.TeiFactory.OMUtil;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGGroup;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGImage;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGShape;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGText;
import info.textgrid.lab.linkeditor.controller.TeiFactory.TEIDocFactory;
import info.textgrid.lab.linkeditor.controller.TeiFactory.TEILink;
import info.textgrid.lab.linkeditor.controller.TeiFactory.TEILinkGroup;
import info.textgrid.lab.linkeditor.controller.utils.Pair;
import info.textgrid.lab.linkeditor.model.graphics.TGLayer;
import info.textgrid.lab.linkeditor.model.graphics.TGLayerManager;
import info.textgrid.lab.linkeditor.model.graphics.TGLine;
import info.textgrid.lab.linkeditor.model.graphics.TGPolygon;
import info.textgrid.lab.linkeditor.model.graphics.TGRectangle;
import info.textgrid.lab.linkeditor.model.graphics.TGShape;
import info.textgrid.lab.linkeditor.model.links.ILink;
import info.textgrid.lab.linkeditor.model.links.PolyLink;
import info.textgrid.lab.linkeditor.model.links.RectLink;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.jaxen.JaxenException;

public class TEIDocParser {
    private Map<String, SVGGroup> SVGGroupsMap = Collections.synchronizedMap(new HashMap());
    private List<TEILinkGroup> teiLinkGroupsList = Collections.synchronizedList(new ArrayList());
    private LinkEditorController controller = LinkEditorController.getInstance();
    private static String COMMA = ",";
    private Job fetchingResJob = null;
    private String parentPath = null;
    private int counter = 0;

    public void parse(InputStream input, IProgressMonitor monitor) throws XMLStreamException, JaxenException {
        OMElement root;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(root = new StAXOMBuilder(input).getDocumentElement()).getLocalName().equals("TEI")) {
            new UIJob("Starting error dialog..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Status status = new Status(4, "info.textgrid.lab.linkeditor.controller", "Old style Text-Image-Link Object");
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Old style Text-Image-Link Object", (String)"The selected Text-Image-Link Object is not supported!", (IStatus)status);
                    return Status.OK_STATUS;
                }
            }.schedule();
            return;
        }
        this.fetchingResJob = new Job("Fetching resources..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TEIDocParser.this.openAllUsedTGResources(root, monitor);
                    return Status.OK_STATUS;
                }
                catch (JaxenException e) {
                    Activator.handleError(e);
                }
                catch (CrudServiceException e) {
                    Activator.handleError(e);
                }
                catch (IOException e) {
                    Activator.handleError(e);
                }
                catch (URISyntaxException e) {
                    Activator.handleError(e);
                }
                return Status.CANCEL_STATUS;
            }
        };
        this.fetchingResJob.setProgressGroup(monitor, 60);
        this.fetchingResJob.setUser(true);
        this.fetchingResJob.schedule();
        try {
            this.fetchingResJob.join();
        }
        catch (InterruptedException e) {
            Activator.handleWarning(e);
        }
        if (this.fetchingResJob.getResult() != Status.OK_STATUS) {
            return;
        }
        this.createLinks(root, monitor);
    }

    private void openAllUsedTGResources(OMElement rootElem, IProgressMonitor monitor) throws JaxenException, IOException, URISyntaxException, CrudServiceException {
        List imageElements = OMUtil.getElementListWithName("image", rootElem, TEIDocFactory.SVG_NS_URI, TEIDocFactory.SVG_NS_Prefix);
        TreeSet<String> xmlImageResources = new TreeSet<String>();
        for (OMElement e : imageElements) {
            String imageUri = e.getAttributeValue(new QName(TEIDocFactory.XLINK_NS_URI, "href", TEIDocFactory.XLINK_NS_Prefix));
            xmlImageResources.add(imageUri);
        }
        List linkElems = OMUtil.getElementListWithName("link", rootElem, TEIDocFactory.TEI_NS_URI, TEIDocFactory.TEI_NS_Prefix);
        for (OMElement e : linkElems) {
            String textUri = this.getTextUriFromElement(e, monitor);
            xmlImageResources.add(textUri);
        }
        for (String s : xmlImageResources) {
            if (!s.startsWith("textgrid") && !s.startsWith("file")) {
                if (this.parentPath != null) {
                    this.controller.addResourceToLinkEditor(new File(this.parentPath, s).toURI().toString(), monitor);
                    continue;
                }
                throw new IOException("No valid TextGrid/File-uri found!");
            }
            this.controller.addResourceToLinkEditor(s, monitor);
        }
    }

    private void createLinks(OMElement rootElem, IProgressMonitor monitor) throws JaxenException {
        List SVGGroupElements = OMUtil.getElementListWithName("g", rootElem, TEIDocFactory.SVG_NS_URI, TEIDocFactory.SVG_NS_Prefix);
        for (OMElement g : SVGGroupElements) {
            SVGGroup group = this.getSVGGroupFromOM(g, monitor);
            this.SVGGroupsMap.put(group.getId(), group);
        }
        List teiLinkGroupElements = OMUtil.getElementListWithName("linkGrp", rootElem, TEIDocFactory.TEI_NS_URI, TEIDocFactory.TEI_NS_Prefix);
        for (OMElement linkGrp : teiLinkGroupElements) {
            TEILinkGroup group = this.getTeiLinkGroupFromOM(linkGrp, monitor);
            this.teiLinkGroupsList.add(group);
        }
        for (TEILinkGroup g : this.teiLinkGroupsList) {
            List<TEILink> teilinks = g.getLinks();
            final int size = teilinks.size();
            for (TEILink l : teilinks) {
                final ILink link = l.getLink();
                this.controller.addLink(link);
                new UIJob("Updating the image views..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TEIDocParser tEIDocParser = TEIDocParser.this;
                        int n = tEIDocParser.counter + 1;
                        tEIDocParser.counter = n;
                        if (n < size) {
                            TEIDocParser.this.controller.notifyListeners(LinkEditorController.Event.ADD_LINK_LOADING, new Pair<String, TGShape>(link.getImageUri(), link.getShape()));
                        } else {
                            TEIDocParser.this.controller.notifyListeners(LinkEditorController.Event.ADD_LINK, new Pair<String, TGShape>(link.getImageUri(), link.getShape()));
                            TEIDocParser.this.counter = 0;
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    private SVGImage getSVGImageFromOM(OMElement imageElem, IProgressMonitor monitor) {
        String uri = imageElem.getAttributeValue(new QName(TEIDocFactory.XLINK_NS_URI, "href", TEIDocFactory.XLINK_NS_Prefix));
        Point p = this.getImageWidthHeight(uri);
        int width = p.x;
        int height = p.y;
        return new SVGImage(uri, width, height);
    }

    private void setTGShapeLayer(String layer_, TGShape s) {
        if (layer_ == null) {
            layer_ = LinkEditorController.getDefaultLayer();
        }
        try {
            String[] strLayer_Split = layer_.split(",");
            if (strLayer_Split.length < 1) {
                return;
            }
            s.setLayer(Integer.valueOf(strLayer_Split[0].trim()).intValue());
            if (strLayer_Split.length > 1) {
                s.setLayerName(strLayer_Split[1].trim());
                if (strLayer_Split.length > 2) {
                    String rgbStr = strLayer_Split[2].trim();
                    String[] strRGB_Split = rgbStr.split("#");
                    if (strRGB_Split.length < 1) {
                        return;
                    }
                    s.setLayerRGB(new RGB(new Integer(strRGB_Split[0]).intValue(), new Integer(strRGB_Split[1]).intValue(), new Integer(strRGB_Split[2]).intValue()));
                }
            }
        }
        catch (NumberFormatException e) {
            Activator.handleError(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    private TGRectangle createTGRect(String rect_, String imageUri_, String rotate_, String layer_, int imageWidth, int imageHeight) {
        if ((rect_ = this.controller.percentToRect(rect_, imageWidth, imageHeight)) == null) {
            return null;
        }
        String[] strA_Split = rect_.split(",");
        int x = Math.round(Float.valueOf(strA_Split[0].trim()).floatValue());
        int y = Math.round(Float.valueOf(strA_Split[1].trim()).floatValue());
        int width = Math.round(Float.valueOf(strA_Split[2].trim()).floatValue());
        int height = Math.round(Float.valueOf(strA_Split[3].trim()).floatValue());
        TGRectangle r = new TGRectangle(x, y, width, height, imageUri_);
        r.setRotationValue(Double.valueOf(rotate_).doubleValue());
        this.setTGShapeLayer(layer_, (TGShape)r);
        return r;
    }

    private TGPolygon createTGPolygon(String poly_, String imageUri_, String layer_, int imageWidth, int imageHeight) {
        if ((poly_ = this.controller.percentToPoly(poly_, imageWidth, imageHeight)) == null) {
            return null;
        }
        String[] strA_Split = poly_.split(",");
        int x = 0;
        int y = 0;
        TGPolygon p = new TGPolygon(imageUri_);
        this.setTGShapeLayer(layer_, (TGShape)p);
        int i = 0;
        String[] stringArray = strA_Split;
        int n = strA_Split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (i % 2 == 0) {
                x = Math.round(Float.valueOf(s.trim()).floatValue());
            } else {
                y = Math.round(Float.valueOf(s.trim()).floatValue());
                p.addPoint(x, y);
            }
            ++i;
            ++n2;
        }
        return p;
    }

    private TGLine createTGLine(String dockingLine_, String imageUri_, String layer_, int imageWidth, int imageHeight) {
        if ((dockingLine_ = this.controller.percentToDockingLine(dockingLine_, imageWidth, imageHeight)) == null) {
            return null;
        }
        String[] strA_Split = dockingLine_.split(",");
        int x = 0;
        int y = 0;
        TGLine gline = new TGLine(imageUri_);
        this.setTGShapeLayer(layer_, (TGShape)gline);
        int i = 0;
        String[] stringArray = strA_Split;
        int n = strA_Split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (i % 2 == 0) {
                x = Math.round(Float.valueOf(s.trim()).floatValue());
            } else {
                y = Math.round(Float.valueOf(s.trim()).floatValue());
                gline.addPoint(x, y);
            }
            ++i;
            ++n2;
        }
        return gline;
    }

    private SVGGroup getSVGGroupFromOM(OMElement gElem, IProgressMonitor monitor) throws JaxenException {
        String groupId = gElem.getAttributeValue(new QName("id"));
        final String default_writing_mode = gElem.getAttributeValue(new QName("writing-mode"));
        SVGGroup group = new SVGGroup(groupId, this.controller.getWritingModeFromString(default_writing_mode));
        OMElement imageElem = OMUtil.getElementWithName("image", gElem, TEIDocFactory.SVG_NS_URI, TEIDocFactory.SVG_NS_Prefix);
        SVGImage svgImage = this.getSVGImageFromOM(imageElem, monitor);
        final String uri = this.getValidUri(svgImage.getUri(), true);
        group.setImage(svgImage);
        new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TEIDocParser.this.controller.setDefaultWritingMode(uri, TEIDocParser.this.controller.getWritingModeFromString(default_writing_mode));
                return Status.OK_STATUS;
            }
        }.schedule();
        TGLayerManager tgLM = new TGLayerManager(uri);
        TreeSet<TGLayer> tgLayerTreeSet = new TreeSet<TGLayer>();
        List rectElems = OMUtil.getElementListWithName("rect", gElem, TEIDocFactory.SVG_NS_URI, TEIDocFactory.SVG_NS_Prefix);
        for (OMElement rectElem : rectElems) {
            SVGShape shape = this.getSVGRectFromOM(rectElem, uri, monitor);
            group.addShape(shape);
            TGLayer tgLayer = new TGLayer(shape.getShape().getLayerName(), Integer.valueOf(shape.getShape().getLayer()).intValue());
            tgLayer.setLayercolor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), shape.getShape().getLayerRGB()));
            tgLayerTreeSet.add(tgLayer);
        }
        List polyElems = OMUtil.getElementListWithName("polygon", gElem, TEIDocFactory.SVG_NS_URI, TEIDocFactory.SVG_NS_Prefix);
        for (OMElement polyElem : polyElems) {
            SVGShape shape = this.getSVGPolygonFromOM(polyElem, uri, monitor);
            group.addShape(shape);
            TGLayer tgLayer = new TGLayer(shape.getShape().getLayerName(), Integer.valueOf(shape.getShape().getLayer()).intValue());
            tgLayer.setLayercolor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), shape.getShape().getLayerRGB()));
            tgLayerTreeSet.add(tgLayer);
        }
        for (TGLayer obj : tgLayerTreeSet) {
            if (obj.getNumber() == 0) continue;
            tgLM.add(Integer.valueOf(obj.getNumber()), obj);
        }
        List lineElems = OMUtil.getElementListWithName("line", gElem, TEIDocFactory.SVG_NS_URI, TEIDocFactory.SVG_NS_Prefix);
        for (OMElement lineElem : lineElems) {
            SVGShape shape = this.getSVGLineFromOM(lineElem, uri, monitor);
            group.addShape(shape);
        }
        List textElems = OMUtil.getElementListWithName("text", gElem, TEIDocFactory.SVG_NS_URI, TEIDocFactory.SVG_NS_Prefix);
        for (OMElement textElem : textElems) {
            SVGText text = this.getSVGTextFromOM(textElem, uri, monitor);
            group.addText(text);
        }
        this.controller.addLayerManagerToMap(tgLM);
        return group;
    }

    private SVGShape getSVGRectFromOM(OMElement rectElem, String uri, IProgressMonitor monitor) throws JaxenException {
        String id = rectElem.getAttributeValue(new QName("id"));
        String x = rectElem.getAttributeValue(new QName("x")).replace("%", "");
        String y = rectElem.getAttributeValue(new QName("y")).replace("%", "");
        String width = rectElem.getAttributeValue(new QName("width")).replace("%", "");
        String height = rectElem.getAttributeValue(new QName("height")).replace("%", "");
        String rect_s = String.valueOf(x) + COMMA + y + COMMA + width + COMMA + height;
        String rotate = rectElem.getAttributeValue(new QName("transform")).replaceFirst(".*\\(", "").replaceFirst("\\,.*", "");
        String layer = rectElem.getAttributeValue(new QName("class"));
        Point p = this.getImageWidthHeight(uri);
        TGRectangle rect = this.createTGRect(rect_s, uri, rotate, layer, p.x, p.y);
        return new SVGShape(id, (TGShape)rect, p.x, p.y);
    }

    private String getValidUri(String uri, boolean isImageUri) {
        String absoluteUri = uri;
        if (!uri.startsWith("textgrid") && !uri.startsWith("file") && this.parentPath != null) {
            absoluteUri = new File(this.parentPath, uri).toURI().toString();
            return absoluteUri;
        }
        if (absoluteUri.startsWith("textgrid") && !absoluteUri.matches("textgrid:.+\\.\\d+")) {
            absoluteUri = this.controller.getRevisionedUri(uri, isImageUri);
        }
        return absoluteUri;
    }

    private Point getImageWidthHeight(String imageUri) {
        return this.controller.getImageWidthHeight(this.getValidUri(imageUri, true));
    }

    private SVGShape getSVGPolygonFromOM(OMElement polyElem, String uri, IProgressMonitor monitor) throws JaxenException {
        String id = polyElem.getAttributeValue(new QName("id"));
        String points = polyElem.getAttributeValue(new QName("points")).replaceAll("%", "").replaceAll("\\s", COMMA);
        String layer = polyElem.getAttributeValue(new QName("class"));
        Point p = this.getImageWidthHeight(uri);
        TGPolygon poly = this.createTGPolygon(points, uri, layer, p.x, p.y);
        return new SVGShape(id, (TGShape)poly, p.x, p.y);
    }

    private SVGShape getSVGLineFromOM(OMElement lineElem, final String uri, IProgressMonitor monitor) throws JaxenException {
        String id = lineElem.getAttributeValue(new QName("id"));
        String x1 = lineElem.getAttributeValue(new QName("x1")).replace("%", "");
        String y1 = lineElem.getAttributeValue(new QName("y1")).replace("%", "");
        String x2 = lineElem.getAttributeValue(new QName("x2")).replace("%", "");
        String y2 = lineElem.getAttributeValue(new QName("y2")).replace("%", "");
        String layer = lineElem.getAttributeValue(new QName("class"));
        String line_s = String.valueOf(x1) + COMMA + y1 + COMMA + x2 + COMMA + y2;
        Point p = this.getImageWidthHeight(uri);
        final TGLine line = this.createTGLine(line_s, uri, layer, p.x, p.y);
        this.controller.addTosaveDockingLinesUriList(uri);
        new UIJob("Updating the image views..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TEIDocParser.this.controller.notifyListeners(LinkEditorController.Event.ADD_DOCKING_LINE, new Pair<String, TGLine>(uri, line));
                return Status.OK_STATUS;
            }
        }.schedule();
        return new SVGShape(id, (TGShape)line, p.x, p.y);
    }

    private SVGText getSVGTextFromOM(OMElement textElem, String uri, IProgressMonitor monitor) throws JaxenException {
        String id = textElem.getAttributeValue(new QName("id"));
        String writing_mode = textElem.getAttributeValue(new QName("writing-mode"));
        return new SVGText(id, this.controller.getWritingModeFromString(writing_mode));
    }

    private TEILinkGroup getTeiLinkGroupFromOM(OMElement linkGrpElem, IProgressMonitor monitor) throws JaxenException {
        String id = linkGrpElem.getAttributeValue(new QName(TEIDocFactory.XML_NS_URI, "id", TEIDocFactory.XML_NS_Prefix));
        String type = linkGrpElem.getAttributeValue(new QName("type"));
        String facs = linkGrpElem.getAttributeValue(new QName("facs"));
        SVGGroup g = this.SVGGroupsMap.get(facs.substring(1));
        TEILinkGroup teiLinkgroup = new TEILinkGroup(id, type, g);
        List teiLinkElems = OMUtil.getElementListWithName("link", linkGrpElem, TEIDocFactory.TEI_NS_URI, TEIDocFactory.TEI_NS_Prefix);
        for (OMElement teiLinkElem : teiLinkElems) {
            TEILink link = this.getTEILinkFromOM(teiLinkElem, g, teiLinkgroup, monitor);
            if (link == null) continue;
            teiLinkgroup.addLink(link);
        }
        return teiLinkgroup;
    }

    private String getTextUriFromElement(OMElement linkElem, IProgressMonitor monitor) {
        String targets = linkElem.getAttributeValue(new QName("targets"));
        String[] values = targets.split("\\s");
        if (values.length < 2) {
            throw new RuntimeException(NLS.bind((String)"The target attribute in tei:link have {0} values.", (Object)values.length));
        }
        return values[1].split("#")[0];
    }

    private TEILink getTEILinkFromOM(OMElement linkElem, SVGGroup g, TEILinkGroup teiLinkGroup, IProgressMonitor monitor) {
        OMAttribute targets = linkElem.getAttribute(new QName("targets"));
        String[] values = targets.getAttributeValue().split("\\s");
        if (values.length < 2) {
            throw new RuntimeException(NLS.bind((String)"The target attribute in tei:link have {0} values.", (Object)values.length));
        }
        String refId = values[0].substring(1);
        String textUri = values[1].split("#")[0];
        textUri = this.getValidUri(textUri, false);
        RectLink link = null;
        if (values.length > 2) {
            String anchorId1 = values[1].split("#")[1];
            String anchorId2 = values[2].split("#")[1];
            if (refId.startsWith("shape")) {
                TGShape shape = g.getSVGShapeById(refId).getShape();
                if (shape.getType() == TGShape.TYPE.RECT) {
                    link = new RectLink((TGRectangle)shape, anchorId1, anchorId2, textUri, true);
                } else if (shape.getType() == TGShape.TYPE.POLY) {
                    link = new PolyLink((TGPolygon)shape, anchorId1, anchorId2, textUri, true);
                }
                return new TEILink(refId, (ILink)link);
            }
            if (refId.startsWith("text")) {
                for (TEILink tl : teiLinkGroup.getLinks()) {
                    ILink _l = tl.getLink();
                    if (!_l.getTextUri().equals(textUri) || !_l.getStartAnchorId().equals(anchorId1) || !_l.getEndAnchorId().equals(anchorId2)) continue;
                    TGShape.WRITING_MODE writing_mode = g.getSVGTextById(refId).getWriting_mode();
                    _l.getShape().setWritingMode(writing_mode);
                }
            }
        } else if (values.length == 2) {
            String id = values[1].split("#")[1];
            if (refId.startsWith("shape")) {
                TGShape shape = g.getSVGShapeById(refId).getShape();
                if (shape.getType() == TGShape.TYPE.RECT) {
                    link = new RectLink((TGRectangle)shape, id, "", textUri, true);
                } else if (shape.getType() == TGShape.TYPE.POLY) {
                    link = new PolyLink((TGPolygon)shape, id, "", textUri, true);
                }
                return new TEILink(refId, (ILink)link);
            }
            if (refId.startsWith("text")) {
                for (TEILink tl : teiLinkGroup.getLinks()) {
                    ILink _l = tl.getLink();
                    if (!_l.getTextUri().equals(textUri) || !_l.getStartAnchorId().equals(id) || !_l.getEndAnchorId().equals("")) continue;
                    TGShape.WRITING_MODE writing_mode = g.getSVGTextById(refId).getWriting_mode();
                    _l.getShape().setWritingMode(writing_mode);
                }
            }
        } else {
            throw new RuntimeException(NLS.bind((String)"The target attribute in tei:link have {0} values.", (Object)values.length));
        }
        return null;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public String getParentPath() {
        return this.parentPath;
    }
}

