/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.controller.TeiFactory;

import info.textgrid.lab.linkeditor.controller.TeiFactory.IElement;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGImage;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGShape;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGText;
import info.textgrid.lab.linkeditor.model.graphics.TGShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class SVGGroup
implements IElement {
    private String id;
    private TGShape.WRITING_MODE writingMode;
    private SVGImage image;
    private List<SVGShape> shapes;
    private List<SVGText> texts;

    public SVGGroup(String id, TGShape.WRITING_MODE writingMode) {
        this.id = id;
        this.shapes = Collections.synchronizedList(new ArrayList());
        this.texts = Collections.synchronizedList(new ArrayList());
        this.writingMode = writingMode;
    }

    public String getId() {
        return this.id;
    }

    public SVGImage getImage() {
        return this.image;
    }

    public void setImage(SVGImage image) {
        this.image = image;
    }

    public List<SVGShape> getShapes() {
        return this.shapes;
    }

    public void setShapes(ArrayList<SVGShape> shapes) {
        this.shapes = shapes;
    }

    public boolean addShape(SVGShape shape) {
        return this.shapes.add(shape);
    }

    public boolean removeShape(SVGShape shape) {
        return this.shapes.remove(shape);
    }

    public List<SVGText> getTexts() {
        return this.texts;
    }

    public void setTexts(ArrayList<SVGText> texts) {
        this.texts = texts;
    }

    public boolean addText(SVGText text) {
        return this.texts.add(text);
    }

    public boolean removeText(SVGText text) {
        return this.texts.remove(text);
    }

    public TGShape.WRITING_MODE getWritingMode() {
        return this.writingMode;
    }

    public void setWritingMode(TGShape.WRITING_MODE writingMode) {
        this.writingMode = writingMode;
    }

    public SVGShape getSVGShapeById(String id) {
        for (SVGShape shape : this.shapes) {
            if (!shape.getId().equals(id)) continue;
            return shape;
        }
        return null;
    }

    public SVGText getSVGTextById(String id) {
        for (SVGText text : this.texts) {
            if (!text.getId().equals(id)) continue;
            return text;
        }
        return null;
    }

    @Override
    public OMElement createOMElement(OMFactory factory, OMElement parent, OMNamespace ns) {
        OMElement gElem = factory.createOMElement("g", ns, (OMContainer)parent);
        gElem.addAttribute("id", this.id, null);
        if (this.writingMode != null && this.writingMode != TGShape.WRITING_MODE.NONE) {
            gElem.addAttribute("writing-mode", this.writingMode.toString(), null);
        }
        if (this.image != null) {
            this.image.createOMElement(factory, gElem, ns);
        }
        for (SVGShape s : this.shapes) {
            s.createOMElement(factory, gElem, ns);
        }
        for (SVGText t : this.texts) {
            t.createOMElement(factory, gElem, ns);
        }
        return gElem;
    }
}

