/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.controller.utils;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.util.StringToOM;
import info.textgrid.lab.linkeditor.controller.Activator;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RefersToClient {
    private static RefersToClient instance = null;

    public static RefersToClient getInstance() {
        if (instance == null) {
            instance = new RefersToClient();
        }
        return instance;
    }

    private RefersToClient() {
    }

    public ArrayList<String> getRelationURIs(TextGridObject object) {
        Status status;
        String md = "uri:" + object.getURI().toString();
        GetMethod method = null;
        try {
            String md2 = URLEncoder.encode(md, "UTF-8");
            String sid = RBACSession.getInstance().getSID(false);
            String url = String.valueOf(ConfClient.getInstance().getValue("tgsearch")) + "/meta?sid=" + sid + "&md=" + md2 + "&rel=get:refersTo";
            HttpClient client = new HttpClient();
            method = new GetMethod(url);
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                Status status2 = new Status(1, "info.textgrid.lab.linkeditor.controller", "Couldn't get the refersTo-relations for " + md);
                Activator.getDefault().getLog().log((IStatus)status2);
                return null;
            }
            String responseBody = method.getResponseBodyAsString();
            if (responseBody == null || responseBody.isEmpty()) {
                return null;
            }
            OMElement elem = StringToOM.getOMElement((String)responseBody);
            Iterator iter = elem.getChildrenWithName(new QName("relation"));
            ArrayList<String> uris = new ArrayList<String>();
            String uri = null;
            while (iter.hasNext()) {
                uri = ((OMElement)iter.next()).getAttributeValue(new QName("uri"));
                if (uri == null) continue;
                uris.add(uri);
            }
            ArrayList<String> arrayList = uris;
            return arrayList;
        }
        catch (HttpException e) {
            status = new Status(4, "info.textgrid.lab.linkeditor.controller", e.getMessage());
            Activator.getDefault().getLog().log((IStatus)status);
        }
        catch (IOException e) {
            status = new Status(4, "info.textgrid.lab.linkeditor.controller", e.getMessage());
            Activator.getDefault().getLog().log((IStatus)status);
        }
        catch (XMLStreamException e) {
            status = new Status(4, "info.textgrid.lab.linkeditor.controller", e.getMessage());
            Activator.getDefault().getLog().log((IStatus)status);
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }
}

