/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core;

import info.textgrid.lab.ui.core.Messages;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "info.textgrid.lab.ui.core";
    public static final String COMPLETE_IMAGE_ID = "complete";
    public static final String LOADING_IMAGE_ID = "loading";
    public static final String RESTRICTED_IMAGE_ID = "restricted_object";
    public static final String FORBIDDEN_IMAGE_ID = "forbidden_object";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus result = event.getResult();
                if ((result.getSeverity() & 6) != 0) {
                    MultiStatus status = new MultiStatus(Activator.PLUGIN_ID, 0, new IStatus[]{result}, NLS.bind((String)Messages.Activator_EM_JobError, (Object)event.getJob(), (Object)result.getMessage()), null);
                    StatusManager.getManager().handle((IStatus)status, 1);
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static IStatus handleProblem(int severity, String message, Throwable cause) {
        if ((message == null || message.length() < 1) && cause != null) {
            message = cause.getLocalizedMessage();
        }
        Status status = new Status(severity, PLUGIN_ID, message, cause);
        StatusManager.getManager().handle((IStatus)status, severity == 4 ? 3 : 1);
        return status;
    }

    public static void handleError(PartInitException e, String string, IFile file) {
    }

    public IStatus handleProblem(Throwable e) {
        return Activator.handleProblem(4, e, null, new Object[0]);
    }

    public static IStatus handleError(Throwable cause, String message, Object ... args) {
        return Activator.handleProblem(4, cause, message, args);
    }

    public static IStatus handleProblem(int severity, Throwable cause, String message, Object ... args) {
        return Activator.handleProblem(severity, NLS.bind((String)message, (Object[])args), cause);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, COMPLETE_IMAGE_ID, "icons/complete_status.gif");
        this.registerImage(registry, LOADING_IMAGE_ID, "icons/loading.png");
        this.registerImage(registry, RESTRICTED_IMAGE_ID, "icons/restricted_object.gif");
        this.registerImage(registry, FORBIDDEN_IMAGE_ID, "icons/forbidden.gif");
    }

    private void registerImage(ImageRegistry registry, String key, String fullPath) {
        URL imageURL = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(fullPath), null);
        registry.put(key, ImageDescriptor.createFromURL((URL)imageURL));
    }
}

