/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.dialogs;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.ui.core.dialogs.Messages;
import info.textgrid.lab.ui.core.handlers.ExportHandler;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OpenURIDialog
extends TitleAreaDialog {
    private static final int EXPORT = 101;
    private Text text;
    private URI uri;
    private boolean valid;
    private String input = "";

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText(input);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public URI getURI() {
        return this.uri;
    }

    public OpenURIDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Label uriLabel = new Label(area, 0);
        uriLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        uriLabel.setText("&URI:");
        this.text = new Text(area, 18564);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text.setText(this.input);
        this.text.setMessage(Messages.OpenURIDialog_IM_EnterOrPaste);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenURIDialog.this.validate();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                OpenURIDialog.this.validate();
            }
        });
        this.getShell().setText(Messages.OpenURIDialog_IM_OpenURI);
        this.setTitle(Messages.OpenURIDialog_IM_OpenTGURI);
        this.setMessage(Messages.OpenURIDialog_IM_EnterOrPasteInField);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(Messages.OpenURIDialog_LabelOpen);
        this.getButton(0).setToolTipText(Messages.OpenURIDialog_IM_OpenURIDefault);
        this.createButton(parent, 101, "E&xport ...", false);
        this.getButton(0).setToolTipText(Messages.OpenURIDialog_IM_ExportURI);
    }

    protected void validate() {
        if (this.text != null && !this.text.isDisposed()) {
            boolean valid = false;
            String userInput = this.text.getText().trim();
            try {
                URI uri = new URI(userInput);
                if ("textgrid".equalsIgnoreCase(uri.getScheme())) {
                    valid = true;
                } else {
                    this.setErrorMessage(NLS.bind((String)Messages.OpenURIDialog_EM_Scheme, (Object)uri.getScheme()));
                }
            }
            catch (URISyntaxException e) {
                this.setErrorMessage(NLS.bind((String)Messages.OpenURIDialog_EM_NotValid, (Object)userInput, (Object)e.getLocalizedMessage()));
            }
            if (valid) {
                this.setErrorMessage(null);
            }
            this.valid = valid;
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(valid);
            }
            if (this.getButton(101) != null) {
                this.getButton(101).setEnabled(valid);
            }
        }
    }

    protected void okPressed() {
        try {
            this.uri = new URI(this.text.getText());
            super.okPressed();
        }
        catch (URISyntaxException e) {
            this.setErrorMessage(NLS.bind((String)Messages.OpenURIDialog_EM_NotValid, (Object)this.text.getText(), (Object)e.getLocalizedMessage()));
        }
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 101) {
            try {
                this.uri = new URI(this.text.getText());
                TextGridObject object = TextGridObject.getInstanceOffline((URI)this.uri);
                ExportHandler.exportObjects(this.getShell(), object);
            }
            catch (URISyntaxException e) {
                this.setErrorMessage(NLS.bind((String)Messages.OpenURIDialog_EM_NotValid, (Object)this.text.getText(), (Object)e.getLocalizedMessage()));
            }
        }
    }
}

