/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.core.model.AggregationReader;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.core.swtutils.MessageDialogWithCheckbuttons;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.handlers.Messages;
import info.textgrid.namespaces.middleware.tgsearch.Response;
import info.textgrid.namespaces.middleware.tgsearch.ResultType;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DeleteJob deleteJob = null;
        boolean recursively = false;
        boolean deleteRevisions = false;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object[] objects = sel.toArray();
            Object[] textGridObjects = (TextGridObject[])AdapterUtils.getAdapters((Object[])objects, TextGridObject.class, (boolean)false);
            String message = textGridObjects.length == 1 ? NLS.bind((String)Messages.DeleteHandler_IM_WantToDelete, (Object[])textGridObjects) : NLS.bind((String)Messages.DeleteHandler_IM_WantToDelete2, (Object)textGridObjects.length);
            if (textGridObjects.length < 1) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.DeleteHandler_Title_NothingToDelete, (String)Messages.DeleteHandler_EM_NothingToDelete);
                return null;
            }
            MessageDialogWithCheckbuttons dialog = new MessageDialogWithCheckbuttons(HandlerUtil.getActiveShell((ExecutionEvent)event), Messages.DeleteHandler_DeleteObjects, null, message, 3, new String[]{Messages.DeleteHandler_Cancel, Messages.DeleteHandler_Delete}, 1, new String[]{Messages.DeleteHandler_CheckboxLabel1, Messages.DeleteHandler_CheckboxLabel2});
            int doDelete = dialog.open();
            if (doDelete < 1) {
                return null;
            }
            recursively = dialog.getCheckButtonState(0);
            deleteRevisions = dialog.getCheckButtonState(1);
            Object[] objectArray = textGridObjects;
            int n = textGridObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object tgo = objectArray[n2];
                try {
                    TGContentType contentType = tgo.getContentType(true);
                    if (contentType != null && contentType.equals(TGContentType.getContentType((String)"text/tg.projectfile+xml")) && !MessageDialog.openConfirm((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.DeleteHandler_DeleteProjectFile, (String)NLS.bind((String)Messages.DeleteHandler_EM_DeleteProjectFile, (Object)tgo.getTitle()))) {
                        return null;
                    }
                }
                catch (CoreException e) {
                    Activator.handleError(e, Messages.DeleteHandler_EM_ContentType, tgo);
                }
                ++n2;
            }
            deleteJob = new DeleteJob(Messages.DeleteHandler_DeletingObjects, (TextGridObject[])textGridObjects, recursively, deleteRevisions);
            deleteJob.setUser(true);
            deleteJob.schedule();
        }
        return deleteJob;
    }

    private final class DeleteJob
    extends Job {
        private final TextGridObject[] textGridObjects;
        private final boolean recurse;
        private final boolean deleteRevisions;

        private DeleteJob(String name, TextGridObject[] textGridObjects, boolean recurse, boolean deleteRevisions) {
            super(name);
            this.textGridObjects = textGridObjects;
            this.recurse = recurse;
            this.deleteRevisions = deleteRevisions;
        }

        public IStatus run(IProgressMonitor monitor) {
            MultiStatus multiStatus;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)(this.recurse ? Messages.DeleteHandler_IM_DeleteObjectsAndChildren : Messages.DeleteHandler_IM_DeleteObjects), (Object)this.textGridObjects.length), (int)(this.textGridObjects.length * 100));
            LinkedList<IStatus> errors = new LinkedList<IStatus>();
            TextGridObject[] textGridObjectArray = this.textGridObjects;
            int n = this.textGridObjects.length;
            int n2 = 0;
            while (n2 < n) {
                TextGridObject tgo = textGridObjectArray[n2];
                if (progress.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.delete(tgo, null, errors, progress.newChild(100));
                ++n2;
            }
            if (errors.size() == 1) {
                multiStatus = new MultiStatus("info.textgrid.lab.ui.core", 4, errors.toArray(new IStatus[0]), errors.get(0).getMessage(), null);
                Activator.getDefault().getLog().log((IStatus)multiStatus);
                return multiStatus;
            }
            if (errors.size() > 1) {
                multiStatus = new MultiStatus("info.textgrid.lab.ui.core", 4, errors.toArray(new IStatus[0]), Messages.DeleteHandler_EM_ErrorOccured, null);
                Activator.getDefault().getLog().log((IStatus)multiStatus);
                return multiStatus;
            }
            return Status.OK_STATUS;
        }

        private void delete(TextGridObject object, TextGridProject project, LinkedList<IStatus> errors, SubMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.DeleteHandler_Deleting, (Object)object), (int)10);
            try {
                if (progress.isCanceled()) {
                    return;
                }
                if (project != null && !project.equals((Object)object.getProjectInstance())) {
                    errors.add((IStatus)new Status(1, "info.textgrid.lab.ui.core", NLS.bind((String)Messages.DeleteHandler_EM_Skipped, (Object)object, (Object)object.getProjectInstance())));
                } else {
                    if (this.recurse && object.getContentTypeID().contains("tg.aggregation")) {
                        progress.setWorkRemaining(30);
                        List aggregates = AggregationReader.read((TextGridObject)object, (boolean)false);
                        progress.worked(5);
                        progress.setWorkRemaining(10 + 10 * aggregates.size());
                        for (URI uri : aggregates) {
                            this.delete(TextGridObject.getInstance((URI)uri, (boolean)false), object.getProjectInstance(), errors, progress.newChild(10));
                        }
                    }
                    if (object.isPublic()) {
                        throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.ui.core", NLS.bind((String)Messages.DeleteHandler_EM_AccessDenied, (Object)object.getTitle(), (Object)object.getURI().toString())));
                    }
                    if (this.deleteRevisions) {
                        SearchRequest searchRequest = new SearchRequest();
                        searchRequest.setQueryRevision(object.getURI().toString());
                        Response result = searchRequest.execute((IProgressMonitor)progress);
                        Iterator revisions = result.getResult().iterator();
                        SubMonitor revisionProgress = progress.newChild(result.getResult().size());
                        revisionProgress.setTaskName(NLS.bind((String)Messages.DeleteHandler_IM_DeletingRevision, (Object)object));
                        while (revisions.hasNext()) {
                            ResultType revision = (ResultType)revisions.next();
                            if (revision.getTextgridUri() != null) {
                                TextGridObject.getInstance((URI)new URI("textgrid:" + revision.getTextgridUri()), (boolean)false).delete((IProgressMonitor)progress);
                            }
                            revisionProgress.worked(1);
                        }
                    } else {
                        object.delete((IProgressMonitor)progress.newChild(10));
                    }
                }
            }
            catch (CoreException e) {
                errors.add((IStatus)new Status(e.getStatus().getSeverity(), "info.textgrid.lab.ui.core", MessageFormat.format(Messages.DeleteHandler_EM_DeletingFailed, object, e.getMessage()), (Throwable)e));
            }
            catch (Exception e) {
                errors.add((IStatus)new Status(4, "info.textgrid.lab.ui.core", MessageFormat.format(Messages.DeleteHandler_EM_CrudNotAvailable, object, e.getMessage()), (Throwable)e));
            }
        }
    }
}

