/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.core.metadataeditor.MetaDataView;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.handlers.Messages;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenMDEHandler
extends AbstractHandler {
    private static final String PARAMETER_URI_ID = "info.textgrid.lab.ui.core.commands.OpenMDE.parameter.uri";
    private static final String PARAMETER_READONLY_ID = "info.textgrid.lab.ui.core.commands.OpenMDE.parameter.readonly";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String parameterURI = null;
        TextGridObject tgo = null;
        parameterURI = event.getParameter(PARAMETER_URI_ID);
        event.getParameter(PARAMETER_READONLY_ID);
        if (parameterURI != null) {
            try {
                tgo = TextGridObject.getInstance((URI)new URI(parameterURI), (boolean)false);
            }
            catch (CrudServiceException e) {
                Activator.handleError(e, e.getMessage(), parameterURI);
            }
            catch (URISyntaxException e) {
                Activator.handleError(e, e.getMessage(), parameterURI);
            }
        } else {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                tgo = (TextGridObject)AdapterUtils.getAdapter((Object)obj, TextGridObject.class);
            }
        }
        if (tgo != null) {
            try {
                ((MetaDataView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.core.metadataeditor.view", null, 2)).setMetadataInView(tgo, true);
            }
            catch (PartInitException e) {
                Activator.handleError((Throwable)e, Messages.OpenMDEHandler_CouldNotOpenME, new Object[0]);
            }
        }
        return null;
    }
}

