/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.dictionarylinkeditor;

import info.textgrid.lab.dictionarylinkeditor.WBLemma;
import info.textgrid.lab.dictionarylinkeditor.WBLink;
import info.textgrid.lab.dictionarylinkeditor.WBLinkGroup;
import info.textgrid.lab.dictionarysearch.Activator;
import info.textgrid.lab.dictionarysearch.client.Wbb_WebService_Impl;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.PlatformObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LinkRoot
extends PlatformObject {
    private ArrayList<WBLink> wbLinks;
    private WritableList writeList;
    private ArrayList<WBLink> reserveList;
    private ArrayList<WBLink> manualList;
    private WBLemma sourceLemma;
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public LinkRoot() {
        this.wbLinks = new ArrayList();
        this.writeList = new WritableList(this.wbLinks, WBLink.class);
        this.reserveList = new ArrayList();
        this.manualList = new ArrayList();
    }

    public LinkRoot(WBLemma sourceLemma) {
        this();
        this.sourceLemma = sourceLemma;
        this.retrieveLinks();
    }

    public void retrieveLinks() {
        if (this.sourceLemma == null) {
            return;
        }
        this.clearLinks();
        String enclosure = "";
        Wbb_WebService_Impl wbservice = new Wbb_WebService_Impl();
        try {
            enclosure = wbservice.getWbb_WebServiceSoap().wbb_getLinks(String.valueOf(this.sourceLemma.getWbShortName()) + "#" + this.sourceLemma.getID());
        }
        catch (RemoteException e) {
            Activator.handleProblem(4, e, "Could not retrieve links from Wbb", new Object[0]);
        }
        this.parseResult(enclosure);
        this.addPreviouslyManuallyAddedLinks();
    }

    private void addPreviouslyManuallyAddedLinks() {
        for (WBLink l : this.manualList) {
            WBLinkGroup.setEditable(l.getSourceLemma().getID(), l.getTargetLemma().getID(), true);
        }
        this.writeList.addAll(this.manualList);
    }

    public boolean removeFromUnprocessedList(WBLink w) {
        return this.manualList.remove(w);
    }

    public void parseResult(String enclosure) {
        ErrorHandler handler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                System.err.println("[warning] " + e.getMessage());
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                System.err.println("[error] " + e.getMessage());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                System.err.println("[fatal error] " + e.getMessage() + " || " + "Column: " + e.getColumnNumber() + "; Line: " + e.getLineNumber());
            }
        };
        Document document = null;
        try {
            DocumentBuilder parser = this.factory.newDocumentBuilder();
            parser.setErrorHandler(handler);
            document = parser.parse(new InputSource(new StringReader(enclosure)));
        }
        catch (ParserConfigurationException e) {
            Activator.handleProblem(4, e, "Could not build parser for Wbb", new Object[0]);
        }
        catch (SAXException e) {
            Activator.handleProblem(4, e, "Could not parse result from Wbb", new Object[0]);
        }
        catch (IOException e) {
            Activator.handleProblem(4, e, "Could not retrieve content from Wbb", new Object[0]);
        }
        NodeList targetLinkNodeList = document.getElementsByTagName("link");
        int linkNumber = targetLinkNodeList.getLength();
        int i = 0;
        while (i < linkNumber) {
            Element link = (Element)targetLinkNodeList.item(i);
            Element lemmaNode = (Element)link.getElementsByTagName("lemma").item(0);
            WBLemma targetLemma = this.parseLemmaNode(lemmaNode);
            WBLink wblink = this.parseLink(this.sourceLemma, targetLemma, link);
            boolean isEditable = WBLinkGroup.setEditable(this.sourceLemma.getID(), targetLemma.getID(), wblink.isEditable());
            if (!isEditable) {
                Activator.handleProblem(2, null, "Conflict in links from " + this.sourceLemma.getID() + " to " + targetLemma.getID() + "(" + targetLemma.getName() + "): some are editable, some not!", new Object[0]);
                System.out.println("Conflict in links from " + this.sourceLemma.getID() + " to " + targetLemma.getID() + "(" + targetLemma.getName() + "): some are editable, some not!");
            }
            WBLinkGroup.isLastOne(this.sourceLemma.getID(), targetLemma.getID(), wblink.getTimestamp());
            this.writeList.add((Object)wblink);
            ++i;
        }
    }

    public WBLink parseLink(WBLemma source, WBLemma target, Element el) {
        String editor = "";
        Node n = el.getElementsByTagName("editor").item(0).getFirstChild();
        if (n != null) {
            editor = n.getNodeValue();
        }
        String time = "";
        n = el.getElementsByTagName("timestamp").item(0).getFirstChild();
        if (n != null) {
            time = n.getNodeValue();
        }
        String comment = "";
        n = el.getElementsByTagName("comment").item(0).getFirstChild();
        if (n != null) {
            comment = n.getNodeValue();
        }
        try {
            comment = URLDecoder.decode(comment, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        String approved = "";
        n = el.getElementsByTagName("approved").item(0).getFirstChild();
        if (n != null) {
            approved = n.getNodeValue();
        }
        String deleted = "";
        n = el.getElementsByTagName("deleted").item(0).getFirstChild();
        if (n != null) {
            deleted = n.getNodeValue();
        }
        String editable = "";
        n = el.getElementsByTagName("editable").item(0).getFirstChild();
        if (n != null) {
            editable = n.getNodeValue();
        }
        String etymRelationId = ((Element)el.getElementsByTagName("etymrelation").item(0)).getAttribute("id");
        String semanticRelationId = ((Element)el.getElementsByTagName("semanticrelation").item(0)).getAttribute("id");
        String quality = ((Element)el.getElementsByTagName("quality").item(0)).getAttribute("id");
        WBLink wbl = new WBLink(source, target, editor, time, quality, semanticRelationId, etymRelationId, comment, approved, deleted, editable);
        return wbl;
    }

    public WBLemma parseLemmaNode(Element ln) {
        String name = ln.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
        String wbname = ln.getElementsByTagName("wbname").item(0).getFirstChild().getNodeValue();
        String wbshort = ln.getElementsByTagName("wbkurz").item(0).getFirstChild().getNodeValue();
        String bg = ln.getElementsByTagName("wbkurz").item(0).getAttributes().getNamedItem("bgcolor").getTextContent();
        String fg = ln.getElementsByTagName("wbkurz").item(0).getAttributes().getNamedItem("color").getTextContent();
        NodeList hrefNode = ln.getElementsByTagName("href");
        String href = hrefNode.item(0).getFirstChild().getNodeValue();
        WBLemma l = new WBLemma(name, wbname, wbshort, bg, fg, href);
        return l;
    }

    public WBLemma getSourceLemma() {
        return this.sourceLemma;
    }

    public void setSourceLemma(WBLemma sourceLemma) {
        this.sourceLemma = sourceLemma;
        this.manualList.clear();
        this.clearLinks();
        if (sourceLemma != null) {
            this.retrieveLinks();
        }
    }

    public void clearLinks() {
        this.writeList.clear();
        this.reserveList = new ArrayList();
        WBLinkGroup.resetRegistry();
    }

    public void toggleHistory(boolean on) {
        if (on) {
            for (WBLink wbl : this.reserveList) {
                this.writeList.add((Object)wbl);
            }
            this.reserveList = new ArrayList();
        } else {
            for (Object o : this.writeList) {
                WBLink wbl = (WBLink)o;
                if (wbl.isLastInHistory()) continue;
                this.reserveList.add(wbl);
            }
            for (WBLink wbl : this.reserveList) {
                this.writeList.remove((Object)wbl);
            }
        }
    }

    public WritableList getList() {
        return this.writeList;
    }

    public WBLink addNewLink(WBLemma targetLemma) {
        WBLink newLink = new WBLink(this.sourceLemma, targetLemma);
        WBLinkGroup.setEditable(this.sourceLemma.getID(), targetLemma.getID(), true);
        WBLinkGroup.isLastOne(this.sourceLemma.getID(), targetLemma.getID(), "9999");
        this.writeList.add((Object)newLink);
        this.manualList.add(newLink);
        return newLink;
    }
}

