/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.dictionarysearch.views;

import info.textgrid.lab.dictionarylinkeditor.WBLemma;
import info.textgrid.lab.dictionarylinkeditor.views.DictionaryLinkEditor;
import info.textgrid.lab.dictionarysearch.Activator;
import info.textgrid.lab.dictionarysearch.DSDictionaryWords;
import info.textgrid.lab.dictionarysearch.DSExactLemma;
import info.textgrid.lab.dictionarysearch.DSLemma;
import info.textgrid.lab.dictionarysearch.client.Wbb_WebService_Impl;
import info.textgrid.lab.dictionarysearch.views.DictionaryBrowserView;
import info.textgrid.lab.dictionarysearch.views.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DictionarySearchView
extends ViewPart {
    private static final String TG_WOERTERBUCH_WEBSERVICE_UNI_TRIER = "http://tg-woerterbuch-webservice.uni-trier.de/Wbb_WebService/";
    private static final int READ_TIME_OUT = 8000;
    private static final String PROCESSING = Messages.DictionarySearchView_Processing;
    private UIJob job;
    public static String ID = "info.textgrid.lab.dictionarysearch.views.DictionarySearchView";
    public static String search_Lemma = "";
    public static String search_Wbblist = "all";
    public static String search_Limit = "10";
    public static String search_Offset = "0";
    public static String search_Suchart = "u";
    public static String SEARCH_LINKEDLEMMAS = "false";
    public static Boolean SEARCH_FROM_OUTSIDE = false;
    public static Boolean DEBUG_OUTPUT = false;
    private int resultsCount;
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Label labelLemma_pre;
    private Label labelLemma;
    private Label labelResult;
    private Label labelPage;
    private Button buttonPrevious;
    private Button buttonNext;
    private MyISelectionListener mySelectionListener;
    private boolean emptyResult;
    private String thisSearchLemma;
    private int pageCount = 1;
    private int pageNo = 1;
    private boolean wantLinkEditorInsteadOfDictBrowser = false;
    private List<DSLemma> rootElement;
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private boolean withWBLE = false;
    private Label labelSearchStatus;

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected String getMatchingDictionaries(String lemma) throws ParserConfigurationException, SAXException, IOException {
        String response = "";
        try {
            Wbb_WebService_Impl wbservice = new Wbb_WebService_Impl();
            response = wbservice.getWbb_WebServiceSoap().wbb_LemmaSearch4_NEW_RCP2Xml_FirstLine_Ext(lemma, search_Wbblist, search_Suchart, search_Offset, search_Limit, SEARCH_LINKEDLEMMAS);
            if (DEBUG_OUTPUT.booleanValue()) {
                this.showMessage("Antwort: \n" + response);
                System.out.print(response);
            }
        }
        catch (Exception e) {
            Activator.handleProblem(4, e, String.valueOf(Messages.DictionarySearchView_Service_Not_Available) + "/nErrorMessage: " + e.getMessage(), "");
            e.printStackTrace();
        }
        SEARCH_LINKEDLEMMAS = "false";
        if (!SEARCH_FROM_OUTSIDE.booleanValue()) {
            search_Suchart = "u";
            search_Limit = "10";
            search_Wbblist = "all";
        }
        return response;
    }

    protected List<DSDictionaryWords> response2List(final String response) throws IOException, ParserConfigurationException, SAXException {
        String responseText = response;
        ErrorHandler handler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                System.err.println("[warning] " + e.getMessage());
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                System.err.println("[error] " + e.getMessage());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                System.err.println("[fatal error] " + e.getMessage() + " || " + "Column: " + e.getColumnNumber() + "; Line: " + e.getLineNumber());
                Date dt = new Date();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                long time = System.currentTimeMillis();
                File file = new File("c:/textgrid_errors/" + time + ".txt");
                File xmlFile = new File("c:/textgrid_errors/" + time + ".xml");
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(file, true));
                    BufferedWriter bwXML = new BufferedWriter(new FileWriter(xmlFile, true));
                    bw.write("Date = " + df.format(dt));
                    bw.write("XML-Filename: " + xmlFile.getName());
                    bw.newLine();
                    bw.write("[Fatal Error] " + e.getMessage() + " || " + "Column: " + e.getColumnNumber() + "; Line: " + e.getLineNumber());
                    bw.flush();
                    bw.close();
                    bwXML.write(response);
                    bwXML.flush();
                    bwXML.close();
                }
                catch (IOException iOException) {
                    Status status = new Status(4, "info.textgrid.lab.dicitionarysearch", "IOException", (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
        };
        DocumentBuilder parser = this.factory.newDocumentBuilder();
        parser.setErrorHandler(handler);
        Document document = parser.parse(new InputSource(new StringReader(responseText)));
        NodeList woerterbuchNodeList = document.getElementsByTagName("list");
        NodeList kurzNodeList = document.getElementsByTagName("kurz");
        NodeList wurzelElement = document.getElementsByTagName("resultlist");
        Element rElement = (Element)wurzelElement.item(0);
        DSLemma sLemma = new DSLemma(rElement.getAttribute("searchlemma"));
        this.resultsCount = Integer.valueOf(rElement.getAttribute("n"));
        if (this.resultsCount > 0) {
            this.pageCount = this.resultsCount % Integer.parseInt(search_Limit) == 0 ? this.resultsCount / Integer.parseInt(search_Limit) : this.resultsCount / Integer.parseInt(search_Limit) + 1;
            this.labelPage.setText(String.valueOf(Messages.DictionarySearchView_Page) + this.pageNo + Messages.DictionarySearchView_Of + this.pageCount);
        }
        this.emptyResult = rElement.getAttribute("n").equals("0");
        ArrayList<DSDictionaryWords> dictionaries = new ArrayList<DSDictionaryWords>();
        int anzahl = woerterbuchNodeList.getLength();
        int i = 0;
        while (i < anzahl) {
            Element woerterbuch = (Element)woerterbuchNodeList.item(i);
            Element knoten = (Element)kurzNodeList.item(i);
            String lemma = woerterbuch.getParentNode().getAttributes().getNamedItem("lemma").getTextContent();
            String name = woerterbuch.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
            String kurz = woerterbuch.getElementsByTagName("kurz").item(0).getFirstChild().getNodeValue();
            String bgcolor = knoten.getAttribute("bgcolor");
            String color = knoten.getAttribute("color");
            String url = woerterbuch.getElementsByTagName("href").item(0).getFirstChild().getNodeValue();
            String zeile = "";
            zeile = woerterbuch.getElementsByTagName("zeile").item(0).getFirstChild() == null ? "" : woerterbuch.getElementsByTagName("zeile").item(0).getFirstChild().getNodeValue();
            String templinking = woerterbuch.getElementsByTagName("linking").item(0).getFirstChild().getNodeValue();
            Boolean linking = false;
            if (templinking.equals("true")) {
                linking = true;
            }
            if (name.equals("XXX")) {
                Date dt = new Date();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                File file = new File("c:/wrongentries.txt");
                BufferedWriter bw = new BufferedWriter(new FileWriter(file, true));
                bw.write("Date = " + df.format(dt) + " | ");
                bw.write("DSLemma: " + lemma + " # " + "Kurz: " + kurz + " # " + "URL: " + url);
                bw.newLine();
                bw.flush();
                bw.close();
            } else {
                DSDictionaryWords tempdict = new DSDictionaryWords(name, kurz, zeile, url, bgcolor, color, linking, new DSExactLemma(woerterbuch.getParentNode().getAttributes().item(1).getTextContent(), sLemma));
                dictionaries.add(tempdict);
            }
            ++i;
        }
        return dictionaries;
    }

    public void createPartControl(final Composite parent) {
        this.emptyResult = false;
        if (!this.checkWebService()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Service Error", (String)Messages.DictionarySearchView_Service_Not_Available);
            this.closePerspective();
        }
        GridLayout gridLayout = new GridLayout(4, false);
        parent.setLayout((Layout)gridLayout);
        this.labelLemma_pre = new Label(parent, 0);
        this.labelLemma_pre.setForeground(new Color(null, 0, 0, 0));
        this.labelLemma_pre.setText(Messages.DictionarySearchView_Searchlemma);
        this.labelLemma = new Label(parent, 64);
        this.labelLemma.setForeground(new Color(null, 0, 0, 255));
        GridData gridData = new GridData();
        gridData = new GridData(140, -1);
        this.labelLemma.setLayoutData((Object)gridData);
        this.labelLemma.setText(Messages.DictionarySearchView_Searchlemma_2);
        this.labelSearchStatus = new Label(parent, 0);
        this.labelSearchStatus.setForeground(new Color(null, 0, 0, 0));
        gridData = new GridData(80, -1);
        gridData.horizontalAlignment = 0x1000008;
        this.labelSearchStatus.setLayoutData((Object)gridData);
        this.labelSearchStatus.setText("");
        this.labelResult = new Label(parent, 0);
        this.labelResult.setForeground(new Color(null, 0, 0, 0));
        gridData = new GridData(80, -1);
        gridData.horizontalAlignment = 0x1000008;
        this.labelResult.setLayoutData((Object)gridData);
        this.labelResult.setText(String.valueOf(this.resultsCount) + Messages.DictionarySearchView_Results);
        this.viewer = new TreeViewer(parent, 66306);
        Tree tree = this.viewer.getTree();
        GridData gridData_1 = new GridData(4, 4, true, true, 4, 1);
        gridData_1.heightHint = 364;
        gridData_1.widthHint = 576;
        tree.setLayoutData((Object)gridData_1);
        Tree control = (Tree)this.viewer.getControl();
        control.setHeaderVisible(true);
        control.setBackground(new Color(null, 238, 238, 238));
        this.setDrillDownAdapter(new DrillDownAdapter(this.viewer));
        TreeColumn column1 = new TreeColumn(this.viewer.getTree(), 16384);
        this.viewer.getTree().setLinesVisible(false);
        column1.setAlignment(16384);
        column1.setText(Messages.DictionarySearchView_Column_Lemma_Dict);
        column1.setWidth(150);
        if (this.withWBLE) {
            TreeColumn column3 = new TreeColumn(this.viewer.getTree(), 0x1000000);
            column3.setAlignment(0x1000000);
            column3.setText(Messages.DictionarySearchView_Column_Link);
            column3.setWidth(35);
        }
        TreeColumn column2 = new TreeColumn(this.viewer.getTree(), 131072);
        column2.setAlignment(16384);
        column2.setText(Messages.DictionarySearchView_Column_FirstLine);
        column2.setWidth(400);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.getControl().setBackground(new Color(null, 238, 238, 238));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.mySelectionListener = new MyISelectionListener();
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this.mySelectionListener);
        this.viewer.expandAll();
        this.viewer.getTree().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TreeItem item = DictionarySearchView.this.viewer.getTree().getItem(new Point(e.x, e.y));
                if (item != null && item.getData() instanceof DSDictionaryWords) {
                    DSDictionaryWords dict = (DSDictionaryWords)item.getData();
                    DictionarySearchView.this.viewer.getTree().setCursor(new Cursor((Device)Display.getCurrent(), 21));
                    DictionarySearchView.this.viewer.getTree().setToolTipText(dict.getName());
                } else {
                    DictionarySearchView.this.viewer.getTree().setCursor(new Cursor((Device)Display.getCurrent(), 0));
                    DictionarySearchView.this.viewer.getTree().setToolTipText("");
                }
            }
        });
        this.viewer.getTree().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (DictionarySearchView.this.withWBLE) {
                    int linkColumnFrom = DictionarySearchView.this.viewer.getTree().getColumn(0).getWidth();
                    int linkColumnTo = linkColumnFrom + DictionarySearchView.this.viewer.getTree().getColumn(1).getWidth();
                    TreeItem item = DictionarySearchView.this.viewer.getTree().getItem(new Point(e.x, e.y));
                    if (e.x > linkColumnFrom && e.x < linkColumnTo && item != null && item.getData() instanceof DSDictionaryWords) {
                        DictionarySearchView.this.wantLinkEditorInsteadOfDictBrowser = true;
                        DSDictionaryWords dw = (DSDictionaryWords)item.getData();
                        WBLemma lemma = new WBLemma(dw.getAssociatedExactLemma().getName(), dw.getName(), dw.getShort(), dw.getBGColor(), dw.getColor(), dw.getHref());
                        try {
                            DictionaryLinkEditor dle = (DictionaryLinkEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.dictionarylinkeditor.views.DictionaryLinkEditor");
                            dle.setLemma(lemma);
                        }
                        catch (PartInitException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        DictionarySearchView.this.wantLinkEditorInsteadOfDictBrowser = false;
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DictionarySearchView.this.wantLinkEditorInsteadOfDictBrowser) {
                    return;
                }
                IHandlerService handlerService = (IHandlerService)DictionarySearchView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("info.textgrid.lab.dictionarysearch.showBrowser", null);
                }
                catch (CommandException e) {
                    Status status = new Status(4, "info.textgrid.lab.dicitionarysearch", "Could not execute the showbrowser command for the event " + event, (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                DictionaryBrowserView dbv = (DictionaryBrowserView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(DictionaryBrowserView.ID);
                dbv.selectionChanged((IWorkbenchPart)DictionarySearchView.this, event.getSelection());
            }
        });
        this.buttonPrevious = new Button(parent, 8);
        this.buttonPrevious.setText(Messages.DictionarySearchView_Previous);
        gridData = new GridData(0x1000000);
        gridData.widthHint = 70;
        this.buttonPrevious.setLayoutData((Object)gridData);
        this.buttonPrevious.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DictionarySearchView.this.pageNo > 1) {
                    int offset = Integer.parseInt(search_Offset);
                    int limit = Integer.parseInt(search_Limit);
                    search_Offset = "" + (offset -= limit);
                    DSLemma nextLemma = new DSLemma(search_Lemma);
                    DictionarySearchView dictionarySearchView = DictionarySearchView.this;
                    dictionarySearchView.pageNo = dictionarySearchView.pageNo - 1;
                    Cursor waitCursor = new Cursor((Device)Display.getCurrent(), 1);
                    parent.setCursor(waitCursor);
                    DictionarySearchView.this.labelSearchStatus.setForeground(new Color(null, 0, 0, 255));
                    DictionarySearchView.this.labelSearchStatus.setText(PROCESSING);
                    DictionarySearchView.this.viewer.setInput((Object)nextLemma);
                    DictionarySearchView.this.viewer.expandAll();
                    DictionarySearchView.this.setNewLabelText(search_Lemma);
                    DictionarySearchView.this.buttonPrevious.setEnabled(true);
                    if (DictionarySearchView.this.pageNo == 1) {
                        DictionarySearchView.this.buttonPrevious.setEnabled(false);
                        DictionarySearchView.this.buttonNext.setEnabled(true);
                    }
                    if (DictionarySearchView.this.pageNo < DictionarySearchView.this.pageCount) {
                        DictionarySearchView.this.buttonNext.setEnabled(true);
                    }
                    Cursor normalCursor = new Cursor((Device)Display.getCurrent(), 0);
                    parent.setCursor(normalCursor);
                    DictionarySearchView.this.labelSearchStatus.setForeground(new Color(null, 0, 0, 0));
                    DictionarySearchView.this.labelSearchStatus.setText("");
                } else {
                    DictionarySearchView.this.buttonPrevious.setEnabled(false);
                    DictionarySearchView.this.viewer.refresh();
                }
            }
        });
        this.labelPage = new Label(parent, 0);
        this.labelPage.setText(Messages.DictionarySearchView_Page_0_of_0);
        gridData = new GridData(100, -1);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        this.labelPage.setLayoutData((Object)gridData);
        this.buttonNext = new Button(parent, 8);
        this.buttonNext.setText(Messages.DictionarySearchView_Next);
        gridData = new GridData(70, -1);
        gridData.horizontalAlignment = 0x1000008;
        this.buttonNext.setLayoutData((Object)gridData);
        this.buttonNext.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DictionarySearchView.this.pageNo < DictionarySearchView.this.pageCount) {
                    int offset = Integer.parseInt(search_Offset);
                    int limit = Integer.parseInt(search_Limit);
                    search_Offset = "" + (offset += limit);
                    DSLemma nextLemma = new DSLemma(search_Lemma);
                    DictionarySearchView dictionarySearchView = DictionarySearchView.this;
                    dictionarySearchView.pageNo = dictionarySearchView.pageNo + 1;
                    Cursor waitCursor = new Cursor((Device)Display.getCurrent(), 1);
                    parent.setCursor(waitCursor);
                    DictionarySearchView.this.labelSearchStatus.setForeground(new Color(null, 0, 0, 255));
                    DictionarySearchView.this.labelSearchStatus.setText(PROCESSING);
                    DictionarySearchView.this.viewer.setInput((Object)nextLemma);
                    DictionarySearchView.this.viewer.expandAll();
                    DictionarySearchView.this.setNewLabelText(search_Lemma);
                    DictionarySearchView.this.buttonNext.setEnabled(true);
                    if (DictionarySearchView.this.pageCount - DictionarySearchView.this.pageNo == 0) {
                        DictionarySearchView.this.buttonNext.setEnabled(false);
                    }
                    if (DictionarySearchView.this.pageNo == 1) {
                        DictionarySearchView.this.buttonPrevious.setEnabled(false);
                    }
                    Cursor normalCursor = new Cursor((Device)Display.getCurrent(), 0);
                    parent.setCursor(normalCursor);
                    DictionarySearchView.this.labelSearchStatus.setForeground(new Color(null, 0, 0, 0));
                    DictionarySearchView.this.labelSearchStatus.setText("");
                } else {
                    DictionarySearchView.this.buttonNext.setEnabled(false);
                    DictionarySearchView.this.viewer.refresh();
                }
            }
        });
        if (this.emptyResult) {
            this.buttonPrevious.setEnabled(false);
            this.buttonNext.setEnabled(false);
        } else {
            this.buttonPrevious.setEnabled(false);
            this.buttonNext.setEnabled(false);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.dictionarysearch.DictionarySearchResultView");
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.DictionarySearchView_View_Name, (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof String) {
            String tempLemma = (String)o;
            this.setContentDescription(tempLemma);
            DSLemma newLemma = new DSLemma(tempLemma);
            this.viewer.setInput((Object)newLemma);
        }
    }

    public void getResults4SearchLemma(String lemma) {
        DSLemma newLemma = new DSLemma(lemma);
        this.setOffset("0");
        this.setPageNo(1);
        this.setSearchFromOutside(false);
        this.getTreeViewer().setInput((Object)newLemma);
        this.getTreeViewer().expandAll();
        this.setNewLabelText(lemma);
    }

    public void setNewLabelText(String text) {
        this.labelLemma.setText(text);
        this.labelResult.setText(String.valueOf(this.resultsCount) + Messages.DictionarySearchView_Results);
        if (this.resultsCount > 0) {
            this.pageCount = this.resultsCount % Integer.parseInt(search_Limit) == 0 ? this.resultsCount / Integer.parseInt(search_Limit) : this.resultsCount / Integer.parseInt(search_Limit) + 1;
            this.labelPage.setText(String.valueOf(Messages.DictionarySearchView_Page) + this.pageNo + Messages.DictionarySearchView_Of + this.pageCount);
        }
        if (this.resultsCount == 0) {
            this.labelPage.setText(String.valueOf(Messages.DictionarySearchView_Page) + "0" + Messages.DictionarySearchView_Of + "0");
        }
    }

    public void setSearchType(String searchType) {
        search_Suchart = searchType;
    }

    public void setSearchFromOutside(Boolean searchFromOutside) {
        SEARCH_FROM_OUTSIDE = searchFromOutside;
    }

    public void setOffset(String offset) {
        search_Offset = offset;
    }

    public void setLimit(String limit) {
        search_Limit = limit;
    }

    public void setWbbList(String wbbList) {
        search_Wbblist = wbbList;
    }

    public void setLinkedLemmas(String linkedlemmas) {
        SEARCH_LINKEDLEMMAS = linkedlemmas;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public void setDrillDownAdapter(DrillDownAdapter drillDownAdapter) {
        this.drillDownAdapter = drillDownAdapter;
    }

    public DrillDownAdapter getDrillDownAdapter() {
        return this.drillDownAdapter;
    }

    public void setThisSearchLemma(String thisSearchLemma) {
        this.thisSearchLemma = thisSearchLemma;
    }

    public String getThisSearchLemma() {
        return this.thisSearchLemma;
    }

    private void closePerspective() {
        IWorkbench wb = PlatformUI.getWorkbench();
        wb.getActiveWorkbenchWindow().getActivePage().closePerspective(wb.getPerspectiveRegistry().findPerspectiveWithId("info.textgrid.lab.woerterbuchsearchmask.perspectives.RelEngPerspective"), false, true);
    }

    public boolean checkWebService() {
        String URL2 = TG_WOERTERBUCH_WEBSERVICE_UNI_TRIER;
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(URL2).openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(8000);
            return con.getResponseCode() == 200;
        }
        catch (IOException iOException) {
            System.out.println("FEHLER!!!!!!!!!!!");
            return false;
        }
    }

    class MyISelectionListener
    implements ISelectionListener {
        MyISelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        }

        private final class ShowResultsJob
        extends UIJob {
            private final ITextSelection textSelection;
            private final IWorkbenchPart part;

            private ShowResultsJob(String name, IWorkbenchPart part, ITextSelection textSelection) {
                super(name);
                this.textSelection = textSelection;
                this.part = part;
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String word = this.extractCurrentWord(this.part, this.textSelection);
                if (word != null && word != "") {
                    if (DEBUG_OUTPUT.booleanValue()) {
                        DictionarySearchView.this.showMessage("setInput wird mit <" + word + "> aufgerufen!");
                    }
                    DSLemma newLemma = new DSLemma(word);
                    DictionarySearchView.this.setSearchFromOutside(false);
                    DictionarySearchView.this.viewer.setInput((Object)newLemma);
                    DictionarySearchView.this.viewer.expandAll();
                    if (DictionarySearchView.this.emptyResult) {
                        DictionarySearchView.this.labelLemma.setForeground(new Color(null, 255, 0, 0));
                        DictionarySearchView.this.labelLemma.setText(String.valueOf(Messages.DictionarySearchView_Search_Result_Info_1) + ((DSLemma)DictionarySearchView.this.rootElement.get(0)).getName() + Messages.DictionarySearchView_Search_Result_Info);
                        DictionarySearchView.this.labelResult.setText(String.valueOf(DictionarySearchView.this.resultsCount) + Messages.DictionarySearchView_Results);
                        DictionarySearchView.this.labelPage.setText(Messages.DictionarySearchView_Page_0_of_0);
                        DictionarySearchView.this.emptyResult = false;
                    } else {
                        DictionarySearchView.this.labelLemma.setForeground(new Color(null, 0, 0, 255));
                        DictionarySearchView.this.labelLemma.setText(word);
                        DictionarySearchView.this.labelResult.setText(String.valueOf(DictionarySearchView.this.resultsCount) + Messages.DictionarySearchView_Results);
                        DictionarySearchView.this.pageNo = 1;
                        search_Offset = "0";
                    }
                }
                return Status.OK_STATUS;
            }

            private String extractCurrentWord(IWorkbenchPart part2, ITextSelection selection) {
                MultiPageEditorPart multipage;
                Object adapter;
                if (selection.getLength() > 0) {
                    return selection.getText();
                }
                if (part2 instanceof MultiPageEditorPart && (adapter = (multipage = (MultiPageEditorPart)part2).getAdapter(ITextEditor.class)) != null) {
                    part2 = (ITextEditor)adapter;
                }
                if (part2 instanceof ITextEditor) {
                    int right;
                    ITextEditor editor = (ITextEditor)part2;
                    int left = right = selection.getOffset();
                    IDocument document = editor.getDocumentProvider().getDocument((Object)selection);
                    if (document != null) {
                        try {
                            while (right < document.getLength() && Character.isLetter(document.getChar(right))) {
                                ++right;
                            }
                            while (left >= 0 && Character.isLetter(document.getChar(left))) {
                                --left;
                            }
                            return document.get(left, right - left);
                        }
                        catch (BadLocationException e) {
                            Activator.handleProblem(4, e, "Extracting excerpt caused problem", new Object[0]);
                        }
                    }
                }
                return null;
            }
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            Status status;
            if (oldInput != null && oldInput.equals(newInput)) {
                return;
            }
            DictionarySearchView.this.viewer = (TreeViewer)v;
            if (!(newInput instanceof DSLemma)) {
                if (DEBUG_OUTPUT.booleanValue()) {
                    DictionarySearchView.this.showMessage("neuer Input KEIN lemma, sondern: " + newInput.getClass().getSimpleName());
                }
                return;
            }
            if (DEBUG_OUTPUT.booleanValue()) {
                DictionarySearchView.this.showMessage("neuer Input: " + newInput.toString() + "\n Parameter: \n" + "WBBLIST: " + search_Wbblist + "\n" + "LIMIT: " + search_Limit + "\n" + "OFFSET: " + search_Offset + "\n" + "SUCHART: " + search_Suchart + "\n" + "LINKED: " + SEARCH_LINKEDLEMMAS);
            }
            if (!SEARCH_FROM_OUTSIDE.booleanValue()) {
                search_Suchart = "u";
                search_Wbblist = "all";
            }
            class XMLHelper {
                XMLHelper() {
                }

                public String protectSpecialCharacters(String originalUnprotectedString) {
                    if (originalUnprotectedString == null) {
                        return null;
                    }
                    boolean anyCharactersProtected = false;
                    StringBuffer stringBuffer = new StringBuffer();
                    int i = 0;
                    while (i < originalUnprotectedString.length()) {
                        boolean characterWithSpecialMeaningInXML;
                        char ch = originalUnprotectedString.charAt(i);
                        boolean controlCharacter = ch < ' ';
                        boolean bl = characterWithSpecialMeaningInXML = ch == '<' || ch == '&' || ch == '>';
                        if (characterWithSpecialMeaningInXML || controlCharacter) {
                            stringBuffer.append("&#" + ch + ";");
                            anyCharactersProtected = true;
                        } else {
                            stringBuffer.append(ch);
                        }
                        ++i;
                    }
                    if (!anyCharactersProtected) {
                        return originalUnprotectedString;
                    }
                    return stringBuffer.toString();
                }
            }
            XMLHelper xhelper = new XMLHelper();
            DictionarySearchView.this.rootElement = new ArrayList();
            DSLemma searchLemma = (DSLemma)newInput;
            search_Lemma = searchLemma.getName();
            DictionarySearchView.this.setThisSearchLemma(searchLemma.getName());
            DictionarySearchView.this.rootElement.add(searchLemma);
            String responseString = new String();
            List<Object> resultList = new ArrayList();
            try {
                responseString = DictionarySearchView.this.getMatchingDictionaries(xhelper.protectSpecialCharacters(((DSLemma)DictionarySearchView.this.rootElement.get(0)).getName()));
                resultList = DictionarySearchView.this.response2List(responseString);
            }
            catch (SAXException sAXException) {
                if (DEBUG_OUTPUT.booleanValue()) {
                    DictionarySearchView.this.showMessage("FEHLER beim Parsen!\n saxE.getMessage()");
                }
            }
            catch (ParserConfigurationException e) {
                System.out.println("ParserConfigurationException!!!! " + e.getMessage());
                status = new Status(4, "info.textgrid.lab.dicitionarysearch", "ParseConfigurationException", (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            catch (IOException e) {
                System.out.println("IOException!!!! " + e.getMessage());
                System.out.println(responseString);
                status = new Status(4, "info.textgrid.lab.dicitionarysearch", "IOException", (Throwable)e);
                if (e.getMessage().equals("Connection refused: connect")) {
                    DictionarySearchView.this.showMessage(Messages.DictionarySearchView_Service_Not_Available);
                }
                Activator.getDefault().getLog().log((IStatus)status);
            }
            DSExactLemma tempLemma = null;
            int i = 0;
            while (i < resultList.size()) {
                DSDictionaryWords tempDict;
                if (tempLemma == null || tempLemma.getName() != ((DSDictionaryWords)resultList.get(i)).getAssociatedExactLemma().getName()) {
                    tempLemma = ((DSDictionaryWords)resultList.get(i)).getAssociatedExactLemma();
                    ((DSLemma)DictionarySearchView.this.rootElement.get(0)).addExactLemma(tempLemma);
                    tempDict = (DSDictionaryWords)resultList.get(i);
                    tempLemma.addDictionaryWoerter(tempDict);
                } else if (tempLemma.getName() == ((DSDictionaryWords)resultList.get(i)).getAssociatedExactLemma().getName()) {
                    tempDict = (DSDictionaryWords)resultList.get(i);
                    tempLemma.addDictionaryWoerter(tempDict);
                }
                ++i;
            }
            if (DictionarySearchView.this.emptyResult) {
                DictionarySearchView.this.buttonPrevious.setEnabled(false);
                DictionarySearchView.this.buttonNext.setEnabled(false);
            } else {
                DictionarySearchView.this.buttonPrevious.setEnabled(true);
                DictionarySearchView.this.buttonNext.setEnabled(true);
            }
            if (DictionarySearchView.this.pageNo == DictionarySearchView.this.pageCount) {
                DictionarySearchView.this.buttonNext.setEnabled(false);
            }
            if (DictionarySearchView.this.pageNo == 1) {
                DictionarySearchView.this.buttonPrevious.setEnabled(false);
            }
        }

        public void dispose() {
            if (DictionarySearchView.this.getSite().getSelectionProvider() != null) {
                DictionarySearchView.this.getSite().setSelectionProvider(null);
            }
            if (DictionarySearchView.this.mySelectionListener != null) {
                DictionarySearchView.this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)DictionarySearchView.this.mySelectionListener);
            }
            if (DictionarySearchView.this.job != null && DictionarySearchView.this.job.getState() == 4) {
                DictionarySearchView.this.job.cancel();
            }
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(DictionarySearchView.this.getViewSite())) {
                if (DictionarySearchView.this.rootElement == null) {
                    this.initialize();
                }
                return this.getChildren(DictionarySearchView.this.rootElement);
            }
            if (parent instanceof DSLemma) {
                return this.getChildren(parent);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof DSExactLemma) {
                return ((DSExactLemma)child).getAssociatedLemma();
            }
            if (child instanceof DSDictionaryWords) {
                return ((DSDictionaryWords)child).getAssociatedExactLemma();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof List) {
                return ((List)parent).toArray();
            }
            if (parent instanceof DSLemma) {
                return ((DSLemma)parent).getExactLemmas().toArray();
            }
            if (parent instanceof DSExactLemma) {
                return ((DSExactLemma)parent).getDictionaries().toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof List) {
                return ((List)parent).size() > 0;
            }
            if (parent instanceof DSLemma) {
                return ((DSLemma)parent).getExactLemmas().size() > 0;
            }
            if (parent instanceof DSExactLemma) {
                return ((DSExactLemma)parent).getDictionaries().size() > 0;
            }
            return false;
        }

        private void initialize() {
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements IFontProvider,
    IColorProvider,
    ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return null;
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof DSLemma) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }

        public Color getBackground(Object element) {
            if (element instanceof DSDictionaryWords) {
                DSDictionaryWords dict = (DSDictionaryWords)element;
                if (!dict.getBlockedBackground()) {
                    String stringColor = dict.getBGColor();
                    String substring1 = stringColor.substring(1, 3);
                    String substring2 = stringColor.substring(3, 5);
                    String substring3 = stringColor.substring(5, 7);
                    int redValue = Integer.parseInt(substring1, 16);
                    int greenValue = Integer.parseInt(substring2, 16);
                    int blueValue = Integer.parseInt(substring3, 16);
                    Color color = new Color(null, redValue, greenValue, blueValue);
                    dict.setBlockedBackground();
                    return color;
                }
                Color color = new Color(null, 238, 238, 238);
                return color;
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof DSDictionaryWords) {
                DSDictionaryWords dict = (DSDictionaryWords)element;
                if (!dict.getBlockedForeground()) {
                    String stringColor = dict.getColor();
                    String substring1 = stringColor.substring(1, 3);
                    String substring2 = stringColor.substring(3, 5);
                    String substring3 = stringColor.substring(5, 7);
                    int redValue = Integer.parseInt(substring1, 16);
                    int greenValue = Integer.parseInt(substring2, 16);
                    int blueValue = Integer.parseInt(substring3, 16);
                    Color color = new Color(null, redValue, greenValue, blueValue);
                    dict.setBlockedForeground();
                    return color;
                }
                Color color = new Color(null, 0, 0, 0);
                return color;
            }
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof DSDictionaryWords) {
                DSDictionaryWords dict = (DSDictionaryWords)element;
                if (!dict.getBlockedFont()) {
                    Font returnValue = null;
                    Font defaultFont = JFaceResources.getDefaultFont();
                    FontData[] data = defaultFont.getFontData();
                    int i = 0;
                    while (i < data.length) {
                        data[i].setStyle(1);
                        ++i;
                    }
                    returnValue = new Font((Device)Display.getDefault(), data);
                    dict.setBlockedFont();
                    return returnValue;
                }
                Font returnValue = null;
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] data = defaultFont.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(0);
                    ++i;
                }
                returnValue = new Font((Device)Display.getDefault(), data);
                dict.setBlockedFont();
                return returnValue;
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        /*
         * Unable to fully structure code
         */
        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof DSLemma) {
                        return ((DSLemma)element).getName();
                    }
                    if (element instanceof DSExactLemma) {
                        return ((DSExactLemma)element).getName();
                    }
                    if (element instanceof DSDictionaryWords) {
                        return ((DSDictionaryWords)element).getShort();
                    }
                }
                case 1: {
                    if (!DictionarySearchView.access$18(DictionarySearchView.this)) ** GOTO lbl16
                    if (element instanceof DSDictionaryWords) {
                        if (((DSDictionaryWords)element).getLinking().booleanValue()) {
                            return "@";
                        }
                        return "--";
                    }
                    ** GOTO lbl18
lbl16:
                    // 1 sources

                    if (element instanceof DSDictionaryWords) {
                        return ((DSDictionaryWords)element).getLine();
                    }
                }
lbl18:
                // 4 sources

                case 2: {
                    if (!DictionarySearchView.access$18(DictionarySearchView.this) || !(element instanceof DSDictionaryWords)) break;
                    return ((DSDictionaryWords)element).getLine();
                }
            }
            return null;
        }
    }
}

