/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.dialogs;

import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.dialogs.INewObjectPreparator;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizard;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizardPage;
import info.textgrid.lab.xmleditor.dialogs.NewXMLObjectPreparator;
import info.textgrid.lab.xmleditor.dialogs.XMLWizardsMessages;
import java.io.ByteArrayOutputStream;
import java.text.Collator;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.dialogs.NamespaceInfoErrorHelper;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonEditNamespacesDialog;
import org.eclipse.wst.xml.ui.internal.wizards.NewXMLGenerator;

public class SelectRootElementPage
extends WizardPage
implements ITextGridWizardPage,
SelectionListener {
    protected Combo combo;
    protected Button[] radioButton;
    protected PageBook pageBook;
    protected XSDOptionsPanel xsdOptionsPanel;
    protected DTDOptionsPanel dtdOptionsPanel;
    private NewXMLGenerator generator = new NewXMLGenerator();
    private NewXMLObjectPreparator preparator;
    private ITextGridWizard wizard;
    private String cmDocumentErrorMessage;

    public SelectRootElementPage() {
        super("SelectRootElementPage");
    }

    public static GridLayout createOptionsPanelLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        return gridLayout;
    }

    public void createControl(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        containerGroup.setLayout((Layout)new GridLayout());
        containerGroup.setLayoutData((Object)new GridData(768));
        this.setControl((Control)containerGroup);
        Label containerLabel = new Label(containerGroup, 0);
        containerLabel.setText(org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._UI_LABEL_ROOT_ELEMENT);
        this.combo = new Combo(containerGroup, 12);
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.addSelectionListener((SelectionListener)this);
        Group group = new Group(containerGroup, 0);
        group.setText(org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._UI_WIZARD_CONTENT_OPTIONS);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.radioButton = new Button[4];
        this.radioButton[0] = new Button((Composite)group, 32);
        this.radioButton[0].setText(org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._UI_WIZARD_CREATE_OPTIONAL_ATTRIBUTES);
        this.radioButton[0].setLayoutData((Object)new GridData(768));
        this.radioButton[0].setSelection(false);
        this.radioButton[1] = new Button((Composite)group, 32);
        this.radioButton[1].setText(org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._UI_WIZARD_CREATE_OPTIONAL_ELEMENTS);
        this.radioButton[1].setLayoutData((Object)new GridData(768));
        this.radioButton[1].setSelection(false);
        this.radioButton[2] = new Button((Composite)group, 32);
        this.radioButton[2].setText(org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._UI_WIZARD_CREATE_FIRST_CHOICE);
        this.radioButton[2].setLayoutData((Object)new GridData(768));
        this.radioButton[2].setSelection(false);
        this.radioButton[3] = new Button((Composite)group, 32);
        this.radioButton[3].setText(org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._UI_WIZARD_FILL_ELEMENTS_AND_ATTRIBUTES);
        this.radioButton[3].setLayoutData((Object)new GridData(768));
        this.radioButton[3].setSelection(true);
        this.pageBook = new PageBook(containerGroup, 0);
        this.pageBook.setLayoutData((Object)new GridData(1808));
        this.xsdOptionsPanel = new XSDOptionsPanel(this, (Composite)this.pageBook);
        this.dtdOptionsPanel = new DTDOptionsPanel(this, (Composite)this.pageBook);
        this.pageBook.showPage((Control)this.xsdOptionsPanel);
    }

    public void widgetSelected(SelectionEvent event) {
        int index = this.combo.getSelectionIndex();
        String rootElementName = index != -1 ? this.combo.getItem(index) : null;
        this.generator.setRootElementName(rootElementName);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.preparator.getGrammarURI() == null) {
                this.generator.setGrammarURI(null);
                this.generator.setCMDocument(null);
                this.generator.setXMLCatalogEntry(null);
                this.combo.setItems(new String[0]);
                this.pageBook.setEnabled(false);
                this.setMessage(XMLWizardsMessages.SelectRootElementPage_NoSchemaSelected, 1);
            } else {
                this.pageBook.setEnabled(true);
                this.setMessage(null);
            }
            try {
                if (this.generator.getGrammarURI() == null || !this.generator.getGrammarURI().equals(this.preparator.getGrammarURI())) {
                    this.generator.setGrammarURI(this.preparator.getGrammarURI());
                    this.generator.setXMLCatalogEntry(this.preparator.getXMLCatalogEntry());
                    this.generator.setCMDocument(null);
                }
                if (this.generator.getGrammarURI() == null) {
                    return;
                }
                if (this.generator.getCMDocument() == null) {
                    final String[] errorInfo = new String[2];
                    final CMDocument[] cmdocs = new CMDocument[1];
                    IRunnableWithProgress r = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            SubMonitor.convert((IProgressMonitor)monitor, (String)XMLWizardsMessages.SelectRootElementPage_LoadingSchema, (int)-1);
                            cmdocs[0] = NewXMLGenerator.createCMDocument((String)SelectRootElementPage.this.generator.getGrammarURI(), (String[])errorInfo);
                        }
                    };
                    this.getContainer().run(true, false, r);
                    this.generator.setCMDocument(cmdocs[0]);
                    this.cmDocumentErrorMessage = errorInfo[1];
                }
                if (this.generator.getCMDocument() != null && this.cmDocumentErrorMessage == null) {
                    String defaultRootName;
                    CMNamedNodeMap nameNodeMap = this.generator.getCMDocument().getElements();
                    Vector<String> nameNodeVector = new Vector<String>();
                    int i = 0;
                    while (i < nameNodeMap.getLength()) {
                        CMElementDeclaration cmElementDeclaration = (CMElementDeclaration)nameNodeMap.item(i);
                        Object value = cmElementDeclaration.getProperty("Abstract");
                        if (value != Boolean.TRUE) {
                            nameNodeVector.add(cmElementDeclaration.getElementName());
                        }
                        ++i;
                    }
                    Object[] nameNodeArray = nameNodeVector.toArray();
                    if (nameNodeArray.length > 0) {
                        Arrays.sort(nameNodeArray, Collator.getInstance());
                    }
                    if ((defaultRootName = (String)this.generator.getCMDocument().getProperty("http://org.eclipse.wst/cm/properties/defaultRootName")) == null) {
                        defaultRootName = "TEI";
                    }
                    int defaultRootIndex = -1;
                    this.combo.removeAll();
                    int i2 = 0;
                    while (i2 < nameNodeArray.length) {
                        String elementName = (String)nameNodeArray[i2];
                        this.combo.add(elementName);
                        if (defaultRootName != null && defaultRootName.equals(elementName)) {
                            defaultRootIndex = i2;
                        }
                        ++i2;
                    }
                    if (nameNodeArray.length > 0) {
                        defaultRootIndex = defaultRootIndex != -1 ? defaultRootIndex : 0;
                        this.combo.select(defaultRootIndex);
                        this.generator.setRootElementName(this.combo.getItem(defaultRootIndex));
                    }
                }
                if (this.generator.getGrammarURI().endsWith("xsd") || this.preparator.getGrammarObject() != null && this.preparator.getGrammarObject().getContentType(false).getId().equals("text/xsd+xml")) {
                    this.pageBook.showPage((Control)this.xsdOptionsPanel);
                    this.generator.setDefaultSystemId(this.getDefaultSystemId());
                    this.generator.createNamespaceInfoList();
                    boolean usedDefaultNamespaceYet = false;
                    int i = 0;
                    while (i < this.generator.namespaceInfoList.size()) {
                        NamespaceInfo nsinfo = (NamespaceInfo)this.generator.namespaceInfoList.get(i);
                        if ((nsinfo.prefix == null || nsinfo.prefix.trim().length() == 0) && nsinfo.uri != null && nsinfo.uri.trim().length() != 0) {
                            nsinfo.prefix = this.getDefaultPrefix(this.generator.namespaceInfoList);
                        }
                        if ("http://www.w3.org/XML/1998/namespace".equals(nsinfo.uri)) {
                            nsinfo.prefix = "xml";
                        }
                        if (!nsinfo.isPrefixRequired && !usedDefaultNamespaceYet) {
                            nsinfo.prefix = null;
                            usedDefaultNamespaceYet = true;
                        }
                        ++i;
                    }
                    this.xsdOptionsPanel.setNamespaceInfoList(this.generator.namespaceInfoList);
                } else if (this.generator.getGrammarURI().endsWith("dtd")) {
                    this.pageBook.showPage((Control)this.dtdOptionsPanel);
                    this.dtdOptionsPanel.update();
                }
            }
            catch (Exception e) {
                IStatus status = Activator.handleError((Throwable)e, (String)XMLWizardsMessages.SelectRootElementPage_ErrorBuildingGrammar, (Object[])new Object[]{e.getClass().getSimpleName(), this.generator.getGrammarURI(), e.getMessage()});
                this.cmDocumentErrorMessage = status.getMessage();
            }
            this.updateErrorMessage();
        }
    }

    private String getDefaultSystemId() {
        return null;
    }

    private String getDefaultPrefix(List<?> nsInfoList) {
        String defaultPrefix = "p";
        if (nsInfoList == null) {
            return defaultPrefix;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < nsInfoList.size()) {
            NamespaceInfo nsinfo = (NamespaceInfo)nsInfoList.get(i);
            if (nsinfo.prefix != null) {
                v.addElement(nsinfo.prefix);
            }
            ++i;
        }
        if (v.contains(defaultPrefix)) {
            String s = defaultPrefix;
            int j = 0;
            while (v.contains(s)) {
                s = String.valueOf(defaultPrefix) + Integer.toString(j);
                ++j;
            }
            return s;
        }
        return defaultPrefix;
    }

    public boolean isPageComplete() {
        boolean complete;
        if (this.preparator.getGrammarURI() == null) {
            return true;
        }
        boolean bl = complete = this.generator.getRootElementName() != null && this.generator.getRootElementName().length() > 0 && this.getErrorMessage() == null;
        if (complete) {
            int buildPolicy = 0;
            if (this.radioButton[0].getSelection()) {
                buildPolicy |= 1;
            }
            if (this.radioButton[1].getSelection()) {
                buildPolicy |= 2;
            }
            if (this.radioButton[2].getSelection()) {
                buildPolicy = buildPolicy | 4 | 0x10;
            }
            if (this.radioButton[3].getSelection()) {
                buildPolicy |= 8;
            }
            this.generator.setBuildPolicy(buildPolicy);
        }
        return complete;
    }

    public String computeErrorMessage() {
        String errorMessage = null;
        if (this.cmDocumentErrorMessage != null) {
            errorMessage = String.valueOf(this.cmDocumentErrorMessage) + XMLWizardsMessages.SelectRootElementPage_SelectDifferentSchema;
        } else if (this.preparator.getGrammarURI() != null && (this.generator.getRootElementName() == null || this.generator.getRootElementName().length() == 0)) {
            errorMessage = org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._ERROR_ROOT_ELEMENT_MUST_BE_SPECIFIED;
        }
        return errorMessage;
    }

    public void updateErrorMessage() {
        String errorMessage = this.computeErrorMessage();
        if (errorMessage == null) {
            if (this.xsdOptionsPanel.isVisible()) {
                errorMessage = this.xsdOptionsPanel.computeErrorMessage();
            } else if (this.dtdOptionsPanel.isVisible()) {
                errorMessage = this.dtdOptionsPanel.computeErrorMessage();
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(this.isPageComplete());
    }

    public void finishPage() {
        Assert.isTrue((boolean)this.isPageComplete(), (String)"Page not complete!?");
        TextGridObject object = this.wizard.getTextGridObject();
        IFile file = (IFile)AdapterUtils.getAdapter((Object)object, IFile.class);
        TextGridObject grammarObject = this.preparator.getGrammarObject();
        if (grammarObject != null) {
            object.setSchema(grammarObject.getURI());
        }
        try {
            if (this.preparator.getGrammarURI() != null) {
                ByteArrayOutputStream documentStream = this.generator.createXMLDocument(file.getName(), "UTF-8");
                object.setInitialContent(documentStream.toByteArray());
            } else {
                object.setInitialContent("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            IStatus status = Activator.handleError((Throwable)e, (String)XMLWizardsMessages.SelectRootElementPage_ErrorSerializingSkeleton, (Object[])new Object[]{e.getClass().getSimpleName(), object, file, e.getLocalizedMessage()});
            this.setErrorMessage(status.getMessage());
        }
    }

    public void init(ITextGridWizard wizard, INewObjectPreparator preparator) {
        this.wizard = wizard;
        if (preparator instanceof NewXMLObjectPreparator) {
            this.preparator = (NewXMLObjectPreparator)preparator;
        } else {
            Activator.handleError(null, (String)"SelectRootElementPage without a NewXMLObjectPreparator!?", (Object[])new Object[0]);
        }
    }

    public void loadObject(TextGridObject textGridObject) {
    }

    public class DTDOptionsPanel
    extends Composite
    implements ModifyListener {
        protected Group group;
        protected Text systemIdField;
        protected Text publicIdField;
        protected SelectRootElementPage parentPage;

        public DTDOptionsPanel(SelectRootElementPage parentPage, Composite parent) {
            super(parent, 0);
            this.parentPage = parentPage;
            this.setLayoutData(new GridData(768));
            this.setLayout((Layout)SelectRootElementPage.createOptionsPanelLayout());
            Group group = new Group((Composite)this, 0);
            group.setText(org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._UI_LABEL_DOCTYPE_INFORMATION);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            Label publicIdLabel = new Label((Composite)group, 0);
            publicIdLabel.setText(org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._UI_LABEL_PUBLIC_ID);
            this.publicIdField = new Text((Composite)group, 2052);
            this.publicIdField.setLayoutData((Object)new GridData(768));
            this.publicIdField.addModifyListener((ModifyListener)this);
            Label systemIdLabel = new Label((Composite)group, 0);
            systemIdLabel.setText(org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._UI_LABEL_SYSTEM_ID);
            this.systemIdField = new Text((Composite)group, 2052);
            this.systemIdField.setLayoutData((Object)new GridData(768));
            this.systemIdField.addModifyListener((ModifyListener)this);
        }

        public void update() {
            String thePublicId = null;
            String theSystemId = null;
            ICatalogEntry xmlCatalogEntry = SelectRootElementPage.this.generator.getXMLCatalogEntry();
            if (xmlCatalogEntry != null) {
                if (xmlCatalogEntry.getEntryType() == 2) {
                    thePublicId = xmlCatalogEntry.getKey();
                    theSystemId = xmlCatalogEntry.getAttributeValue("webURL");
                    if (theSystemId == null) {
                        theSystemId = SelectRootElementPage.this.generator.getGrammarURI().startsWith("http:") ? SelectRootElementPage.this.generator.getGrammarURI() : URIHelper.getLastSegment((String)SelectRootElementPage.this.generator.getGrammarURI());
                    }
                } else {
                    theSystemId = xmlCatalogEntry.getKey();
                }
            } else {
                theSystemId = this.getDefaultSystemId();
            }
            this.publicIdField.setText(thePublicId != null ? thePublicId : "");
            this.systemIdField.setText(theSystemId != null ? theSystemId : "");
        }

        private String getDefaultSystemId() {
            return "";
        }

        public void modifyText(ModifyEvent e) {
            SelectRootElementPage.this.generator.setSystemId(this.systemIdField.getText());
            SelectRootElementPage.this.generator.setPublicId(this.publicIdField.getText());
            this.parentPage.updateErrorMessage();
        }

        public String computeErrorMessage() {
            return null;
        }
    }

    class XSDOptionsPanel
    extends Composite {
        protected String errorMessage;
        protected SelectRootElementPage parentPage;
        protected CommonEditNamespacesDialog editNamespaces;

        public XSDOptionsPanel(SelectRootElementPage parentPage, Composite parent) {
            IFile file;
            super(parent, 0);
            this.errorMessage = null;
            this.parentPage = parentPage;
            this.setLayout((Layout)SelectRootElementPage.createOptionsPanelLayout());
            this.setLayoutData(new GridData(1808));
            Composite co = new Composite((Composite)this, 0);
            co.setLayout((Layout)new GridLayout());
            TextGridObject object = SelectRootElementPage.this.wizard.getTextGridObject();
            if (object != null && (file = (IFile)object.getAdapter(IFile.class)) != null) {
                IPath resolvedPath = file.getFullPath();
                String tableTitle = org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages._UI_LABEL_NAMESPACE_INFORMATION;
                this.editNamespaces = new CommonEditNamespacesDialog(co, resolvedPath, tableTitle, true, true);
            }
        }

        public void setNamespaceInfoList(List<NamespaceInfo> list) {
            this.editNamespaces.setNamespaceInfoList(this.fixNamespaceInfoList(list));
            this.editNamespaces.updateErrorMessage(list);
        }

        private List<NamespaceInfo> fixNamespaceInfoList(List<NamespaceInfo> list) {
            for (NamespaceInfo info : list) {
                if (info == null || info.uri == null || !info.uri.equals(info.locationHint)) continue;
                info.locationHint = null;
            }
            return list;
        }

        public void updateErrorMessage(List<?> namespaceInfoList) {
            NamespaceInfoErrorHelper helper = new NamespaceInfoErrorHelper();
            this.errorMessage = helper.computeErrorMessage(namespaceInfoList, null);
            this.parentPage.updateErrorMessage();
        }

        public String computeErrorMessage() {
            return this.errorMessage;
        }
    }
}

