/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.projectadmin.views;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.UserRole2;
import info.textgrid.lab.projectadmin.views.Messages;
import info.textgrid.lab.projectadmin.views.UserManagement2;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class RoleEditingSupport
extends EditingSupport {
    private CellEditor editor = new CheckboxCellEditor(null, 32);
    private String role;

    public RoleEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        this.role = UserManagement2.currentProject.getAvailableRoles()[column];
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        return UserManagement2.canEdit(element, this.role);
    }

    public Object getValue(Object element) {
        return UserManagement2.getCheckStateValue(element, this.role).isChecked();
    }

    protected void setValue(Object element, Object value) {
        Boolean futureStillLeader;
        UserRole2 user;
        UserManagement2.toggleCheckState(element, this.role);
        this.getViewer().update(element, null);
        if (element instanceof UserRole2 && (user = (UserRole2)element).getePPN().equals(RBACSession.getInstance().getEPPN()) && this.role.equals("Projektleiter") && !(futureStillLeader = (Boolean)value).booleanValue()) {
            MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 40);
            mb.setText(MessageFormat.format(Messages.RoleEditingSupport_DeleteLeaderMessageTitle, TextGridProject.findLabelForRBACRole((String)"Projektleiter")));
            mb.setMessage(MessageFormat.format(Messages.RoleEditingSupport_DeleteLeaderMessage, TextGridProject.findLabelForRBACRole((String)"Projektleiter")));
            mb.open();
        }
    }
}

