/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.projectadmin.views;

import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.UserRole2;
import info.textgrid.lab.projectadmin.Activator;
import info.textgrid.lab.projectadmin.views.AlphabeticalUserRecordsViewerSorter;
import info.textgrid.lab.projectadmin.views.CheckState;
import info.textgrid.lab.projectadmin.views.InProjectState;
import info.textgrid.lab.projectadmin.views.Messages;
import info.textgrid.lab.projectadmin.views.RoleEditingSupport;
import info.textgrid.lab.projectadmin.views.RoleModification;
import info.textgrid.namespaces.middleware.tgauth.Friend;
import info.textgrid.namespaces.middleware.tgauth.GetIDsRequest;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import info.textgrid.namespaces.middleware.tgauth.UserDetail;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class UserManagement2
extends ViewPart {
    public static final String ID = "info.textgrid.lab.projectadmin.views.UserManagement";
    static final int IsInProjectColumnNumber = 0;
    static final String IsInProjectColumnText = "";
    static final int UserNameColumnNumber = 1;
    static final String UserNameColumnText = Messages.UserManagement2_Username;
    static final int UserIDColumnNumber = 2;
    static final String UserIDColumnText = Messages.UserManagement2_UserID;
    static final int FirstRoleColumnNumber = 3;
    public static TextGridProject currentProject;
    private final ISelectionListener projectSelectedListener;
    private Composite mainComposite;
    private Text viewHeading;
    private Button wantFriends;
    private Button wantSearchResults;
    private Text searchText;
    private boolean showFriends;
    private boolean showSearchResults;
    private Job currentJob = null;
    private Job searchJob = null;
    private Job applyJob = null;
    private ArrayList<Object> userRecords = new ArrayList();
    public ArrayList<Friend> friends = null;
    public ArrayList<UserDetail> searchResults = new ArrayList();
    private ArrayList<TableViewerColumn> roleColumns = new ArrayList();
    private static HashMap<String, RoleModification> roleMods;
    private boolean rolesHaveChanged = false;
    TableViewer viewer;

    static {
        roleMods = new HashMap();
    }

    public UserManagement2() {
        this.projectSelectedListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
                if (sourcepart != UserManagement2.this && selection instanceof IStructuredSelection) {
                    IStructuredSelection iss = (IStructuredSelection)selection;
                    if (!iss.isEmpty()) {
                        Object firstelem = iss.toArray()[0];
                        if (firstelem instanceof TextGridProject && UserManagement2.this.isVisible()) {
                            currentProject = (TextGridProject)firstelem;
                            UserManagement2.this.reloadFromRBAC(currentProject);
                        } else {
                            UserManagement2.this.reloadFromRBAC(null);
                        }
                    } else {
                        UserManagement2.this.reloadFromRBAC(null);
                    }
                }
            }
        };
    }

    public boolean isVisible() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().isPartVisible((IWorkbenchPart)this);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void createPartControl(Composite parent) {
        this.mainComposite = new Composite(parent, 4);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gdc = new GridData(4, 4, true, true);
        this.mainComposite.setLayoutData((Object)gdc);
        this.viewHeading = new Text(this.mainComposite, 9);
        GridData gd3b = new GridData(16384, 0x1000000, true, false);
        gd3b.widthHint = 2000;
        this.viewHeading.setLayoutData((Object)gd3b);
        this.viewHeading.setText(Messages.UserManagement2_PleaseSelectProject);
        this.viewHeading.setBackground(this.mainComposite.getBackground());
        this.viewer = new TableViewer(this.mainComposite, 268503810);
        GridData gd3v = new GridData(16384, 0x1000000, true, false);
        gd3v.widthHint = 2000;
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        TableViewerColumn tcChecked = new TableViewerColumn(this.viewer, 0);
        tcChecked.getColumn().setAlignment(16384);
        tcChecked.getColumn().setText(IsInProjectColumnText);
        tcChecked.getColumn().setToolTipText(Messages.UserManagement2_CheckedToolTip);
        tcChecked.getColumn().setWidth(20);
        tcChecked.setLabelProvider((CellLabelProvider)new IsInProjectLabelProvider());
        TableViewerColumn tcName = new TableViewerColumn(this.viewer, 0);
        tcName.getColumn().setAlignment(16384);
        tcName.getColumn().setText(UserNameColumnText);
        tcName.getColumn().setToolTipText(Messages.UserManagement2_NameToolTip);
        tcName.getColumn().setWidth(150);
        tcName.setLabelProvider((CellLabelProvider)new UserNameLabelProvider());
        TableViewerColumn tcID = new TableViewerColumn(this.viewer, 0);
        tcID.getColumn().setAlignment(16384);
        tcID.getColumn().setText(UserIDColumnText);
        tcID.getColumn().setToolTipText(Messages.UserManagement2_ID_ToolTip);
        tcID.getColumn().setWidth(150);
        tcID.setLabelProvider((CellLabelProvider)new EPPNLabelProvider());
        GridData vGD = new GridData();
        vGD.horizontalAlignment = 4;
        vGD.grabExcessVerticalSpace = true;
        vGD.grabExcessHorizontalSpace = true;
        vGD.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)vGD);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new AlphabeticalUserRecordsViewerSorter());
        this.getSite().getPage().addSelectionListener(this.projectSelectedListener);
        Composite bottom2 = new Composite(this.mainComposite, 4);
        bottom2.setLayout((Layout)new GridLayout(2, false));
        GridData gd2 = new GridData(4, 2, true, false);
        bottom2.setLayoutData((Object)gd2);
        this.searchText = new Text(bottom2, 18820);
        this.searchText.setText(IsInProjectColumnText);
        GridData gd6 = new GridData(4, 2, true, false);
        gd6.widthHint = 2000;
        this.searchText.setLayoutData((Object)gd6);
        this.searchText.setToolTipText(Messages.UserManagement2_searchBoxToolTip);
        this.searchText.setMessage(Messages.UserManagement2_searchBoxMessage);
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r') {
                    UserManagement2.this.startSearch();
                }
            }
        });
        Button searchButton = new Button(bottom2, 8);
        searchButton.setText(Messages.UserManagement2_searchButtonText);
        searchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserManagement2.this.startSearch();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite bottom = new Composite(this.mainComposite, 4);
        bottom.setLayout((Layout)new GridLayout(5, false));
        GridData gd1 = new GridData(4, 2, true, false);
        bottom.setLayoutData((Object)gd1);
        this.wantFriends = new Button(bottom, 32);
        this.wantFriends.setText(Messages.UserManagement2_ShowContactsButtonText);
        this.wantFriends.setImage(InProjectState.CONTACT.icon());
        this.wantFriends.setToolTipText(Messages.UserManagement2_ShowContactsToolTip);
        this.wantFriends.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (UserManagement2.this.wantFriends.getSelection()) {
                    UserManagement2.this.showFriends = true;
                    UserManagement2.this.addFriendsToViewer(true);
                } else {
                    UserManagement2.this.showFriends = false;
                    UserManagement2.this.hideFriendsFromViewer(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.wantSearchResults = new Button(bottom, 32);
        GridData gd3a = new GridData(16384, 0x1000000, true, false);
        gd3a.widthHint = 2000;
        this.wantSearchResults.setLayoutData((Object)gd3a);
        this.wantSearchResults.setText(Messages.UserManagement2_ShowSearchResultsButton);
        this.wantSearchResults.setImage(InProjectState.SEARCHED.icon());
        this.wantSearchResults.setToolTipText(Messages.UserManagement2_ShowSearchResultsToolTip);
        this.wantSearchResults.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (UserManagement2.this.wantSearchResults.getSelection()) {
                    UserManagement2.this.showSearchResults = true;
                    UserManagement2.this.addSearchResultsToViewer(true);
                } else {
                    UserManagement2.this.showSearchResults = false;
                    UserManagement2.this.hideSearchResultsFromViewer(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Link helplink = new Link(bottom, 0);
        helplink.setText(Messages.UserManagement2_HelpLink);
        helplink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.projectadmin.views.RoleHelp");
                }
                catch (PartInitException e1) {
                    Status status = new Status(4, "info.textgrid.lab.projectadmin", "Could not open Role Help!", (Throwable)e1);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
        });
        Button revertButton = new Button(bottom, 8);
        revertButton.setText(Messages.UserManagement2_RevertButtonText);
        revertButton.setToolTipText(Messages.UserManagement2_RevertButtonToolTip);
        revertButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                roleMods.clear();
                UserManagement2.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button applyButton = new Button(bottom, 8);
        applyButton.setText(Messages.UserManagement2_ApplyButtonText);
        applyButton.setToolTipText(Messages.UserManagement2_ApplyButtonToolTip);
        applyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean allowed = UserManagement2.this.checkThatOneManagerRemains();
                if (!allowed) {
                    MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
                    mb.setText(MessageFormat.format(Messages.UserManagement2_CannotDeleteLastLeaderMessageHeading, TextGridProject.findLabelForRBACRole((String)"Projektleiter")));
                    mb.setMessage(MessageFormat.format(Messages.UserManagement2_CannotDeleteLastLeaderMessageDescription, TextGridProject.findLabelForRBACRole((String)"Projektleiter")));
                    mb.open();
                    return;
                }
                UserManagement2.this.writeModsToRBAC();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.projectadmin.UserManagementView");
    }

    private boolean checkThatOneManagerRemains() {
        int currentManagers = 0;
        for (Object o : this.userRecords) {
            UserRole2 projectmember;
            if (!(o instanceof UserRole2) || !(projectmember = (UserRole2)o).getRoles().contains("Projektleiter")) continue;
            ++currentManagers;
        }
        int managersForDeletion = 0;
        for (String ePPN : roleMods.keySet()) {
            for (String delRole : UserManagement2.roleMods.get((Object)ePPN).toBeRemoved) {
                if (!delRole.equals("Projektleiter")) continue;
                ++managersForDeletion;
            }
        }
        return currentManagers > managersForDeletion;
    }

    private void writeModsToRBAC() {
        if (this.applyJob != null) {
            this.applyJob.cancel();
        }
        final int expectedMods = this.countMods();
        this.applyJob = new Job(Messages.UserManagement2_ApplyJobStatus){

            /*
             * Unable to fully structure code
             */
            protected IStatus run(IProgressMonitor monitor) {
                block13: {
                    monitor.beginTask(Messages.UserManagement2_ApplyJobStatusShort, expectedMods + 1);
                    UserManagement2.access$13(UserManagement2.this, true);
                    try {
                        for (String ePPN : UserManagement2.access$10().keySet()) {
                            it = ((RoleModification)UserManagement2.access$10().get((Object)ePPN)).toBeRemoved.iterator();
                            while (it.hasNext()) {
                                delRole = it.next();
                                UserManagement2.currentProject.deleteRole(ePPN, delRole);
                                it.remove();
                                monitor.worked(1);
                                if (!monitor.isCanceled()) continue;
                                return Status.CANCEL_STATUS;
                            }
                        }
                        for (String ePPN : UserManagement2.access$10().keySet()) {
                            for (String addRole : ((RoleModification)UserManagement2.access$10().get((Object)ePPN)).toBeAdded) {
                                UserManagement2.currentProject.addRoleMember(ePPN, addRole);
                                monitor.worked(1);
                                if (!monitor.isCanceled()) continue;
                                return Status.CANCEL_STATUS;
                            }
                        }
                        for (String ePPN : UserManagement2.access$10().keySet()) {
                            it = ((RoleModification)UserManagement2.access$10().get((Object)ePPN)).toBeAdded.iterator();
                            while (it.hasNext()) {
                                activateRole = it.next();
                                UserManagement2.currentProject.activateRoleInSession(ePPN, activateRole);
                                it.remove();
                                monitor.worked(1);
                                if (!monitor.isCanceled()) continue;
                                return Status.CANCEL_STATUS;
                            }
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        status = new Status(1, "info.textgrid.lab.projectadmin", "Could not add/delete roles!", (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                        info = new Status(1, "info.textgrid.lab.projectadmin", "The following roles may not have been added/removed successfully in all sessions of the user, please check in the list.");
                        Activator.getDefault().getLog().log((IStatus)info);
                        ** for (ePPN : UserManagement2.access$10().keySet())
                    }
lbl-1000:
                    // 2 sources

                    {
                        for (String addRole : ((RoleModification)UserManagement2.access$10().get((Object)ePPN)).toBeAdded) {
                            info = new Status(1, "info.textgrid.lab.projectadmin", "Could not add " + addRole + " to " + ePPN);
                            Activator.getDefault().getLog().log((IStatus)info);
                        }
                        for (String delRole : ((RoleModification)UserManagement2.access$10().get((Object)ePPN)).toBeRemoved) {
                            info = new Status(1, "info.textgrid.lab.projectadmin", "Could not remove " + delRole + " from " + ePPN);
                            Activator.getDefault().getLog().log((IStatus)info);
                        }
                        continue;
                    }
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                UserManagement2.this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String me = RBACSession.getInstance().getEPPN().toLowerCase();
                        if (roleMods.containsKey(me) && (((RoleModification)roleMods.get((Object)me)).toBeAdded.size() > 0 || ((RoleModification)roleMods.get((Object)me)).toBeRemoved.size() > 0)) {
                            AuthBrowser.sessionChanged();
                        }
                        UserManagement2.this.reloadFromRBAC(currentProject);
                    }
                });
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.applyJob.setPriority(30);
        this.applyJob.schedule();
    }

    public void searchForUsers(final String querystring) {
        if (this.searchJob != null) {
            this.searchJob.cancel();
        }
        this.searchJob = new Job(Messages.UserManagement2_SearchJobStatus){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.UserManagement2_SearchJobStatus, 5);
                try {
                    boolean found;
                    PortTgextra stub = TextGridProject.ensureStubIsLoaded();
                    GetIDsRequest gidr = new GetIDsRequest();
                    gidr.setAuth(RBACSession.getInstance().getSID(false));
                    gidr.setMail(UserManagement2.IsInProjectColumnText);
                    gidr.setName(querystring);
                    gidr.setOrganisation(UserManagement2.IsInProjectColumnText);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ArrayList udNames = stub.getIDs(gidr).getUserdetails();
                    if (udNames == null) {
                        udNames = new ArrayList();
                    }
                    monitor.worked(1);
                    gidr.setMail(querystring);
                    gidr.setName(UserManagement2.IsInProjectColumnText);
                    gidr.setOrganisation(UserManagement2.IsInProjectColumnText);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ArrayList udMails = stub.getIDs(gidr).getUserdetails();
                    if (udMails == null) {
                        udMails = new ArrayList();
                    }
                    monitor.worked(1);
                    gidr.setMail(UserManagement2.IsInProjectColumnText);
                    gidr.setName(UserManagement2.IsInProjectColumnText);
                    gidr.setOrganisation(querystring);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ArrayList udOrgs = stub.getIDs(gidr).getUserdetails();
                    if (udOrgs == null) {
                        udOrgs = new ArrayList();
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ArrayList<UserDetail> tmpSearchResult = new ArrayList<UserDetail>(udNames.size());
                    for (UserDetail name : udNames) {
                        tmpSearchResult.add(name);
                    }
                    for (UserDetail mail : udMails) {
                        found = false;
                        for (UserDetail tmp : tmpSearchResult) {
                            if (!mail.getEPPN().equals(tmp.getEPPN())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        tmpSearchResult.add(mail);
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    for (UserDetail org : udOrgs) {
                        found = false;
                        for (UserDetail tmp : tmpSearchResult) {
                            if (!org.getEPPN().equals(tmp.getEPPN())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        tmpSearchResult.add(org);
                    }
                    monitor.worked(1);
                    UserManagement2.this.searchResults = tmpSearchResult;
                }
                catch (Exception e) {
                    Status status = new Status(4, "info.textgrid.lab.projectadmin", "Could not execute search job successfully!", (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                if (monitor.isCanceled() || UserManagement2.this.viewer.getTable().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                UserManagement2.this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UserManagement2.this.addSearchResultsToViewer(true);
                    }
                });
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.searchJob.setPriority(30);
        this.searchJob.schedule();
    }

    private void addRoleColumns(TableViewer viewer) {
        String[] roles = currentProject.getAvailableRoles();
        int i = 0;
        while (i < roles.length) {
            String role = roles[i];
            TableViewerColumn tcR = new TableViewerColumn(viewer, 0);
            tcR.getColumn().setAlignment(16384);
            tcR.getColumn().setText(TextGridProject.findLabelForRBACRole((String)role));
            tcR.getColumn().setToolTipText(MessageFormat.format(Messages.UserManagement2_CheckToGiveRoleToolTip, TextGridProject.findLabelForRBACRole((String)role)));
            tcR.setEditingSupport((EditingSupport)new RoleEditingSupport((ColumnViewer)viewer, i));
            tcR.setLabelProvider((CellLabelProvider)new RoleCheckLabelProvider(role));
            tcR.getColumn().pack();
            this.roleColumns.add(tcR);
            ++i;
        }
    }

    private int countMods() {
        int count = 0;
        for (String ePPN : roleMods.keySet()) {
            count += UserManagement2.roleMods.get((Object)ePPN).toBeAdded.size() * 2 + UserManagement2.roleMods.get((Object)ePPN).toBeRemoved.size();
        }
        return count;
    }

    private void addFriendsToViewer(boolean refresh) {
        if (this.friends == null) {
            this.friends = RBACSession.getInstance().getFriends(true);
        }
        ArrayList<Friend> remainingFriends = new ArrayList<Friend>();
        remainingFriends.addAll(this.friends);
        block0: for (Object o : this.userRecords) {
            UserRole2 projectmember;
            if (o instanceof Friend) {
                remainingFriends.remove(o);
                continue;
            }
            if (o instanceof UserRole2) {
                projectmember = (UserRole2)o;
                for (Friend f : this.friends) {
                    if (!projectmember.getePPN().equalsIgnoreCase(f.getUsername())) continue;
                    remainingFriends.remove(f);
                    continue block0;
                }
                continue;
            }
            if (!(o instanceof UserDetail)) continue;
            projectmember = (UserDetail)o;
            for (Friend f : this.friends) {
                if (!projectmember.getEPPN().equalsIgnoreCase(f.getUsername())) continue;
                remainingFriends.remove(f);
                continue block0;
            }
        }
        this.userRecords.addAll(remainingFriends);
        if (refresh) {
            this.viewer.setInput(this.userRecords);
        }
    }

    private void hideFriendsFromViewer(boolean refresh) {
        for (Friend cand : this.friends) {
            if (roleMods.get(cand.getUsername()) != null && UserManagement2.roleMods.get((Object)cand.getUsername()).toBeAdded.size() > 0) continue;
            this.userRecords.remove(cand);
        }
        if (refresh) {
            this.viewer.setInput(this.userRecords);
        }
    }

    private void addSearchResultsToViewer(boolean refresh) {
        ArrayList<UserDetail> remainingSearchResults = new ArrayList<UserDetail>();
        remainingSearchResults.addAll(this.searchResults);
        block0: for (Object o : this.userRecords) {
            UserRole2 projectmember;
            if (o instanceof UserDetail) {
                remainingSearchResults.remove(o);
                continue;
            }
            if (o instanceof UserRole2) {
                projectmember = (UserRole2)o;
                for (UserDetail ud : this.searchResults) {
                    if (!projectmember.getePPN().equalsIgnoreCase(ud.getEPPN())) continue;
                    remainingSearchResults.remove(ud);
                    continue block0;
                }
                continue;
            }
            if (!(o instanceof Friend)) continue;
            projectmember = (Friend)o;
            for (UserDetail ud : this.searchResults) {
                if (!projectmember.getUsername().equalsIgnoreCase(ud.getEPPN())) continue;
                remainingSearchResults.remove(ud);
                continue block0;
            }
        }
        this.userRecords.addAll(remainingSearchResults);
        if (refresh) {
            this.viewer.setInput(this.userRecords);
            this.viewer.setSelection((ISelection)new StructuredSelection(remainingSearchResults), true);
        }
    }

    private void hideSearchResultsFromViewer(boolean refresh) {
        for (UserDetail cand : this.searchResults) {
            if (roleMods.get(cand.getEPPN()) != null && UserManagement2.roleMods.get((Object)cand.getEPPN()).toBeAdded.size() > 0) continue;
            this.userRecords.remove(cand);
        }
        if (refresh) {
            this.viewer.setInput(this.userRecords);
        }
    }

    public void setFocus() {
        if (this.mainComposite != null) {
            this.mainComposite.setFocus();
        }
    }

    public void dispose() {
        if (this.projectSelectedListener != null) {
            this.getSite().getPage().removeSelectionListener(this.projectSelectedListener);
        }
    }

    public static boolean canEdit(Object element, String thisrole) {
        if (currentProject.iAmLeader()) {
            return true;
        }
        if (element instanceof UserRole2) {
            UserRole2 user = (UserRole2)element;
            return user.getePPN().equalsIgnoreCase(RBACSession.getInstance().getEPPN()) && user.getRoles().contains(thisrole);
        }
        return false;
    }

    public static CheckState getCheckStateValue(Object element, String thisrole) {
        String ePPN;
        if (element instanceof UserRole2) {
            UserRole2 user = (UserRole2)element;
            if (user.getRoles().contains(thisrole)) {
                if (!UserManagement2.canEdit(element, thisrole)) {
                    return CheckState.DISABLEDONROLE;
                }
                if (roleMods.get(user.getePPN()) != null && UserManagement2.roleMods.get((Object)user.getePPN()).toBeRemoved.contains(thisrole)) {
                    return CheckState.MODIFIEDOFFROLE;
                }
                return CheckState.ONROLE;
            }
            if (!UserManagement2.canEdit(element, thisrole)) {
                return CheckState.DISABLEDOFFROLE;
            }
            if (roleMods.get(user.getePPN()) != null && UserManagement2.roleMods.get((Object)user.getePPN()).toBeAdded.contains(thisrole)) {
                return CheckState.MODIFIEDONROLE;
            }
            return CheckState.OFFROLE;
        }
        if (!UserManagement2.canEdit(element, thisrole)) {
            return CheckState.DISABLEDOFFROLE;
        }
        if (element instanceof Friend) {
            ePPN = ((Friend)element).getUsername();
        } else if (element instanceof UserDetail) {
            ePPN = ((UserDetail)element).getEPPN();
        } else {
            return null;
        }
        if (roleMods.get(ePPN) != null && UserManagement2.roleMods.get((Object)ePPN).toBeAdded.contains(thisrole)) {
            return CheckState.MODIFIEDONROLE;
        }
        return CheckState.OFFROLE;
    }

    public static void toggleCheckState(Object element, String thisrole) {
        String ePPN = IsInProjectColumnText;
        if (element instanceof UserRole2) {
            ePPN = ((UserRole2)element).getePPN();
        } else if (element instanceof UserDetail) {
            ePPN = ((UserDetail)element).getEPPN();
        } else if (element instanceof Friend) {
            ePPN = ((Friend)element).getUsername();
        }
        RoleModification presentRM = roleMods.get(ePPN);
        if (presentRM == null) {
            presentRM = new RoleModification();
        }
        if (UserManagement2.getCheckStateValue(element, thisrole) == CheckState.OFFROLE) {
            presentRM.toBeAdded.add(thisrole);
            roleMods.put(ePPN, presentRM);
        } else if (UserManagement2.getCheckStateValue(element, thisrole) == CheckState.ONROLE) {
            presentRM.toBeRemoved.add(thisrole);
            roleMods.put(ePPN, presentRM);
        } else if (UserManagement2.getCheckStateValue(element, thisrole) == CheckState.MODIFIEDOFFROLE) {
            presentRM.toBeRemoved.remove(thisrole);
            roleMods.put(ePPN, presentRM);
        } else if (UserManagement2.getCheckStateValue(element, thisrole) == CheckState.MODIFIEDONROLE) {
            presentRM.toBeAdded.remove(thisrole);
            roleMods.put(ePPN, presentRM);
        }
    }

    private void reloadFromRBAC(final TextGridProject tgp) {
        if (tgp == null) {
            this.viewHeading.setText(Messages.UserManagement2_PleaseSelectProject);
            this.userRecords.clear();
            roleMods.clear();
            if (this.currentJob != null) {
                this.currentJob.cancel();
            }
            this.viewer.refresh();
            this.viewer.setInput(this.userRecords);
            return;
        }
        this.viewHeading.setText(String.valueOf(tgp.getName().replaceAll("&", "&&")) + " (" + tgp.getId() + ")");
        if (this.currentJob != null) {
            this.currentJob.cancel();
        }
        this.currentJob = new Job(Messages.UserManagement2_ProjectUpdateUsersJobStatus){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.UserManagement2_ProjectUpdateRolesJobStatus, -1);
                UserManagement2.this.userRecords.clear();
                roleMods.clear();
                if (UserManagement2.this.rolesHaveChanged) {
                    UserManagement2.this.friends = RBACSession.getInstance().getFriends(true);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    UserManagement2.this.rolesHaveChanged = false;
                }
                ArrayList ur = tgp.getUserRoles2FromRBAC(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (ur != null && ur.size() > 0) {
                    UserManagement2.this.userRecords.addAll(ur);
                }
                monitor.worked(1);
                if (monitor.isCanceled() || UserManagement2.this.viewer.getTable().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                UserManagement2.this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (TableViewerColumn c : UserManagement2.this.roleColumns) {
                            c.getColumn().dispose();
                        }
                        (this).UserManagement2.this.viewer.refresh();
                        UserManagement2.this.roleColumns.clear();
                        UserManagement2.this.addRoleColumns((this).UserManagement2.this.viewer);
                        if (UserManagement2.this.showFriends) {
                            UserManagement2.this.addFriendsToViewer(false);
                        }
                        if (UserManagement2.this.showSearchResults) {
                            UserManagement2.this.addSearchResultsToViewer(false);
                        }
                        (this).UserManagement2.this.viewer.refresh();
                        (this).UserManagement2.this.viewer.setInput((Object)UserManagement2.this.userRecords);
                    }
                });
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.currentJob.setPriority(30);
        this.currentJob.schedule();
    }

    private void startSearch() {
        if (this.searchText.getText().length() > 0) {
            this.hideSearchResultsFromViewer(true);
            this.searchResults.clear();
            this.searchForUsers(this.searchText.getText());
            this.wantSearchResults.setSelection(true);
            this.showSearchResults = true;
        }
    }

    public void setProject(TextGridProject project) {
        if (project != null && project != currentProject) {
            currentProject = project;
            this.reloadFromRBAC(currentProject);
        }
    }

    private class EPPNLabelProvider
    extends ColumnLabelProvider {
        private EPPNLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof UserRole2) {
                UserRole2 ur = (UserRole2)obj;
                return ur.getePPN();
            }
            if (obj instanceof Friend) {
                Friend f = (Friend)obj;
                return f.getUsername();
            }
            if (obj instanceof UserDetail) {
                UserDetail ud = (UserDetail)obj;
                return ud.getEPPN();
            }
            return "no known class";
        }
    }

    private class IsInProjectLabelProvider
    extends ColumnLabelProvider {
        private IsInProjectLabelProvider() {
        }

        public String getText(Object obj) {
            return null;
        }

        public Image getImage(Object obj) {
            if (obj instanceof UserRole2) {
                return InProjectState.INPROJECT.icon();
            }
            if (obj instanceof Friend) {
                return InProjectState.CONTACT.icon();
            }
            return InProjectState.SEARCHED.icon();
        }
    }

    private class RoleCheckLabelProvider
    extends ColumnLabelProvider {
        private String role = null;

        private RoleCheckLabelProvider(String role) {
            this.role = role;
        }

        public String getText(Object obj) {
            return null;
        }

        public Image getImage(Object obj) {
            return UserManagement2.getCheckStateValue(obj, this.role).icon();
        }
    }

    private class UserNameLabelProvider
    extends ColumnLabelProvider {
        private UserNameLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof UserRole2) {
                UserRole2 ur = (UserRole2)obj;
                String a = RBACSession.getInstance().getFullName(ur.getePPN());
                return a;
            }
            if (obj instanceof Friend) {
                Friend f = (Friend)obj;
                return RBACSession.getInstance().getDetails(f.getUsername()).getName();
            }
            if (obj instanceof UserDetail) {
                UserDetail ud = (UserDetail)obj;
                return ud.getName();
            }
            return "no known class";
        }
    }
}

