/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.model;

import com.google.common.collect.ImmutableList;
import info.textgrid.lab.core.importexport.model.IImportEntryConfigurator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractImportEntryConfigurator
implements IImportEntryConfigurator {
    private static List<IImportEntryConfigurator> configurators;

    public static List<IImportEntryConfigurator> getConfigurators() {
        if (configurators == null) {
            IConfigurationElement[] configurationElements;
            ImmutableList.Builder builder = ImmutableList.builder();
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("info.textgrid.lab.core.importexport", "importEntryConfigurator");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    Object configurator = element.createExecutableExtension("class");
                    if (configurator != null && configurator instanceof IImportEntryConfigurator) {
                        builder.add((Object)((IImportEntryConfigurator)configurator));
                    }
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
                }
                ++n2;
            }
            configurators = builder.build();
        }
        return configurators;
    }

    protected int ask(String dialogTitle, String dialogMessage, int defaultButton, String ... dialogButtonLabels) {
        AskJob job = new AskJob(dialogTitle, dialogButtonLabels, defaultButton, dialogMessage, dialogTitle);
        if (Display.getCurrent() != null) {
            job.runInUIThread(null);
            return job.getDialogResult();
        }
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
        return job.getDialogResult();
    }

    private static final class AskJob
    extends UIJob {
        private final String[] dialogButtonLabels;
        private final int defaultButton;
        private final String dialogMessage;
        private final String dialogTitle;
        private int result;

        private AskJob(String name, String[] dialogButtonLabels, int defaultButton, String dialogMessage, String dialogTitle) {
            super(name);
            this.dialogButtonLabels = dialogButtonLabels;
            this.defaultButton = defaultButton;
            this.dialogMessage = dialogMessage;
            this.dialogTitle = dialogTitle;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            MessageDialog dialog = new MessageDialog(null, this.dialogTitle, null, this.dialogMessage, 3, this.dialogButtonLabels, this.defaultButton);
            this.result = dialog.open();
            return Status.OK_STATUS;
        }

        public int getDialogResult() {
            return this.result;
        }
    }
}

