/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.ui;

import info.textgrid.lab.core.importexport.ui.ImportPart;
import info.textgrid.lab.core.importexport.ui.Messages;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.DropSetValues;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.part.NullEditorInput;

public class ImportHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IWorkbenchWindow activeWorkbenchWindow;
            NullEditorInput input = null;
            TextGridProject project = null;
            ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (currentSelection != null && !currentSelection.isEmpty() && currentSelection instanceof IStructuredSelection) {
                Object firstElement = ((IStructuredSelection)currentSelection).getFirstElement();
                TextGridObject object = (TextGridObject)AdapterUtils.getAdapter((Object)firstElement, TextGridObject.class);
                if (object != null) {
                    if ("text/tg.imex+xml".equals(object.getContentTypeID())) {
                        input = (IEditorInput)AdapterUtils.getAdapter((Object)object, IEditorInput.class);
                    } else {
                        project = object.getProjectInstance();
                    }
                } else {
                    project = (TextGridProject)AdapterUtils.getAdapter((Object)firstElement, TextGridProject.class);
                }
            }
            if (input == null) {
                input = new NullEditorInput();
            }
            if ((activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event)) == null) {
                activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            final ImportPart editor = (ImportPart)activePage.openEditor((IEditorInput)input, "info.textgrid.lab.core.importexport.ImExEditor");
            if (project != null) {
                editor.setProject(project);
            }
            PlatformUI.getWorkbench().showPerspective("info.textgrid.lab.core.importexport.import", activeWorkbenchWindow);
            if ("true".equals(event.getParameters().get("info.textgrid.lab.core.importexport.import.usedroppedset")) && DropSetValues.getProject() != null) {
                editor.getProjectCombo().addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        ImportPart importPart = editor;
                        ((Object)((Object)importPart)).getClass();
                        importPart.new ImportPart.AddFilesJob(DropSetValues.getValues()).schedule();
                        editor.getProjectCombo().removeSelectionChangedListener(this);
                    }
                });
                editor.setProject(DropSetValues.getProject());
            }
        }
        catch (PartInitException e) {
            throw new ExecutionException(Messages.ImportHandler_could_not_open_editor, (Throwable)e);
        }
        catch (WorkbenchException e) {
            throw new ExecutionException(Messages.ImportHandler_could_not_open_editor, (Throwable)e);
        }
        catch (CoreException e) {
            throw new ExecutionException(Messages.ImportHandler_could_not_open_editor, (Throwable)e);
        }
        return null;
    }
}

