/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import info.textgrid.lab.core.model.TextGridProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectFileException
extends CoreException {
    private static final long serialVersionUID = 7584176592676754625L;
    public static String[] MESSAGES = new String[]{"Could not create the project file for the project {0}.", "Could not read the project file for the project {0}.", "Could not save the project file for the project {0}."};
    private Operation operation;
    private TextGridProject project;

    public Operation getOperation() {
        return this.operation;
    }

    public TextGridProject getProject() {
        return this.project;
    }

    public ProjectFileException(Operation operation, TextGridProject project, Throwable cause, String message, Object ... arguments) {
        super(ProjectFileException.createStatus(operation, project, cause, message, arguments));
        this.operation = operation;
        this.project = project;
    }

    public ProjectFileException(Operation operation, TextGridProject project, Throwable cause) {
        super(ProjectFileException.createStatus(operation, project, cause, null, new Object[0]));
        this.operation = operation;
        this.project = project;
    }

    protected static IStatus createStatus(Operation operation, TextGridProject project, Throwable cause, String message, Object ... arguments) {
        StringBuilder statusMessage = new StringBuilder();
        if (message != null) {
            statusMessage.append(NLS.bind((String)message, (Object[])arguments));
        }
        statusMessage.append(NLS.bind((String)("\n" + MESSAGES[operation.ordinal()]), (Object)project));
        Object status = cause instanceof CoreException ? new MultiStatus("info.textgrid.lab.core.model", operation.ordinal(), new IStatus[]{((CoreException)cause).getStatus()}, statusMessage.toString(), cause) : new Status(4, "info.textgrid.lab.core.model", operation.ordinal(), statusMessage.toString(), cause);
        return status;
    }

    public static enum Operation {
        CREATING,
        READING,
        SAVING;

    }
}

