/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.authn;

import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.Messages;
import info.textgrid.lab.authn.ModifyUserAttributesDialog;
import info.textgrid.lab.authn.PasswordDialog;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class UserIDDialog
extends TrayDialog {
    Label uidlabel;
    boolean shibUser = false;
    private Text sidText;

    public UserIDDialog(Shell shell) {
        super(shell);
        this.initialize();
    }

    public UserIDDialog(IShellProvider parentShell) {
        super(parentShell);
        this.initialize();
    }

    protected void initialize() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, -122, Messages.UserIDDialog_MyUserData, false);
        this.createButton(parent, -124, Messages.UserIDDialog_ChangePassword, false);
        this.createButton(parent, -127, Messages.UserIDDialog_ForgotPassword, false);
        this.createButton(parent, -123, Messages.UserIDDialog_ReAuthenticate, false);
        this.createButton(parent, -125, Messages.UserIDDialog_Logout, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true).setFocus();
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 12) {
            this.close();
        } else if (buttonId == -123) {
            String oldsid = RBACSession.getInstance().getSID(false);
            RBACSession.setSID("");
            RBACSession.neverAsk(false);
            RBACSession.getInstance().getSID(true);
            if ("".equals(RBACSession.getInstance().getSID(false))) {
                RBACSession.setSID(oldsid);
            }
            this.update();
        } else if (buttonId == -125) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            page.saveAllEditors(true);
            String ePPN = RBACSession.getInstance().getEPPN();
            if (!"".equals(ePPN) && ePPN.indexOf("@textgrid.de") == -1) {
                this.shibUser = true;
            }
            RBACSession.setSID("");
            RBACSession.setEPPN("");
            AuthBrowser.notifySIDListeners("", "");
            this.update();
            this.shibUser = false;
            this.close();
        } else if (buttonId == -124) {
            PasswordDialog pwd = new PasswordDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            pwd.open();
        } else if (buttonId == -122) {
            ModifyUserAttributesDialog udd = new ModifyUserAttributesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            udd.open();
        } else if (buttonId == -127) {
            URL pwrurl = null;
            try {
                ConfClient confClient = ConfClient.getInstance();
                String pwrurlString = confClient.getValue("PasswordReset");
                pwrurl = URI.create(pwrurlString).toURL();
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser(128, "xyz123abc456", "Hallo", "egal").openURL(pwrurl);
                MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 34);
                mb.setText(Messages.UserIDDialog_ResettingPassword);
                mb.setMessage(Messages.UserIDDialog_WebBrowserNotice);
                mb.open();
            }
            catch (OfflineException e) {
                OnlineStatus.netAccessFailed((String)Messages.UserIDDialog_CouldNotContactConfserv, (Throwable)e);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        GridDataFactory labelsFactory = GridDataFactory.createFrom((GridData)gridData);
        labelsFactory.applyTo((Control)parent);
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout());
        g.setText(Messages.UserIDDialog_CurrentUserID);
        labelsFactory.applyTo((Control)g);
        gridData.heightHint = 50;
        this.uidlabel = new Label((Composite)g, 0x1000000);
        this.uidlabel.setLayoutData((Object)gridData);
        Group sidGroup = new Group(parent, 0);
        sidGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        sidGroup.setLayout((Layout)new GridLayout(1, false));
        sidGroup.setText(Messages.UserIDDialog_CurrentSessionID);
        this.sidText = new Text((Composite)sidGroup, 16396);
        this.sidText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sidText.setToolTipText(Messages.UserIDDialog_SessionIDExplanation);
        this.update();
        return g;
    }

    private void update() {
        String uid = RBACSession.getInstance().getEPPN();
        this.sidText.setText(RBACSession.getInstance().getSID(false));
        if (this.shibUser) {
            this.uidlabel.setText(Messages.UserIDDialog_LogoutImpossible);
        } else if (uid.equals("")) {
            this.uidlabel.setText(Messages.UserIDDialog_NotAuthenticated);
        } else {
            this.uidlabel.setText(uid);
        }
        this.uidlabel.pack();
    }
}

