/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.multicharbrowser;

import info.textgrid.lab.xmleditor.multicharbrowser.UnicodeView;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ComboContributionItem
extends ContributionItem
implements IContributionItem {
    private Combo layersCombo;
    private List<String> texts;
    private Control comboBox;
    private UnicodeView unicodeView;
    private int selectedBlock = 95;
    private int selectedScript = 38;
    public ToolItem item;

    public ComboContributionItem(List<String> texts, UnicodeView unicodeView) {
        this.texts = texts;
        this.setId("ComboContributionItem");
        this.unicodeView = unicodeView;
    }

    public void fill(Composite parent) {
        this.createLayersCombo(parent);
    }

    public void fill(ToolBar parent, int index) {
        this.item = new ToolItem(parent, 2);
        this.comboBox = this.createLayersCombo((Composite)parent);
        this.comboBox.pack();
        this.updateItems(this.texts);
        this.item.setWidth(125);
        this.item.setControl(this.comboBox);
        parent.pack(true);
        parent.layout(true, true);
    }

    private Control createLayersCombo(Composite parent) {
        this.layersCombo = new Combo(parent, 8);
        int i = 0;
        while (i < this.texts.size()) {
            this.layersCombo.add(this.texts.get(i));
            ++i;
        }
        this.layersCombo.select(this.selectedBlock);
        this.layersCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.layersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComboContributionItem.this.unicodeView.getToggleState() == 1) {
                    ComboContributionItem.this.selectedBlock = ComboContributionItem.this.layersCombo.getSelectionIndex();
                    ComboContributionItem.this.unicodeView.changeCharacterSet(ComboContributionItem.this.layersCombo.getItem(ComboContributionItem.this.layersCombo.getSelectionIndex()), true);
                } else if (ComboContributionItem.this.unicodeView.getToggleState() == 2) {
                    ComboContributionItem.this.selectedScript = ComboContributionItem.this.layersCombo.getSelectionIndex();
                    ComboContributionItem.this.unicodeView.changeCharacterSet(ComboContributionItem.this.layersCombo.getItem(ComboContributionItem.this.layersCombo.getSelectionIndex()), false);
                }
            }
        });
        return this.layersCombo;
    }

    public void updateItems(List<String> texts) {
        if (this.layersCombo != null) {
            this.texts = texts;
            this.layersCombo.removeAll();
            for (String entry : texts) {
                this.layersCombo.add(entry);
            }
            int entryIndex = 0;
            if (this.unicodeView.getToggleState() != 1 && this.layersCombo.getItemCount() >= this.selectedBlock) {
                entryIndex = this.selectedBlock;
            } else if (this.unicodeView.getToggleState() != 2 && this.layersCombo.getItemCount() >= this.selectedScript) {
                entryIndex = this.selectedScript;
            }
            this.setComboContribSelection(entryIndex);
        }
    }

    public void setComboContribSelection(int entryIndex) {
        if (this.unicodeView.getToggleState() != 1 && this.layersCombo.getItemCount() >= entryIndex) {
            this.selectedBlock = entryIndex;
            this.layersCombo.select(this.selectedBlock);
        } else if (this.unicodeView.getToggleState() != 2 && this.layersCombo.getItemCount() >= entryIndex) {
            this.selectedScript = entryIndex;
            this.layersCombo.select(this.selectedScript);
        }
    }

    public void setComboContribSelection(String entryString) {
        String[] blockArray = this.layersCombo.getItems();
        int i = 0;
        while (i < this.layersCombo.getItemCount()) {
            if (blockArray[i].equalsIgnoreCase(entryString)) {
                this.setComboContribSelection(i);
                break;
            }
            ++i;
        }
    }

    public Control getComboBox() {
        return this.comboBox;
    }

    public Combo getLayersCombo() {
        return this.layersCombo;
    }
}

