/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search;

import info.textgrid.lab.core.model.IChildListChangedListener;
import info.textgrid.lab.core.model.IChildListParent;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.DeferredTreeContentManager;

public class DeferredTreeContentProvider
implements ITreeContentProvider,
IChildListChangedListener {
    private DeferredTreeContentManager manager;
    private Viewer viewer;
    private IChildListParent input;

    private void assertValidManager() throws IllegalStateException {
        if (this.manager == null) {
            throw new IllegalStateException("This DeferredTreeContentManager does not have a valid manager. Please associate it with a valid AbstractTreeViewer first and call setInput() on the TreeViewer before calling any methods on the content provider.");
        }
    }

    public Object[] getChildren(Object parentElement) {
        return this.manager == null ? new Object[]{} : this.manager.getChildren(parentElement);
    }

    public DeferredTreeContentManager getManager() {
        return this.manager;
    }

    public Object getParent(Object element) throws IllegalStateException {
        this.assertValidManager();
        return this.manager.getChildren(element);
    }

    public boolean hasChildren(Object element) throws IllegalStateException {
        this.assertValidManager();
        return this.manager.mayHaveChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        if (this.input != null) {
            this.input.removeChildListChangedListener((IChildListChangedListener)this);
        }
    }

    public void cancel(Object input) {
        if (this.manager != null) {
            this.manager.cancel(input);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.input != newInput && newInput instanceof IChildListParent) {
            if (this.input != null) {
                this.input.removeChildListChangedListener((IChildListChangedListener)this);
            }
            this.input = (IChildListParent)newInput;
            this.input.addChildListChangedListener((IChildListChangedListener)this);
        }
        if (viewer instanceof AbstractTreeViewer) {
            if (viewer != this.viewer) {
                this.viewer = viewer;
                this.manager = new DeferredTreeContentManager((AbstractTreeViewer)viewer);
            }
        } else {
            throw new IllegalArgumentException(MessageFormat.format("DeferredTreeContentManager must be associated with an AbstractTreeViewer, not an {0} like {1}", viewer.getClass(), viewer));
        }
    }

    public void childListChanged(IChildListParent parent) {
        if (this.viewer != null) {
            this.viewer.setInput((Object)parent);
        }
    }
}

