/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search;

import com.google.common.collect.Lists;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.search.Activator;
import info.textgrid.lab.search.FullTextEntry;
import info.textgrid.lab.search.ItemEntry;
import info.textgrid.lab.search.NoMatchEntry;
import info.textgrid.lab.search.ResultViewInitItem;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.middleware.tgsearch.FulltextType;
import info.textgrid.namespaces.middleware.tgsearch.PathGroupType;
import info.textgrid.namespaces.middleware.tgsearch.PathType;
import info.textgrid.namespaces.middleware.tgsearch.Response;
import info.textgrid.namespaces.middleware.tgsearch.ResultType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class LazySearchResultProvider
implements ILazyTreeContentProvider {
    private static final int CHUNK_SIZE = 50;
    private TreeViewer treeViewer;
    private SearchRequest input;
    private volatile int maxResult = -1;
    private List<Object> cache = null;
    private Set<Integer> requestedItems = Collections.synchronizedSet(new HashSet());
    private SearchRequestJob searchRequestJob;
    private boolean isChildCountSet = false;

    protected synchronized List<Object> getCache() {
        if (this.cache == null) {
            this.cache = Collections.synchronizedList(Lists.newArrayListWithExpectedSize((int)100));
        }
        return this.cache;
    }

    public void dispose() {
        if (this.searchRequestJob != null && this.searchRequestJob.getState() != 0) {
            this.searchRequestJob.cancel();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Assert.isLegal((boolean)(viewer instanceof TreeViewer), (String)"LazySearchResultProvider can only be used with an TreeViewer.");
        this.treeViewer = (TreeViewer)viewer;
        this.isChildCountSet = false;
        if (newInput instanceof SearchRequest) {
            this.input = (SearchRequest)((Object)newInput);
            this.initiateSearchRequest(this.input);
        } else if (newInput instanceof ResultViewInitItem) {
            this.treeViewer.setChildCount(newInput, 1);
            this.treeViewer.replace(newInput, 0, (Object)this.getPendingUpdateAdapter());
            this.treeViewer.refresh(true);
        }
    }

    private void initiateSearchRequest(SearchRequest searchRequest) {
        this.getCache().clear();
        this.maxResult = -1;
        this.treeViewer.setChildCount((Object)this.input, 1);
        this.treeViewer.replace((Object)this.input, 0, (Object)this.getPendingUpdateAdapter());
        this.treeViewer.refresh();
        if (this.searchRequestJob != null && this.searchRequestJob.getState() != 0) {
            this.searchRequestJob.cancel();
        }
        this.requestedItems.clear();
        searchRequest.getSearchClient().setLIMIT(50);
        this.searchRequestJob = new SearchRequestJob(searchRequest);
        this.searchRequestJob.schedule();
    }

    protected void flushRequestedResults() {
        new UIJob("Displaying results ..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Iterator iterator = LazySearchResultProvider.this.requestedItems.iterator();
                while (iterator.hasNext()) {
                    Integer index = (Integer)iterator.next();
                    if (index > LazySearchResultProvider.this.maxResult) continue;
                    try {
                        Object element = LazySearchResultProvider.this.getCache().get(index);
                        LazySearchResultProvider.this.treeViewer.replace((Object)LazySearchResultProvider.this.input, index.intValue(), element);
                        iterator.remove();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                }
                LazySearchResultProvider.this.treeViewer.getTree().redraw();
                StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.search", "Redrew search result tree"));
                if (!LazySearchResultProvider.this.requestedItems.isEmpty() && LazySearchResultProvider.this.searchRequestJob.getState() == 0) {
                    LazySearchResultProvider.this.searchRequestJob.schedule();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void addResult(Object tgoRef) {
        this.getCache().add(tgoRef);
        ++this.maxResult;
    }

    public void updateElement(Object parent, int index) {
        if (parent == this.input) {
            if (index <= this.maxResult) {
                this.treeViewer.replace(parent, index, this.getCache().get(index));
            } else {
                this.requestedItems.add(index);
                if (this.searchRequestJob.getState() == 0) {
                    this.searchRequestJob.schedule();
                }
                if (index == this.maxResult + 1) {
                    this.treeViewer.replace(parent, index, (Object)this.getPendingUpdateAdapter());
                }
            }
        } else {
            Object[] children;
            IDeferredWorkbenchAdapter adapter = (IDeferredWorkbenchAdapter)AdapterUtils.getAdapter((Object)parent, IDeferredWorkbenchAdapter.class);
            if (adapter != null && (children = adapter.getChildren(parent)) != null) {
                this.treeViewer.replace(parent, index, children[index]);
            }
        }
    }

    private PendingUpdateAdapter getPendingUpdateAdapter() {
        return new PendingUpdateAdapter();
    }

    public void updateChildCount(Object element, int currentChildCount) {
        if (element == this.input) {
            if (this.searchRequestJob.isPending() && currentChildCount == 0) {
                this.treeViewer.setChildCount(element, 1);
            } else {
                this.treeViewer.setChildCount(element, this.searchRequestJob.childCount);
            }
        }
    }

    public Object getParent(Object element) {
        if (element == this.input) {
            return null;
        }
        return this.input;
    }

    private final class SearchRequestJob
    extends Job {
        private final SearchRequest searchRequest;
        private boolean finished;
        private boolean pending;
        private int childCount;

        private SearchRequestJob(SearchRequest query) {
            super(NLS.bind((String)"Performing {0} ...", (Object)((Object)query)));
            this.finished = false;
            this.pending = true;
            this.childCount = 0;
            this.searchRequest = query;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Response result;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)150);
            if (this.finished) {
                return new Status(2, "info.textgrid.lab.search", NLS.bind((String)"Already returned all {0} results visible to you of {1}", (Object)LazySearchResultProvider.this.maxResult, (Object)((Object)this.searchRequest)));
            }
            progress.subTask("Sending query ...");
            int start = 0;
            if (LazySearchResultProvider.this.requestedItems.iterator().hasNext()) {
                start = (Integer)LazySearchResultProvider.this.requestedItems.iterator().next();
            }
            if ((result = this.searchRequest.execute((IProgressMonitor)progress.newChild(40), start, 50)) == null) {
                return Status.CANCEL_STATUS;
            }
            progress.subTask("Retrieving results ...");
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            progress.worked(5);
            Iterator childElements = result.getResult().iterator();
            progress.worked(5);
            this.setPending(false);
            int itemCount = 0;
            int fulltextCount = 0;
            while (childElements.hasNext()) {
                List kwicList;
                if (progress.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ResultType obj = (ResultType)childElements.next();
                ObjectType oType = obj.getObject();
                boolean hasPath = false;
                int pathCount = 0;
                try {
                    kwicList = ((FulltextType)obj.getFulltext().get(0)).getKwic();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    kwicList = null;
                }
                try {
                    ItemEntry entry;
                    TextGridObject tgo = TextGridObject.getInstance((ObjectType)oType, (boolean)true, (boolean)true);
                    TGObjectReference tgoRef = new TGObjectReference(tgo.getLatestURI(), tgo);
                    if (obj.getPathResponse() != null) {
                        for (PathGroupType pathGroup : obj.getPathResponse().getPathGroup()) {
                            for (PathType pathType : pathGroup.getPath()) {
                                entry = new ItemEntry(tgoRef, pathType);
                                LazySearchResultProvider.this.addResult((Object)entry);
                                if (pathCount > 0) {
                                    ++itemCount;
                                }
                                ++pathCount;
                                hasPath = true;
                            }
                        }
                    }
                    progress.worked(1);
                    if (!hasPath) {
                        entry = new ItemEntry(tgoRef, null);
                        LazySearchResultProvider.this.addResult((Object)entry);
                    }
                    if (kwicList == null) continue;
                    for (FulltextType.Kwic item : kwicList) {
                        FullTextEntry fulltextEntry = new FullTextEntry(tgoRef, item.getLeft(), item.getMatch(), item.getRight(), item.getXpath());
                        ++fulltextCount;
                        LazySearchResultProvider.this.addResult((Object)fulltextEntry);
                    }
                }
                catch (CoreException e) {
                    Status status = new Status(4, "info.textgrid.lab.search", NLS.bind((String)"Error when trying to insert object {0} in search result.", (Object)oType.toString()), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
            try {
                this.childCount = Integer.parseInt(result.getHits());
            }
            catch (NumberFormatException numberFormatException) {
                this.childCount = 0;
            }
            this.childCount = this.childCount + fulltextCount + itemCount;
            if (this.childCount == 0) {
                LazySearchResultProvider.this.addResult((Object)new NoMatchEntry());
                this.childCount = 1;
            }
            if (!LazySearchResultProvider.this.isChildCountSet) {
                this.setResultCount(this.childCount);
            }
            if (this.childCount < 47) {
                this.finish();
            }
            LazySearchResultProvider.this.flushRequestedResults();
            return Status.OK_STATUS;
        }

        private void finish() {
            this.finished = true;
        }

        private void setResultCount(final int allHits) {
            UIJob resultCount = new UIJob("Setting result count"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    PlatformUI.getWorkbench().getDisplay().update();
                    monitor.beginTask("Set Result Count", 1000);
                    monitor.subTask("SubTask");
                    int i = 1;
                    while (i < 1000) {
                        monitor.worked(1);
                        ++i;
                    }
                    LazySearchResultProvider.this.treeViewer.setChildCount((Object)LazySearchResultProvider.this.input, allHits);
                    LazySearchResultProvider.this.treeViewer.refresh(true);
                    if (Activator.isDebugging("info.textgrid.lab.search/debug/lazy-query")) {
                        System.out.println("Adjusted hit count to " + allHits);
                    }
                    LazySearchResultProvider.this.isChildCountSet = true;
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            resultCount.setUser(true);
            resultCount.schedule();
        }

        protected synchronized void setPending(boolean pending) {
            this.pending = pending;
        }

        protected synchronized boolean isPending() {
            return this.pending;
        }
    }
}

