/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.swtutils;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public abstract class AdapterUtils {
    public static <T> T getAdapter(Object source, Class<T> type) {
        if (source == null) {
            return null;
        }
        if (type.isInstance(source)) {
            return (T)source;
        }
        if (source instanceof IAdaptable) {
            return (T)((IAdaptable)source).getAdapter(type);
        }
        return (T)Platform.getAdapterManager().getAdapter(source, type);
    }

    public static <T> T getAdapterChecked(Object source, Class<T> type) throws AdapterNotFoundException {
        T adapter = AdapterUtils.getAdapter(source, type);
        if (adapter == null) {
            throw new AdapterNotFoundException(source, type);
        }
        return adapter;
    }

    public static <T> T[] getAdapters(Object[] sources, Class<T> type, boolean withNulls) {
        ArrayList<T> result = new ArrayList<T>(sources.length);
        Object[] objectArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            Object source = objectArray[n2];
            T target = AdapterUtils.getAdapter(source, type);
            if (withNulls || target != null) {
                result.add(target);
            }
            ++n2;
        }
        return result.toArray((Object[])Array.newInstance(type, 0));
    }

    public static class AdapterNotFoundException
    extends CoreException {
        private static final long serialVersionUID = -4244601168380258375L;
        private Class<?> type;
        private Object source;

        public Class<?> getType() {
            return this.type;
        }

        public Object getSource() {
            return this.source;
        }

        public AdapterNotFoundException(Object source, Class<?> type) {
            super((IStatus)new Status(4, "info.textgrid.lab.core.swtutils", MessageFormat.format("Could not adapt {0} ({1}) to {2}.", source, source.getClass(), type)));
            this.source = source;
            this.type = type;
        }
    }
}

