/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.swtutils;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Text;

public class TextFieldDecorator
implements FocusListener {
    private final Text control;
    private final String message;
    private String defaultString = "";
    private boolean displaying = false;
    private Color defaultForeground;
    private Color messageForeground;

    public TextFieldDecorator(Text control, String message) {
        this.control = control;
        this.message = message;
        this.messageForeground = control.getDisplay().getSystemColor(15);
        control.addFocusListener((FocusListener)this);
        this.addDecoration();
    }

    public void focusGained(FocusEvent e) {
        if (this.displaying) {
            this.removeDecoration();
        }
    }

    public void focusLost(FocusEvent e) {
        if (this.defaultString.equals(this.control.getText())) {
            this.addDecoration();
        }
    }

    public String getText() {
        if (this.displaying) {
            return this.defaultString;
        }
        return this.control.getText();
    }

    private void removeDecoration() {
        this.control.setText(this.defaultString);
        this.control.setForeground(this.defaultForeground);
        this.displaying = false;
    }

    private void addDecoration() {
        this.control.setText(this.message);
        this.control.setForeground(this.messageForeground);
        this.displaying = true;
    }

    public void dispose() {
        this.control.removeFocusListener((FocusListener)this);
    }
}

