/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.swtutils.annotations;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import info.textgrid.lab.core.swtutils.Activator;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;

public class AnnotationContentProvider
implements IStructuredContentProvider,
IAnnotationModelListenerExtension,
IAnnotationModelListener {
    private AbstractTableViewer viewer;
    private Predicate<Annotation> filter;
    private IAnnotationModel annotationModel;

    public void setFilter(Predicate<Annotation> filter) {
        this.filter = filter;
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    protected Iterator<Annotation> filter(Iterator<Annotation> unfiltered) {
        if (this.filter == null) {
            return unfiltered;
        }
        return Iterators.filter(unfiltered, this.filter);
    }

    protected Annotation[] filter(Annotation[] unfiltered) {
        if (this.filter == null) {
            return unfiltered;
        }
        return (Annotation[])Iterators.toArray((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])unfiltered), this.filter), Annotation.class);
    }

    public void dispose() {
        if (this.annotationModel != null) {
            this.annotationModel.removeAnnotationModelListener((IAnnotationModelListener)this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Assert.isLegal((boolean)(viewer instanceof AbstractTableViewer), (String)"AnnotationContentProvider must be used with a Table Viewer.");
        this.viewer = (AbstractTableViewer)viewer;
        if (oldInput != null && oldInput instanceof IAnnotationModel) {
            ((IAnnotationModel)oldInput).removeAnnotationModelListener((IAnnotationModelListener)this);
            this.annotationModel = null;
        }
        if (newInput != null && newInput instanceof IAnnotationModel) {
            this.annotationModel = (IAnnotationModel)newInput;
            this.annotationModel.addAnnotationModelListener((IAnnotationModelListener)this);
        }
        if (!viewer.getControl().isDisposed()) {
            viewer.refresh();
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IAnnotationModel) {
            Iterator annotationIterator = ((IAnnotationModel)inputElement).getAnnotationIterator();
            Object[] annotations = (Annotation[])Iterators.toArray(this.filter(annotationIterator), Annotation.class);
            return annotations;
        }
        return null;
    }

    public void modelChanged(final AnnotationModelEvent event) {
        UIJob refreshJob = new UIJob("Refreshing annotation view"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (AnnotationContentProvider.this.viewer == null || AnnotationContentProvider.this.viewer.getControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (event.isWorldChange()) {
                        AnnotationContentProvider.this.viewer.refresh();
                    } else {
                        AnnotationContentProvider.this.viewer.add((Object[])AnnotationContentProvider.this.filter(event.getAddedAnnotations()));
                        AnnotationContentProvider.this.viewer.remove((Object[])AnnotationContentProvider.this.filter(event.getRemovedAnnotations()));
                        Annotation[] annotationArray = AnnotationContentProvider.this.filter(event.getChangedAnnotations());
                        int n = annotationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Annotation changedAnnotation = annotationArray[n2];
                            AnnotationContentProvider.this.viewer.refresh((Object)changedAnnotation, true);
                            ++n2;
                        }
                    }
                    return Status.OK_STATUS;
                }
                catch (RuntimeException e) {
                    Activator.handleError(e, "Exception refreshing annotation view for event {0}", event);
                    throw e;
                }
            }
        };
        refreshJob.setSystem(true);
        refreshJob.schedule();
    }

    public void modelChanged(IAnnotationModel model) {
        this.viewer.refresh();
    }
}

