/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.dictionarylinkeditor.views;

import info.textgrid.lab.dictionarylinkeditor.WBLink;
import info.textgrid.lab.dictionarylinkeditor.views.DictionaryLinkEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class WBLinkEditingSupport
extends EditingSupport {
    private CellEditor editor;
    private int column;

    public WBLinkEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        String[] semanticRelations = DictionaryLinkEditor.semanticRelations;
        String[] etymRelations = DictionaryLinkEditor.etymRelations;
        switch (column) {
            case 0: {
                this.editor = new CheckboxCellEditor(null, 32);
                break;
            }
            case 5: {
                this.editor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), semanticRelations);
                break;
            }
            case 6: {
                this.editor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), etymRelations);
                break;
            }
            case 8: {
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            default: {
                this.editor = null;
            }
        }
        this.column = column;
    }

    protected boolean canEdit(Object element) {
        WBLink wbl = (WBLink)element;
        return !wbl.immutable(DictionaryLinkEditor.whoIsLoggedIn);
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected Object getValue(Object element) {
        WBLink wbl = (WBLink)element;
        switch (this.column) {
            case 0: {
                return wbl.isTouched();
            }
            case 1: {
                return null;
            }
            case 2: {
                return wbl.getTargetLemma().getName();
            }
            case 3: {
                return wbl.getTargetLemma().getWbShortName();
            }
            case 4: {
                return wbl.getQualityStringFromID();
            }
            case 5: {
                return wbl.getSemanticRelationID();
            }
            case 6: {
                return wbl.getEtymRelationID();
            }
            case 7: {
                return wbl.getEditor();
            }
            case 8: {
                return wbl.getComment();
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        WBLink wbl = (WBLink)element;
        switch (this.column) {
            case 0: {
                if (wbl.immutable(DictionaryLinkEditor.whoIsLoggedIn)) break;
                wbl.touch((Boolean)value);
                break;
            }
            case 5: {
                wbl.setSemanticRelationID((Integer)value);
                break;
            }
            case 6: {
                wbl.setEtymRelationID((Integer)value);
                break;
            }
            case 8: {
                wbl.setComment((String)value);
            }
        }
        this.getViewer().update(element, null);
    }
}

