/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.dictionarysearch.views;

import info.textgrid.lab.core.browserfix.TextGridLabBrowser;
import info.textgrid.lab.dictionarysearch.DSDictionaryWords;
import info.textgrid.lab.dictionarysearch.views.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class DictionaryBrowserView
extends ViewPart
implements ISelectionListener {
    public static String ID = "info.textgrid.lab.dictionarysearch.views.DictionaryBrowserView";
    protected Browser browser;
    private DSDictionaryWords dictionary;

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.browser = TextGridLabBrowser.createBrowser((Composite)parent);
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                StringBuilder msg = new StringBuilder();
                if (DictionaryBrowserView.this.dictionary != null) {
                    msg.append(DictionaryBrowserView.this.dictionary.getAssociatedExactLemma().getName()).append(" (").append(DictionaryBrowserView.this.dictionary.getName()).append("), ");
                }
                int percent = 0;
                percent = event.total == 0 ? 100 : 100 * (event.current / event.total);
                msg.append(percent).append('%');
                DictionaryBrowserView.this.setContentDescription(msg.toString());
            }

            public void completed(ProgressEvent event) {
                DictionaryBrowserView.this.showBusy(false);
                StringBuilder msg = new StringBuilder();
                if (DictionaryBrowserView.this.dictionary != null) {
                    msg.append(DictionaryBrowserView.this.dictionary.getAssociatedExactLemma().getName()).append(" (").append(DictionaryBrowserView.this.dictionary.getName()).append(')');
                }
            }
        });
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.browser.setText(String.valueOf(Messages.DictionaryBrowserView_Message_1) + Messages.DictionaryBrowserView_Message_2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.dictionarysearch.DescriptionGridView");
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof DSDictionaryWords) {
            this.dictionary = (DSDictionaryWords)o;
            this.setContentDescription(String.valueOf(this.dictionary.getAssociatedExactLemma().getName()) + "(" + this.dictionary.getName() + ")");
            this.showBusy(true);
            UIJob job = new UIJob("Showing Entry for selected Dictionary-Object"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    block3: {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            DictionaryBrowserView.this.browser.setUrl(String.valueOf(DictionaryBrowserView.this.dictionary.getHref()) + "#navigation");
                        }
                        catch (SWTException e) {
                            if (e.getMessage() != "ERROR_WIDGET_DISPOSED") break block3;
                            System.out.println("AHAAAAAAAAAAAAAAAAAAAAAAA");
                            return Status.CANCEL_STATUS;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

