/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.legacy;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import info.textgrid._import.ImportObject;
import info.textgrid._import.RewriteMethod;
import info.textgrid.lab.core.importexport.model.ISpecialImportEntrySupplier;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import info.textgrid.lab.core.importexport.model.ImportModel;
import info.textgrid.lab.core.importexport.model.Messages;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.namespaces.metadata.core._2010.IdentifierType;
import info.textgrid.utils.linkrewriter.ConfigurableXMLRewriter;
import info.textgrid.utils.linkrewriter.ImportMapping;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class LegacyRewritingSupplier
implements ISpecialImportEntrySupplier {
    private ImportEntry entry;

    public LegacyRewritingSupplier(ImportEntry entry) {
        this.entry = entry;
    }

    protected ImportMapping getMapping(ImportModel model) {
        ImportMapping mapping = new ImportMapping();
        for (ImportObject entry0 : model.getImportObject()) {
            ImportEntry entry = (ImportEntry)entry0;
            try {
                List identifiers = entry.getObject().getMetadataForReading().getGeneric().getProvided().getIdentifier();
                String oldURI = ((IdentifierType)Iterables.find((Iterable)identifiers, (Predicate)new Predicate<IdentifierType>(){

                    public boolean apply(IdentifierType identifier) {
                        return "textgrid-beta".equals(identifier.getType());
                    }
                })).getValue();
                mapping.add(oldURI, entry.getLocalData(), entry.getLocalMetadata(), RewriteMethod.NONE);
            }
            catch (CrudServiceException e) {
                StatusManager.getManager().handle((CoreException)e, "info.textgrid.lab.core.importexport.legacy");
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        return mapping;
    }

    public InputStream getInputStream() throws IOException {
        if (this.entry.getRewriteMethod().equals((Object)RewriteMethod.NONE)) {
            return new FileInputStream(this.entry.getLocalFile());
        }
        final ImportMapping mapping = this.getMapping(this.entry.getModel());
        System.out.println(mapping);
        final PipedOutputStream outputStream = new PipedOutputStream();
        Thread rewriteThread = new Thread(String.valueOf(Messages.ImportModel_Rewriting) + this.entry.getLocalData()){

            @Override
            public void run() {
                try {
                    try {
                        FileInputStream localFileStream = new FileInputStream(LegacyRewritingSupplier.this.entry.getLocalFile());
                        ConfigurableXMLRewriter rewriter = new ConfigurableXMLRewriter(mapping, true);
                        rewriter.recordMissingReferences();
                        rewriter.configure(new URI(LegacyRewritingSupplier.this.entry.getRewriteConfig()));
                        rewriter.rewrite((InputStream)localFileStream, (OutputStream)outputStream);
                        System.err.println("Missing references -- legacy import: " + rewriter.getMissingReferences());
                    }
                    catch (Exception e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport.legacy", NLS.bind((String)Messages.LegacyRewritingSupplier_FailedToRewriteLegacyFile, (Object)LegacyRewritingSupplier.this.entry.getLocalData(), (Object)e.getLocalizedMessage()), (Throwable)e));
                        try {
                            outputStream.close();
                        }
                        catch (IOException e2) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport.legacy", NLS.bind((String)Messages.LegacyRewritingSupplier_FailedToRewriteLegacyFile, (Object)LegacyRewritingSupplier.this.entry.getLocalData(), (Object)e2.getLocalizedMessage()), (Throwable)e2));
                        }
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport.legacy", NLS.bind((String)Messages.LegacyRewritingSupplier_FailedToRewriteLegacyFile, (Object)LegacyRewritingSupplier.this.entry.getLocalData(), (Object)e.getLocalizedMessage()), (Throwable)e));
                    }
                }
            }
        };
        PipedInputStream inputStream = new PipedInputStream(outputStream);
        rewriteThread.start();
        return inputStream;
    }

    public File getFile() {
        return this.entry.getLocalFile();
    }
}

